/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.walletsdk.horizon.transaction;

import java.math.BigDecimal;
import java.util.List;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.ChangeTrustAsset;
import org.stellar.sdk.ChangeTrustOperation;
import org.stellar.sdk.CreateAccountOperation;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Operation;
import org.stellar.sdk.SetOptionsOperation;
import org.stellar.sdk.Signer;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.walletsdk.asset.IssuedAssetId;
import org.stellar.walletsdk.horizon.AccountKeyPair;
import org.stellar.walletsdk.horizon.transaction.CommonTransactionBuilderKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\u00028\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ-\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u0004H\u0004\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\"\u0010#J\u000b\u0010$\u001a\u00028\u0000\u00a2\u0006\u0002\u0010%J\u0013\u0010&\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010'J\u0013\u0010(\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010)J#\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0011\u00a2\u0006\u0002\u0010.R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0012\n\u0005\b\u009920\u0001\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Lorg/stellar/walletsdk/horizon/transaction/CommonTransactionBuilder;", "T", "", "sourceAddress", "", "(Ljava/lang/String;)V", "operations", "", "Lorg/stellar/sdk/Operation;", "getOperations", "()Ljava/util/List;", "getSourceAddress", "()Ljava/lang/String;", "addAccountSigner", "signerAddress", "Lorg/stellar/walletsdk/horizon/AccountKeyPair;", "signerWeight", "", "(Lorg/stellar/walletsdk/horizon/AccountKeyPair;I)Ljava/lang/Object;", "addAssetSupport", "asset", "Lorg/stellar/walletsdk/asset/IssuedAssetId;", "trustLimit", "(Lorg/stellar/walletsdk/asset/IssuedAssetId;Ljava/lang/String;)Ljava/lang/Object;", "building", "body", "Lkotlin/Function0;", "building$wallet_sdk", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "doCreateAccount", "Lorg/stellar/sdk/CreateAccountOperation;", "newAccount", "startingBalance", "Lkotlin/ULong;", "doCreateAccount-z13BHRw", "(Lorg/stellar/walletsdk/horizon/AccountKeyPair;JLjava/lang/String;)Lorg/stellar/sdk/CreateAccountOperation;", "lockAccountMasterKey", "()Ljava/lang/Object;", "removeAccountSigner", "(Lorg/stellar/walletsdk/horizon/AccountKeyPair;)Ljava/lang/Object;", "removeAssetSupport", "(Lorg/stellar/walletsdk/asset/IssuedAssetId;)Ljava/lang/Object;", "setThreshold", "low", "medium", "high", "(III)Ljava/lang/Object;", "wallet-sdk"})
@SourceDebugExtension(value={"SMAP\nCommonTransactionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonTransactionBuilder.kt\norg/stellar/walletsdk/horizon/transaction/CommonTransactionBuilder\n*L\n1#1,134:1\n17#1,2:135\n17#1,2:137\n17#1,2:139\n17#1,2:141\n*S KotlinDebug\n*F\n+ 1 CommonTransactionBuilder.kt\norg/stellar/walletsdk/horizon/transaction/CommonTransactionBuilder\n*L\n32#1:135,2\n70#1:137,2\n88#1:139,2\n110#1:141,2\n*E\n"})
public abstract class CommonTransactionBuilder<T> {
    @NotNull
    private final String sourceAddress;

    public CommonTransactionBuilder(@NotNull String sourceAddress) {
        Intrinsics.checkNotNullParameter((Object)sourceAddress, (String)"sourceAddress");
        this.sourceAddress = sourceAddress;
    }

    @NotNull
    protected final String getSourceAddress() {
        return this.sourceAddress;
    }

    @NotNull
    public abstract List<Operation> getOperations();

    public final T building$wallet_sdk(@NotNull Function0<? extends Operation> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$building$wallet_sdk = false;
        this.getOperations().add((Operation)body.invoke());
        return (T)this;
    }

    public final T addAccountSigner(@NotNull AccountKeyPair signerAddress, int signerWeight) {
        Intrinsics.checkNotNullParameter((Object)signerAddress, (String)"signerAddress");
        CommonTransactionBuilder this_$iv = this;
        boolean $i$f$building$wallet_sdk = false;
        List<Operation> list = this_$iv.getOperations();
        boolean bl = false;
        CommonTransactionBuilderKt.access$getLog$p().debug((Function0)new Function0<Object>(signerWeight, this, signerAddress){
            final /* synthetic */ int $signerWeight;
            final /* synthetic */ CommonTransactionBuilder<T> this$0;
            final /* synthetic */ AccountKeyPair $signerAddress;
            {
                this.$signerWeight = $signerWeight;
                this.this$0 = $receiver;
                this.$signerAddress = $signerAddress;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return (this.$signerWeight == 0 ? "Remove" : "Add") + " account signer txn: sourceAddress = " + this.this$0.getSourceAddress() + ", signerAddress = " + this.$signerAddress + ", signerWeight = " + this.$signerWeight;
            }
        });
        SignerKey signer = Signer.ed25519PublicKey((KeyPair)signerAddress.getKeyPair());
        SetOptionsOperation setOptionsOperation = new SetOptionsOperation.Builder().setSourceAccount(this.sourceAddress).setSigner(signer, Integer.valueOf(signerWeight)).build();
        Intrinsics.checkNotNullExpressionValue((Object)setOptionsOperation, (String)"Builder()\n      .setSour\u2026nerWeight)\n      .build()");
        list.add((Operation)setOptionsOperation);
        return (T)this_$iv;
    }

    public final T removeAccountSigner(@NotNull AccountKeyPair signerAddress) {
        Intrinsics.checkNotNullParameter((Object)signerAddress, (String)"signerAddress");
        if (!(!Intrinsics.areEqual((Object)signerAddress.getAddress(), (Object)this.sourceAddress))) {
            boolean bl = false;
            String string = "This method can't be used to remove master signer key, call " + "lockAccountMasterKey" + " method instead";
            throw new IllegalArgumentException(string.toString());
        }
        return this.addAccountSigner(signerAddress, 0);
    }

    public final T lockAccountMasterKey() {
        CommonTransactionBuilder this_$iv = this;
        boolean $i$f$building$wallet_sdk = false;
        List<Operation> list = this_$iv.getOperations();
        boolean bl = false;
        CommonTransactionBuilderKt.access$getLog$p().debug((Function0)new Function0<Object>(this){
            final /* synthetic */ CommonTransactionBuilder<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Lock master key tx: accountAddress = " + this.this$0.getSourceAddress();
            }
        });
        SetOptionsOperation setOptionsOperation = new SetOptionsOperation.Builder().setSourceAccount(this.sourceAddress).setMasterKeyWeight(0).build();
        Intrinsics.checkNotNullExpressionValue((Object)setOptionsOperation, (String)"Builder().setSourceAccou\u2026asterKeyWeight(0).build()");
        list.add((Operation)setOptionsOperation);
        return (T)this_$iv;
    }

    public final T addAssetSupport(@NotNull IssuedAssetId asset, @NotNull String trustLimit) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)trustLimit, (String)"trustLimit");
        CommonTransactionBuilder this_$iv = this;
        boolean $i$f$building$wallet_sdk = false;
        List<Operation> list = this_$iv.getOperations();
        boolean bl = false;
        CommonTransactionBuilderKt.access$getLog$p().debug((Function0)new Function0<Object>(trustLimit, this, asset){
            final /* synthetic */ String $trustLimit;
            final /* synthetic */ CommonTransactionBuilder<T> this$0;
            final /* synthetic */ IssuedAssetId $asset;
            {
                this.$trustLimit = $trustLimit;
                this.this$0 = $receiver;
                this.$asset = $asset;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return (Intrinsics.areEqual((Object)this.$trustLimit, (Object)"0") ? "Remove" : "Add") + " asset txn: sourceAddress = " + this.this$0.getSourceAddress() + ", asset=" + this.$asset + ", trustLimit = " + this.$trustLimit;
            }
        });
        ChangeTrustAsset stellarAsset = ChangeTrustAsset.createNonNativeAsset((String)asset.getCode(), (String)asset.getIssuer());
        ChangeTrustOperation changeTrustOperation = new ChangeTrustOperation.Builder(stellarAsset, trustLimit).setSourceAccount(this.sourceAddress).build();
        Intrinsics.checkNotNullExpressionValue((Object)changeTrustOperation, (String)"Builder(stellarAsset, tr\u2026nt(sourceAddress).build()");
        list.add((Operation)changeTrustOperation);
        return (T)this_$iv;
    }

    public static /* synthetic */ Object addAssetSupport$default(CommonTransactionBuilder commonTransactionBuilder, IssuedAssetId issuedAssetId, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addAssetSupport");
        }
        if ((n & 2) != 0) {
            BigDecimal bigDecimal = BigDecimal.valueOf(Long.MAX_VALUE);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            String string2 = bigDecimal.movePointLeft(7).toPlainString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MAX_VALUE.toBigDecimal()\u2026RECISION).toPlainString()");
            string = string2;
        }
        return commonTransactionBuilder.addAssetSupport(issuedAssetId, string);
    }

    public final T removeAssetSupport(@NotNull IssuedAssetId asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        return this.addAssetSupport(asset, "0");
    }

    public final T setThreshold(int low, int medium, int high) {
        CommonTransactionBuilder this_$iv = this;
        boolean $i$f$building$wallet_sdk = false;
        List<Operation> list = this_$iv.getOperations();
        boolean bl = false;
        SetOptionsOperation setOptionsOperation = new SetOptionsOperation.Builder().setSourceAccount(this.sourceAddress).setLowThreshold(low).setMediumThreshold(medium).setHighThreshold(high).build();
        Intrinsics.checkNotNullExpressionValue((Object)setOptionsOperation, (String)"Builder()\n      .setSour\u2026hold(high)\n      .build()");
        list.add((Operation)setOptionsOperation);
        return (T)this_$iv;
    }

    @NotNull
    protected final CreateAccountOperation doCreateAccount-z13BHRw(@NotNull AccountKeyPair newAccount, long startingBalance, @NotNull String sourceAddress) {
        Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
        Intrinsics.checkNotNullParameter((Object)sourceAddress, (String)"sourceAddress");
        CommonTransactionBuilderKt.access$getLog$p().debug((Function0)new Function0<Object>(sourceAddress, newAccount, startingBalance){
            final /* synthetic */ String $sourceAddress;
            final /* synthetic */ AccountKeyPair $newAccount;
            final /* synthetic */ long $startingBalance;
            {
                this.$sourceAddress = $sourceAddress;
                this.$newAccount = $newAccount;
                this.$startingBalance = $startingBalance;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Fund tx: sourceAddress = " + this.$sourceAddress + ", destinationAddress = " + this.$newAccount.getAddress() + ", startBalance = " + ULong.toString-impl((long)this.$startingBalance);
            }
        });
        CreateAccountOperation createAccountOperation = new CreateAccountOperation.Builder(newAccount.getAddress(), Long.toUnsignedString(startingBalance)).setSourceAccount(sourceAddress).build();
        Intrinsics.checkNotNullExpressionValue((Object)createAccountOperation, (String)"Builder(newAccount.addre\u2026ceAddress)\n      .build()");
        return createAccountOperation;
    }
}

