/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.walletsdk.util;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.TimeBounds;
import org.stellar.walletsdk.anchor.AnchorTransaction;
import org.stellar.walletsdk.anchor.TransactionStatus;
import org.stellar.walletsdk.asset.AssetId;
import org.stellar.walletsdk.asset.FiatAssetId;
import org.stellar.walletsdk.asset.IssuedAssetId;
import org.stellar.walletsdk.asset.NativeAssetId;
import org.stellar.walletsdk.exception.IncorrectTransactionStatusException;
import org.stellar.walletsdk.exception.InvalidJsonException;
import org.stellar.walletsdk.horizon.SigningKeyPair;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u00a8\u0006\u000e"}, d2={"requireStatus", "", "Lorg/stellar/walletsdk/anchor/AnchorTransaction;", "requiredStatus", "Lorg/stellar/walletsdk/anchor/TransactionStatus;", "toAssetId", "Lorg/stellar/walletsdk/asset/AssetId;", "", "toJava", "Ljava/security/KeyPair;", "Lorg/stellar/walletsdk/horizon/SigningKeyPair;", "toTimeBounds", "Lorg/stellar/sdk/TimeBounds;", "Ljava/time/Duration;", "wallet-sdk"})
public final class UtilKt {
    @NotNull
    public static final TimeBounds toTimeBounds(@NotNull Duration $this$toTimeBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$toTimeBounds, (String)"<this>");
        return new TimeBounds(0L, Instant.now().plus($this$toTimeBounds).toEpochMilli() / (long)1000);
    }

    public static final void requireStatus(@NotNull AnchorTransaction $this$requireStatus, @NotNull TransactionStatus requiredStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$requireStatus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)requiredStatus), (String)"requiredStatus");
        if ($this$requireStatus.getStatus() != requiredStatus) {
            throw new IncorrectTransactionStatusException($this$requireStatus, requiredStatus);
        }
    }

    @NotNull
    public static final AssetId toAssetId(@NotNull String $this$toAssetId) {
        Intrinsics.checkNotNullParameter((Object)$this$toAssetId, (String)"<this>");
        String str = $this$toAssetId;
        if (Intrinsics.areEqual((Object)str, (Object)NativeAssetId.INSTANCE.getId())) {
            return NativeAssetId.INSTANCE;
        }
        if (StringsKt.startsWith$default((String)str, (String)"stellar", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{":"};
            List split = StringsKt.split$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (split.size() != 3) {
                throw new InvalidJsonException("Invalid asset format", str);
            }
            return new IssuedAssetId((String)split.get(1), (String)split.get(2));
        }
        if (StringsKt.startsWith$default((String)str, (String)"iso4217", (boolean)false, (int)2, null)) {
            return FiatAssetId.box-impl(FiatAssetId.constructor-impl(str));
        }
        throw new InvalidJsonException("Unknown scheme", str);
    }

    @NotNull
    public static final KeyPair toJava(@NotNull SigningKeyPair $this$toJava) {
        Intrinsics.checkNotNullParameter((Object)$this$toJava, (String)"<this>");
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyFactory keyFactory = KeyFactory.getInstance("Ed25519");
        Intrinsics.checkNotNullExpressionValue((Object)keyFactory, (String)"getInstance(\"Ed25519\")");
        KeyFactory factory = keyFactory;
        PrivateKeyInfo privKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), (ASN1Encodable)new DEROctetString(StrKey.decodeEd25519SecretSeed((char[])$this$toJava.getKeyPair().getSecretSeed())));
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privKeyInfo.getEncoded());
        SubjectPublicKeyInfo pubKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), $this$toJava.getPublicKey());
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pubKeyInfo.getEncoded());
        PublicKey jcaPublicKey = factory.generatePublic(x509KeySpec);
        PrivateKey privateKey = factory.generatePrivate(pkcs8KeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"factory.generatePrivate(pkcs8KeySpec)");
        PrivateKey privateKey2 = privateKey;
        return new KeyPair(jcaPublicKey, privateKey2);
    }
}

