/*
 * Decompiled with CFR 0.152.
 */
package cern.streaming.pool.ext.tensorics.evaluation;

import cern.streaming.pool.core.service.StreamId;
import cern.streaming.pool.core.service.streamid.BufferSpecification;
import cern.streaming.pool.ext.tensorics.evaluation.EvaluationStrategy;
import cern.streaming.pool.ext.tensorics.evaluation.EvaluationStrategyBuilder;
import java.time.Duration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class BufferedEvaluation
implements EvaluationStrategy {
    private final BufferSpecification bufferSpecification;

    private BufferedEvaluation(BufferSpecification bufferSpecification) {
        this.bufferSpecification = Objects.requireNonNull(bufferSpecification, "bufferSpecification must not be null");
    }

    public BufferSpecification bufferSpecification() {
        return this.bufferSpecification;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends EvaluationStrategyBuilder {
        private StreamId<?> startStreamId;
        private Set<BufferSpecification.EndStreamMatcher<?, ?>> endStreamsMatchers = new HashSet();
        private Duration timeout = null;

        public Builder withStartStreamId(StreamId<?> newStartStreamId) {
            this.startStreamId = newStartStreamId;
            return this;
        }

        public Builder withEndMatcher(BufferSpecification.EndStreamMatcher<?, ?> endMatcher) {
            this.endStreamsMatchers.add(endMatcher);
            return this;
        }

        public Builder withTimeout(Duration newTimeout) {
            this.timeout = newTimeout;
            return this;
        }

        @Override
        public EvaluationStrategy build() {
            if (this.timeout == null) {
                return new BufferedEvaluation(BufferSpecification.ofStartEnd(this.startStreamId, this.endStreamsMatchers));
            }
            return new BufferedEvaluation(BufferSpecification.ofStartEndTimeout(this.startStreamId, this.endStreamsMatchers, (Duration)this.timeout));
        }
    }
}

