/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.tensorics.streamid;

import java.io.Serializable;
import java.util.Objects;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.ext.tensorics.evaluation.EvaluationStrategies;
import org.streamingpool.ext.tensorics.evaluation.EvaluationStrategy;
import org.tensorics.core.expressions.Placeholder;
import org.tensorics.core.tree.domain.Contexts;
import org.tensorics.core.tree.domain.Expression;
import org.tensorics.core.tree.domain.ResolvingContext;

public class ExpressionBasedStreamId<R>
implements StreamId<R>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Expression<R> expression;
    private final ResolvingContext initialContext;
    private final EvaluationStrategy evaluationStrategy;

    public static <R> ExpressionBasedStreamId<R> of(Expression<R> expression, ResolvingContext initialContext, EvaluationStrategy evaluationStrategy) {
        return new ExpressionBasedStreamId<R>(expression, initialContext, evaluationStrategy);
    }

    public static <R> ExpressionBasedStreamId<R> of(Expression<R> expression) {
        return new ExpressionBasedStreamId<R>(expression, (ResolvingContext)Contexts.newResolvingContext(), EvaluationStrategies.defaultEvaluation());
    }

    private ExpressionBasedStreamId(Expression<R> expression, ResolvingContext initialContext, EvaluationStrategy evaluationStrategy) {
        this.expression = Objects.requireNonNull(expression, "expression must not be null.");
        this.initialContext = Objects.requireNonNull(initialContext, "initialContext must not be null.");
        this.evaluationStrategy = Objects.requireNonNull(evaluationStrategy, "evaluationStrategy must not be null");
        if (initialContext.resolves((Expression)Placeholder.ofClass(EvaluationStrategy.class))) {
            throw new IllegalArgumentException("The initial context already provides an EvaluationStrategy. This is not allowed, use the parameter");
        }
    }

    public ResolvingContext initialContext() {
        return this.initialContext;
    }

    public Expression<R> expression() {
        return this.expression;
    }

    public EvaluationStrategy evaluationStrategy() {
        return this.evaluationStrategy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.evaluationStrategy == null ? 0 : this.evaluationStrategy.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.initialContext == null ? 0 : this.initialContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionBasedStreamId other = (ExpressionBasedStreamId)obj;
        if (this.evaluationStrategy == null ? other.evaluationStrategy != null : !this.evaluationStrategy.equals(other.evaluationStrategy)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.initialContext == null ? other.initialContext != null : !this.initialContext.equals(other.initialContext));
    }

    public String toString() {
        return "ExpressionBasedStreamId [expression=" + this.expression + ", evaluationStrategy=" + this.evaluationStrategy + ", initialContext=" + this.initialContext + "]";
    }
}

