/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.tensorics.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.streamingpool.core.service.StreamId;
import org.tensorics.core.tree.domain.AbstractDeferredExpression;
import org.tensorics.core.tree.domain.Expression;
import org.tensorics.core.tree.domain.Node;
import org.tensorics.core.tree.domain.ResolvedExpression;

public class BufferedStreamExpression<T>
extends AbstractDeferredExpression<List<T>> {
    private static final long serialVersionUID = 1L;
    private final Expression<StreamId<T>> streamIdExpression;

    public static <T> BufferedStreamExpression<T> buffer(Expression<StreamId<T>> targetStreamId) {
        return new BufferedStreamExpression<T>(targetStreamId);
    }

    public static <T> BufferedStreamExpression<T> buffer(StreamId<T> targetStreamId) {
        return new BufferedStreamExpression<T>(targetStreamId);
    }

    protected BufferedStreamExpression(StreamId<T> targetStreamId) {
        this.streamIdExpression = ResolvedExpression.of(Objects.requireNonNull(targetStreamId, "target stream cannot be null"));
    }

    protected BufferedStreamExpression(Expression<StreamId<T>> targetStreamId) {
        this.streamIdExpression = Objects.requireNonNull(targetStreamId, "target stream cannot be null");
    }

    public Expression<StreamId<T>> streamIdExpression() {
        return this.streamIdExpression;
    }

    public List<? extends Node> getChildren() {
        return Collections.singletonList(this.streamIdExpression);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.streamIdExpression == null ? 0 : this.streamIdExpression.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BufferedStreamExpression other = (BufferedStreamExpression)((Object)obj);
        return !(this.streamIdExpression == null ? other.streamIdExpression != null : !this.streamIdExpression.equals(other.streamIdExpression));
    }

    public String toString() {
        return "BufferedStreamExpression [targetStreamId=" + this.streamIdExpression + "]";
    }
}

