/*
 * Decompiled with CFR 0.152.
 */
package org.streamingpool.ext.tensorics.streamfactory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streamingpool.core.domain.ErrorStreamPair;
import org.streamingpool.core.service.DiscoveryService;
import org.streamingpool.core.service.StreamFactory;
import org.streamingpool.core.service.StreamId;
import org.streamingpool.core.service.streamid.OverlapBufferStreamId;
import org.streamingpool.ext.tensorics.evaluation.BufferedEvaluation;
import org.streamingpool.ext.tensorics.evaluation.ContinuousEvaluation;
import org.streamingpool.ext.tensorics.evaluation.EvaluationStrategy;
import org.streamingpool.ext.tensorics.evaluation.TriggeredEvaluation;
import org.streamingpool.ext.tensorics.exception.NoBufferedStreamSpecifiedException;
import org.streamingpool.ext.tensorics.expression.UnresolvedStreamIdBasedExpression;
import org.streamingpool.ext.tensorics.streamid.DetailedExpressionStreamId;
import org.tensorics.core.expressions.Placeholder;
import org.tensorics.core.resolve.domain.DetailedExpressionResult;
import org.tensorics.core.resolve.engine.ResolvedContextDidNotGrowException;
import org.tensorics.core.resolve.engine.ResolvingEngine;
import org.tensorics.core.resolve.options.HandleWithFirstCapableAncestorStrategy;
import org.tensorics.core.resolve.options.ResolvingOption;
import org.tensorics.core.tree.domain.Contexts;
import org.tensorics.core.tree.domain.EditableResolvingContext;
import org.tensorics.core.tree.domain.Expression;
import org.tensorics.core.tree.domain.ResolvingContext;
import org.tensorics.core.tree.walking.Trees;

public class DetailedTensoricsExpressionStreamFactory
implements StreamFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetailedTensoricsExpressionStreamFactory.class);
    private static final HandleWithFirstCapableAncestorStrategy EXCEPTION_HANDLING_STRATEGY = new HandleWithFirstCapableAncestorStrategy();
    private static final Function<Object[], Boolean> TRIGGER_CONTEXT_COMBINER = entriesToCombine -> true;
    private static final Function<Object[], ResolvingContext> CONTEXT_COMBINER = entriesToCombine -> {
        EditableResolvingContext context = Contexts.newResolvingContext();
        for (Object entry : entriesToCombine) {
            if (!(entry instanceof ExpToValue)) continue;
            ExpToValue castedEntry = (ExpToValue)entry;
            context.put(castedEntry.node, castedEntry.value);
        }
        return context;
    };
    private final ResolvingEngine engine;

    public DetailedTensoricsExpressionStreamFactory(ResolvingEngine engine) {
        this.engine = engine;
    }

    public <T> ErrorStreamPair<T> create(StreamId<T> id, DiscoveryService discoveryService) {
        if (!(id instanceof DetailedExpressionStreamId)) {
            return ErrorStreamPair.empty();
        }
        DetailedExpressionStreamId tensoricsId = (DetailedExpressionStreamId)id;
        if (tensoricsId.initialContext().resolvedValueOf((Expression)Placeholder.ofClass(EvaluationStrategy.class)) instanceof BufferedEvaluation) {
            return ErrorStreamPair.empty();
        }
        return ErrorStreamPair.ofData(this.resolvedStream(tensoricsId, discoveryService));
    }

    private <T, E extends Expression<T>> Flowable<DetailedExpressionResult<T, E>> resolvedStream(DetailedExpressionStreamId<T, E> id, DiscoveryService discoveryService) {
        Object expression = id.expression();
        ResolvingContext initialCtx = id.initialContext();
        Map<Expression<Object>, StreamId<Object>> streamIds = this.streamIdsFrom(id);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry<Expression<Object>, StreamId<Object>> entry : streamIds.entrySet()) {
            Flowable plainObservable = Flowable.fromPublisher((Publisher)discoveryService.discover(entry.getValue()));
            Flowable mappedObservable = plainObservable.map(obj -> new ExpToValue((Expression<Object>)((Expression)entry.getKey()), obj));
            builder.put(entry.getValue(), (Object)mappedObservable);
        }
        ImmutableMultimap observableEntries = builder.build();
        EvaluationStrategy evaluationStrategy = (EvaluationStrategy)initialCtx.resolvedValueOf((Expression)Placeholder.ofClass(EvaluationStrategy.class));
        Flowable<?> triggerObservable = DetailedTensoricsExpressionStreamFactory.triggerObservable(observableEntries, evaluationStrategy, discoveryService);
        return triggerObservable.withLatestFrom((Publisher[])observableEntries.values().toArray((Object[])new Flowable[0]), CONTEXT_COMBINER).map(ctx -> {
            EditableResolvingContext fullContext = Contexts.newResolvingContext();
            fullContext.putAllNew(ctx);
            fullContext.putAllNew(initialCtx);
            return this.engine.resolveDetailed(expression, (ResolvingContext)fullContext, new ResolvingOption[]{EXCEPTION_HANDLING_STRATEGY});
        });
    }

    @VisibleForTesting
    <T extends Expression<?>> Map<Expression<Object>, StreamId<Object>> streamIdsFrom(DetailedExpressionStreamId<?, T> id) {
        T rootExpression = id.expression();
        ResolvingContext initialCtx = id.initialContext();
        Set unresolvedStreamIdExpressions = Trees.findNodesOfClass(rootExpression, UnresolvedStreamIdBasedExpression.class);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (UnresolvedStreamIdBasedExpression unresolvedStreamIdExpression : unresolvedStreamIdExpressions) {
            try {
                Expression streamIdExpression = unresolvedStreamIdExpression.streamIdExpression();
                StreamId streamId = (StreamId)this.engine.resolve(streamIdExpression, initialCtx, new ResolvingOption[0]);
                mapBuilder.put((Object)unresolvedStreamIdExpression, (Object)streamId);
            }
            catch (ResolvedContextDidNotGrowException ex) {
                throw new RuntimeException(String.format("Context did not grow while resolving the StreamId of expression. This is most probably because the initial context (%s) did not contain the value of the current UnresolvedStreamIdBasedExpression (%s).", new Object[]{initialCtx, unresolvedStreamIdExpression}), ex);
            }
        }
        return mapBuilder.build();
    }

    private static Flowable<?> triggerObservable(Multimap<StreamId<?>, ? extends Flowable<?>> flowables, EvaluationStrategy strategy, DiscoveryService discoveryService) {
        if (strategy instanceof ContinuousEvaluation) {
            Collection streams = flowables.values();
            if (streams.isEmpty()) {
                LOGGER.warn("The expression does not contain any streams. Therefore it will never emit! This rarely might be what you want ;-)");
            }
            return Flowable.combineLatest((Iterable)streams, TRIGGER_CONTEXT_COMBINER);
        }
        if (strategy instanceof BufferedEvaluation) {
            List triggeringObservables = flowables.entries().stream().filter(e -> e.getKey() instanceof OverlapBufferStreamId).map(Map.Entry::getValue).collect(Collectors.toList());
            if (triggeringObservables.isEmpty()) {
                throw new NoBufferedStreamSpecifiedException();
            }
            return Flowable.zip(triggeringObservables, ImmutableSet::of);
        }
        if (strategy instanceof TriggeredEvaluation) {
            return Flowable.fromPublisher((Publisher)discoveryService.discover(((TriggeredEvaluation)strategy).triggeringStreamId()));
        }
        throw new IllegalArgumentException("Unknown evaluationStrategy '" + strategy + "'. Cannot create trigger Observable.");
    }

    private static final class ExpToValue {
        private final Expression<Object> node;
        private final Object value;

        public ExpToValue(Expression<Object> node, Object value) {
            this.node = node;
            this.value = value;
        }

        public String toString() {
            return "ExpToValue [node=" + this.node + ", value=" + this.value + "]";
        }
    }
}

