/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.io;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.subethamail.smtp.util.TextUtils;

public class ReceivedHeaderStream
extends FilterInputStream {
    ByteArrayInputStream header;

    public ReceivedHeaderStream(InputStream in, String heloHost, InetAddress host, String whoami) {
        super(in);
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z (z)", Locale.US);
        String timestamp = fmt.format(new Date());
        String header = "Received: from " + heloHost + " (" + host.getCanonicalHostName() + " [" + host + "])\r\n" + "        by " + whoami + " with SMTP;\r\n" + "        " + timestamp + "\r\n";
        this.header = new ByteArrayInputStream(TextUtils.getAsciiBytes(header));
    }

    public int available() throws IOException {
        return this.header.available() + super.available();
    }

    public void close() throws IOException {
        super.close();
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.header.available() > 0) {
            return this.header.read();
        }
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.header.available() > 0) {
            int countRead = this.header.read(b, off, len);
            if (countRead < len) {
                int remainder = len - countRead;
                int additionalRead = super.read(b, off + countRead, remainder);
                return countRead + additionalRead;
            }
            return countRead;
        }
        return super.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }
}

