/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.client;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.client.SMTPClient;
import org.subethamail.smtp.client.SMTPException;

public class SmartClient
extends SMTPClient {
    private static Logger log = LoggerFactory.getLogger(SmartClient.class);
    private static final byte[] SMTP_TERMINATOR = new byte[]{13, 10, 46, 13, 10};
    boolean sentFrom;
    int recipientCount;

    public SmartClient(String host, int port, String myHost) throws UnknownHostException, IOException, SMTPException {
        this(host, port, null, myHost);
    }

    public SmartClient(String host, int port, SocketAddress bindpoint, String myHost) throws UnknownHostException, IOException, SMTPException {
        super(host, port, bindpoint);
        this.receiveAndCheck();
        this.sendAndCheck("HELO " + myHost);
    }

    public void from(String from) throws IOException, SMTPException {
        this.sendAndCheck("MAIL FROM: <" + from + ">");
        this.sentFrom = true;
    }

    public void to(String to) throws IOException, SMTPException {
        this.sendAndCheck("RCPT TO: <" + to + ">");
        ++this.recipientCount;
    }

    public void dataStart() throws IOException, SMTPException {
        this.sendAndCheck("DATA");
    }

    public void dataWrite(byte[] data, int numBytes) throws IOException {
        this.dataOutput.write(data, 0, numBytes);
    }

    public void dataEnd() throws IOException, SMTPException {
        this.dataOutput.flush();
        this.rawOutput.write(SMTP_TERMINATOR);
        this.rawOutput.flush();
        this.receiveAndCheck();
    }

    public void quit() {
        try {
            this.sendAndCheck("QUIT");
        }
        catch (IOException ex) {
            log.warn("Failed to issue QUIT to " + this.hostPort);
        }
        this.close();
    }

    public boolean sentFrom() {
        return this.sentFrom;
    }

    public boolean sentTo() {
        return this.recipientCount > 0;
    }

    public int getRecipientCount() {
        return this.recipientCount;
    }
}

