package org.sunbird.telemetry.handler;

import org.sunbird.telemetry.TelemetryGenerator;

/**
 * Interface to implement the handlers for the telemetry generated by
 * {@link TelemetryGenerator}. The implementation of this interface should use
 * {@link TelemetryGenerator} to generate telemetry and have logic to handle and
 * push the telemetry to Ekstep data pipeline.
 * 
 * @author mahesh
 *
 */

public interface TelemetryHandler {

	/**
	 * 
	 * @param event event
     * @param level logging level
	 */
	public void send(String event, Level level);

    /**
     *
     * @param event event
     * @param level logging level
     * @param telemetry is for telemetry
     */
	public void send(String event, Level level, boolean telemetry);
}
