/*
 * Decompiled with CFR 0.152.
 */
package org.sunbird.telemetry;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.sunbird.common.Platform;
import org.sunbird.telemetry.TelemetryParams;
import org.sunbird.telemetry.dto.Actor;
import org.sunbird.telemetry.dto.Context;
import org.sunbird.telemetry.dto.Producer;
import org.sunbird.telemetry.dto.Target;
import org.sunbird.telemetry.dto.Telemetry;

public class TelemetryGenerator {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final String ENVIRONMENT = Platform.config.hasPath("telemetry_env") ? Platform.config.getString("telemetry_env") : "dev";
    private static final String INSTALLATION_ID = Platform.config.hasPath("installation.id") ? Platform.config.getString("installation.id") : "ekstep";
    private static final String DEFAULT_PRODUCER_ID = ENVIRONMENT + "." + INSTALLATION_ID + ".learning.platform";
    private static final String PRODUCER_VERSION = "1.0";
    private static String PRODUCER_PID = "";

    public static void setComponent(String component) {
        PRODUCER_PID = component;
    }

    public static String access(Map<String, String> context, Map<String, Object> params) {
        Actor actor = TelemetryGenerator.getActor(context);
        Context eventContext = TelemetryGenerator.getContext(context);
        HashMap<String, Object> edata = new HashMap<String, Object>();
        edata.put("type", "api_access");
        edata.put("level", "INFO");
        edata.put("message", "");
        edata.put("params", TelemetryGenerator.getParamsList(params));
        Telemetry telemetry = new Telemetry("LOG", actor, eventContext, edata);
        return TelemetryGenerator.getTelemetry(telemetry);
    }

    public static String log(Map<String, String> context, String type, String level, String message, String pageid, Map<String, Object> params) {
        Actor actor = TelemetryGenerator.getActor(context);
        Context eventContext = TelemetryGenerator.getContext(context);
        HashMap<String, Object> edata = new HashMap<String, Object>();
        edata.put("type", type);
        edata.put("level", level);
        edata.put("message", message);
        if (StringUtils.isNotBlank((CharSequence)pageid)) {
            edata.put("pageid", pageid);
        }
        if (null != params && !params.isEmpty()) {
            edata.put("params", TelemetryGenerator.getParamsList(params));
        }
        Telemetry telemetry = new Telemetry("LOG", actor, eventContext, edata);
        return TelemetryGenerator.getTelemetry(telemetry);
    }

    public static String log(Map<String, String> context, String type, String level, String message) {
        return TelemetryGenerator.log(context, type, level, message, null, null);
    }

    public static String error(Map<String, String> context, String code, String type, String stacktrace, String pageid, Object object) {
        Actor actor = TelemetryGenerator.getActor(context);
        Context eventContext = TelemetryGenerator.getContext(context);
        HashMap<String, Object> edata = new HashMap<String, Object>();
        edata.put("err", code);
        edata.put("errtype", type);
        edata.put("stacktrace", stacktrace);
        if (StringUtils.isNotBlank((CharSequence)pageid)) {
            edata.put("pageid", pageid);
        }
        if (null != object) {
            edata.put("object", object);
        }
        Telemetry telemetry = new Telemetry("ERROR", actor, eventContext, edata);
        return TelemetryGenerator.getTelemetry(telemetry);
    }

    public static String error(Map<String, String> context, String code, String type, String stacktrace) {
        return TelemetryGenerator.error(context, code, type, stacktrace, null, null);
    }

    public static String search(Map<String, String> context, String query, Object filters, Object sort, List<Map<String, Object>> cData, int size, Object topN, String type) {
        Actor actor = TelemetryGenerator.getActor(context);
        Context eventContext = TelemetryGenerator.getContext(context);
        HashMap<String, Object> edata = new HashMap<String, Object>();
        edata.put("type", type);
        edata.put("query", query);
        edata.put("filters", filters);
        edata.put("sort", sort);
        edata.put("size", size);
        edata.put("topn", topN);
        Telemetry telemetry = null != cData ? new Telemetry("SEARCH", actor, eventContext, edata, cData) : new Telemetry("SEARCH", actor, eventContext, edata);
        if (null != context.get("objectId") && null != context.get("objectType")) {
            Target object = new Target(context.get("objectId"), context.get("objectType"));
            telemetry.setObject(object);
        }
        return TelemetryGenerator.getTelemetry(telemetry);
    }

    public static String audit(Map<String, String> context, List<String> props, String state, String prevState, List<Map<String, Object>> cdata) {
        Telemetry telemetry = null;
        Actor actor = TelemetryGenerator.getActor(context);
        Context eventContext = TelemetryGenerator.getContext(context);
        HashMap<String, Object> edata = new HashMap<String, Object>();
        edata.put("props", props);
        if (StringUtils.isNotBlank((CharSequence)state)) {
            edata.put("state", state);
        }
        if (StringUtils.isNotBlank((CharSequence)prevState)) {
            edata.put("prevstate", prevState);
        }
        if (StringUtils.isNotBlank((CharSequence)context.get("duration"))) {
            edata.put("duration", Long.valueOf(context.get("duration")));
        }
        telemetry = null != cdata && !cdata.isEmpty() ? new Telemetry("AUDIT", actor, eventContext, edata, cdata) : new Telemetry("AUDIT", actor, eventContext, edata);
        Target object = new Target(context.get("objectId"), context.get("objectType"));
        String pkgVersion = context.get("pkgVersion");
        if (StringUtils.isNotBlank((CharSequence)pkgVersion)) {
            object.setVer(pkgVersion);
        }
        telemetry.setObject(object);
        return TelemetryGenerator.getTelemetry(telemetry);
    }

    public static String audit(Map<String, String> context, List<String> props, String state, String prevState) {
        return TelemetryGenerator.audit(context, props, state, prevState, null);
    }

    private static Actor getActor(Map<String, String> context) {
        String actorId = context.get(TelemetryParams.ACTOR.name());
        if (StringUtils.isNotBlank((CharSequence)actorId)) {
            return new Actor(actorId, "User");
        }
        return new Actor("org.sunbird.learning.platform", "System");
    }

    private static Context getContext(Map<String, String> context) {
        String did;
        String channel = context.get(TelemetryParams.CHANNEL.name());
        String env = context.get(TelemetryParams.ENV.name());
        Context eventContext = new Context(channel, env, TelemetryGenerator.getProducer(context));
        String sid = context.get("sid");
        if (StringUtils.isNotBlank((CharSequence)sid)) {
            eventContext.setSid(sid);
        }
        if (StringUtils.isNotBlank((CharSequence)(did = context.get("did")))) {
            eventContext.setDid(did);
        }
        return eventContext;
    }

    private static Producer getProducer(Map<String, String> context) {
        String appId = context.get(TelemetryParams.APP_ID.name());
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            return new Producer(appId, PRODUCER_PID, PRODUCER_VERSION);
        }
        return new Producer(DEFAULT_PRODUCER_ID, PRODUCER_PID, PRODUCER_VERSION);
    }

    private static List<Map<String, Object>> getParamsList(Map<String, Object> params) {
        ArrayList<Map<String, Object>> paramsList = new ArrayList<Map<String, Object>>();
        if (null != params && !params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put(entry.getKey(), entry.getValue());
                paramsList.add(param);
            }
        }
        return paramsList;
    }

    private static String getTelemetry(Telemetry telemetry) {
        String event = "";
        try {
            event = mapper.writeValueAsString((Object)telemetry);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return event;
    }
}

