/*
 * Decompiled with CFR 0.152.
 */
package org.sunbird.telemetry.handler;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sunbird.telemetry.handler.Level;
import org.sunbird.telemetry.handler.TelemetryHandler;

public class TelemetryLoggingHandler
implements TelemetryHandler {
    private static final Logger rootLogger = LogManager.getLogger((String)"DefaultPlatformLogger");
    private static final Logger telemetryLogger = LogManager.getLogger((String)"TelemetryEventLogger");

    @Override
    public void send(String event, Level level) {
        this.send(event, level, false);
    }

    @Override
    public void send(String event, Level level, boolean telemetry) {
        if (telemetry) {
            telemetryLogger.info(event);
        } else {
            switch (level) {
                case INFO: {
                    rootLogger.info(event);
                    break;
                }
                case DEBUG: {
                    rootLogger.debug(event);
                    break;
                }
                case ERROR: {
                    rootLogger.error(event);
                    break;
                }
                case WARN: {
                    rootLogger.warn(event);
                    break;
                }
                case TRACE: {
                    rootLogger.trace(event);
                    break;
                }
                case FATAL: {
                    rootLogger.fatal(event);
                }
            }
        }
    }
}

