/*
 * Decompiled with CFR 0.152.
 */
package org.sunbird.telemetry.logger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.sunbird.common.Platform;
import org.sunbird.common.dto.ExecutionContext;
import org.sunbird.common.dto.HeaderParam;
import org.sunbird.common.exception.MiddlewareException;
import org.sunbird.common.exception.ResponseCode;
import org.sunbird.telemetry.TelemetryGenerator;
import org.sunbird.telemetry.TelemetryParams;
import org.sunbird.telemetry.handler.Level;
import org.sunbird.telemetry.handler.TelemetryHandler;
import org.sunbird.telemetry.handler.TelemetryLoggingHandler;

public class TelemetryManager {
    private static TelemetryHandler telemetryHandler = new TelemetryLoggingHandler();
    private static final String DEFAULT_CHANNEL_ID = Platform.config.hasPath("channel.default") ? Platform.config.getString("channel.default") : "in.ekstep";

    public static void access(Map<String, String> context, Map<String, Object> params) {
        String event = TelemetryGenerator.access(context, params);
        telemetryHandler.send(event, Level.INFO, true);
    }

    public static void log(String message) {
        TelemetryManager.log(message, null, Level.DEBUG.name());
    }

    public static void log(String message, Map<String, Object> params) {
        TelemetryManager.log(message, params, Level.DEBUG.name());
    }

    public static void info(String message) {
        TelemetryManager.log(message, null, Level.INFO.name());
    }

    public static void info(String message, Map<String, Object> params) {
        TelemetryManager.log(message, params, Level.INFO.name());
    }

    public static void warn(String message) {
        TelemetryManager.log(message, null, Level.WARN.name());
    }

    public static void warn(String message, Map<String, Object> params) {
        TelemetryManager.log(message, params, Level.WARN.name());
    }

    public static void error(String message) {
        TelemetryManager.log(message, null, Level.ERROR.name());
    }

    public static void error(String message, Map<String, Object> params) {
        TelemetryManager.log(message, params, Level.ERROR.name());
    }

    public static void error(String message, Throwable e) {
        TelemetryManager.error(message, e, null);
    }

    public static void error(String message, Throwable e, Object object) {
        Map<String, String> context = TelemetryManager.getContext();
        String stacktrace = ExceptionUtils.getStackTrace((Throwable)e);
        String code = ResponseCode.SERVER_ERROR.name();
        if (e instanceof MiddlewareException) {
            code = ((MiddlewareException)e).getErrCode();
        }
        String event = TelemetryGenerator.error(context, code, "system", stacktrace);
        telemetryHandler.send(event, Level.ERROR);
    }

    public static void audit(String id, String type, List<String> props) {
        TelemetryManager.audit(id, type, props, null, null);
    }

    public static void audit(String id, String type, List<String> props, String state, String prevState) {
        Map<String, String> context = TelemetryManager.getContext();
        context.put("objectId", id);
        context.put("objectType", type);
        String event = TelemetryGenerator.audit(context, props, state, prevState);
        telemetryHandler.send(event, Level.INFO);
    }

    public static void search(String query, Object filters, Object sort, int size, Object topN, String type) {
        TelemetryManager.search(null, query, filters, sort, size, topN, type);
    }

    public static void search(Map<String, Object> context, String query, Object filters, Object sort, int size, Object topN, String type) {
        Map<String, String> reqContext = null;
        String deviceId = null;
        String appId = null;
        if (null != context) {
            reqContext = new HashMap<String, String>();
            reqContext.put(TelemetryParams.ACTOR.name(), (String)context.get(TelemetryParams.ACTOR.name()));
            reqContext.put(TelemetryParams.ENV.name(), (String)context.get(TelemetryParams.ENV.name()));
            reqContext.put(TelemetryParams.CHANNEL.name(), (String)context.get(HeaderParam.CHANNEL_ID.name()));
            reqContext.put(TelemetryParams.APP_ID.name(), (String)context.get(HeaderParam.APP_ID.name()));
            deviceId = (String)context.get(HeaderParam.DEVICE_ID.name());
            if (StringUtils.isNotBlank((CharSequence)deviceId)) {
                reqContext.put("did", deviceId);
            }
            if (null != context.get("objectId") && null != context.get("objectType")) {
                reqContext.put("objectId", (String)context.get("objectId"));
                reqContext.put("objectType", (String)context.get("objectType"));
            }
        } else {
            reqContext = TelemetryManager.getContext();
            deviceId = (String)ExecutionContext.getCurrent().getGlobalContext().get(HeaderParam.DEVICE_ID.name());
            if (StringUtils.isNotBlank((CharSequence)deviceId)) {
                reqContext.put("did", deviceId);
            }
            if (StringUtils.isNotBlank((CharSequence)(appId = (String)ExecutionContext.getCurrent().getGlobalContext().get(HeaderParam.APP_ID.name())))) {
                reqContext.put(TelemetryParams.APP_ID.name(), appId);
            }
        }
        String event = TelemetryGenerator.search(reqContext, query, filters, sort, null, size, topN, type);
        telemetryHandler.send(event, Level.INFO, true);
    }

    private static void log(String message, Map<String, Object> params, String logLevel) {
        Map<String, String> context = TelemetryManager.getContext();
        String event = TelemetryGenerator.log(context, "system", logLevel, message, null, params);
        telemetryHandler.send(event, Level.getLevel(logLevel));
    }

    private static Map<String, String> getContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(TelemetryParams.ACTOR.name(), TelemetryManager.getContextValue(TelemetryParams.ACTOR.name(), "org.sunbird.learning.platform"));
        context.put(TelemetryParams.CHANNEL.name(), TelemetryManager.getContextValue(HeaderParam.CHANNEL_ID.name(), DEFAULT_CHANNEL_ID));
        context.put(TelemetryParams.ENV.name(), TelemetryManager.getContextValue(TelemetryParams.ENV.name(), "system"));
        return context;
    }

    private static String getContextValue(String key, String defaultValue) {
        String value = (String)ExecutionContext.getCurrent().getGlobalContext().get(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }
}

