/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import de.fau.cs.osr.ptk.common.EntityMap;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.ContentNode;
import de.fau.cs.osr.utils.StopWatch;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sweble.wikitext.engine.CompiledPage;
import org.sweble.wikitext.engine.CompilerException;
import org.sweble.wikitext.engine.ExpansionCallback;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.Page;
import org.sweble.wikitext.engine.PageId;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.WikiConfigurationInterface;
import org.sweble.wikitext.engine.log.CompilerLog;
import org.sweble.wikitext.engine.log.ParseException;
import org.sweble.wikitext.engine.log.ParserLog;
import org.sweble.wikitext.engine.log.PostprocessorLog;
import org.sweble.wikitext.engine.log.PpResolverLog;
import org.sweble.wikitext.engine.log.PreprocessorLog;
import org.sweble.wikitext.engine.log.UnhandledException;
import org.sweble.wikitext.engine.log.ValidatorLog;
import org.sweble.wikitext.lazy.LazyEncodingValidator;
import org.sweble.wikitext.lazy.LazyParser;
import org.sweble.wikitext.lazy.LazyPostprocessor;
import org.sweble.wikitext.lazy.LazyPreprocessor;
import org.sweble.wikitext.lazy.ParserConfigInterface;
import org.sweble.wikitext.lazy.parser.LazyParsedPage;
import org.sweble.wikitext.lazy.parser.PreprocessorToParserTransformer;
import org.sweble.wikitext.lazy.preprocessor.LazyPreprocessedPage;
import org.sweble.wikitext.lazy.preprocessor.PreprocessedWikitext;

public class Compiler {
    private static final Logger logger = Logger.getLogger(Compiler.class);
    private WikiConfigurationInterface wikiConfig;

    public Compiler(WikiConfigurationInterface wikiConfig) {
        this.wikiConfig = wikiConfig;
    }

    public WikiConfigurationInterface getWikiConfig() {
        return this.wikiConfig;
    }

    public CompiledPage preprocess(PageId pageId, String wikitext, boolean forInclusion, ExpansionCallback callback) throws CompilerException {
        LazyPreprocessedPage pprAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        CompilerLog log = new CompilerLog();
        log.setTitle(title.getFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            LazyPreprocessedPage ppAst;
            EntityMap entityMap = new EntityMap();
            String validatedWikitext = this.validate(title, wikitext, entityMap, log);
            pprAst = ppAst = this.preprocess(title, validatedWikitext, forInclusion, entityMap, log);
            if (callback != null) {
                pprAst = this.expand(callback, title, ppAst, entityMap, null, false, log);
            }
        }
        catch (CompilerException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new CompilerException("Compilation failed!", e, log);
        }
        return new CompiledPage(new Page(pprAst.getContent()), pprAst.getWarnings(), log);
    }

    public CompiledPage expand(PageId pageId, String wikitext, ExpansionCallback callback) throws CompilerException {
        LazyPreprocessedPage pAst;
        if (pageId == null || callback == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        CompilerLog log = new CompilerLog();
        log.setTitle(title.getFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            LazyPreprocessedPage ppAst;
            EntityMap entityMap = new EntityMap();
            String validatedWikitext = this.validate(title, wikitext, entityMap, log);
            LazyPreprocessedPage pprAst = ppAst = this.preprocess(title, validatedWikitext, false, entityMap, log);
            pAst = pprAst = this.expand(callback, title, ppAst, entityMap, null, false, log);
        }
        catch (CompilerException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new CompilerException("Compilation failed!", e, log);
        }
        return new CompiledPage(new Page(pAst.getContent()), pAst.getWarnings(), log);
    }

    public CompiledPage parse(PageId pageId, String wikitext, ExpansionCallback callback) throws CompilerException {
        LazyParsedPage pAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        CompilerLog log = new CompilerLog();
        log.setTitle(title.getFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            LazyPreprocessedPage ppAst;
            EntityMap entityMap = new EntityMap();
            String validatedWikitext = this.validate(title, wikitext, entityMap, log);
            LazyPreprocessedPage pprAst = ppAst = this.preprocess(title, validatedWikitext, false, entityMap, log);
            if (callback != null) {
                pprAst = this.expand(callback, title, ppAst, entityMap, null, false, log);
            }
            pAst = this.parse(title, pprAst, entityMap, log);
        }
        catch (CompilerException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new CompilerException("Compilation failed!", e, log);
        }
        return new CompiledPage(new Page(pAst.getContent()), pAst.getWarnings(), log);
    }

    public CompiledPage postprocess(PageId pageId, String wikitext, ExpansionCallback callback) throws CompilerException {
        LazyParsedPage pAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        CompilerLog log = new CompilerLog();
        log.setTitle(title.getFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            LazyPreprocessedPage ppAst;
            EntityMap entityMap = new EntityMap();
            String validatedWikitext = this.validate(title, wikitext, entityMap, log);
            LazyPreprocessedPage pprAst = ppAst = this.preprocess(title, validatedWikitext, false, entityMap, log);
            if (callback != null) {
                pprAst = this.expand(callback, title, ppAst, entityMap, null, false, log);
            }
            pAst = this.parse(title, pprAst, entityMap, log);
            pAst = this.postprocess(title, pAst, log);
        }
        catch (CompilerException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new CompilerException("Compilation failed!", e, log);
        }
        return new CompiledPage(new Page(pAst.getContent()), pAst.getWarnings(), log);
    }

    protected CompiledPage preprocessAndExpand(ExpansionCallback callback, PageId pageId, String wikitext, boolean forInclusion, EntityMap entityMap, Map<String, AstNode> arguments, ExpansionFrame rootFrame, ExpansionFrame parentFrame) throws CompilerException {
        LazyPreprocessedPage pprAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        if (wikitext == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        CompilerLog log = new CompilerLog();
        log.setTitle(title.getFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            String validatedWikitext = this.validate(title, wikitext, entityMap, log);
            LazyPreprocessedPage ppAst = this.preprocess(title, validatedWikitext, forInclusion, entityMap, log);
            pprAst = this.expand(callback, title, ppAst, entityMap, arguments, forInclusion, rootFrame, parentFrame, log);
        }
        catch (CompilerException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new CompilerException("Compilation failed!", e, log);
        }
        return new CompiledPage(new Page(pprAst.getContent()), pprAst.getWarnings(), log);
    }

    protected CompiledPage expand(ExpansionCallback callback, PageId pageId, LazyPreprocessedPage ppAst, EntityMap entityMap, boolean forInclusion, Map<String, AstNode> arguments, ExpansionFrame rootFrame, ExpansionFrame parentFrame) throws CompilerException {
        LazyPreprocessedPage pprAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        if (ppAst == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        CompilerLog log = new CompilerLog();
        log.setTitle(title.getFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            pprAst = this.expand(callback, title, ppAst, entityMap, arguments, forInclusion, rootFrame, parentFrame, log);
        }
        catch (CompilerException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new CompilerException("Compilation failed!", e, log);
        }
        return new CompiledPage(new Page(pprAst.getContent()), pprAst.getWarnings(), log);
    }

    private String validate(PageTitle title, String wikitext, EntityMap entityMap, ContentNode parentLog) throws CompilerException {
        ValidatorLog log = new ValidatorLog();
        parentLog.getContent().add((AstNode)log);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            String validatedWikitext;
            LazyEncodingValidator validator = new LazyEncodingValidator();
            String string = validatedWikitext = validator.validate(wikitext, title.getFullTitle(), entityMap);
            return string;
        }
        catch (Throwable e) {
            logger.error((Object)"Validation failed!", e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.getContent().add((AstNode)new UnhandledException(e, w.toString()));
            throw new CompilerException("Validation failed!", e);
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    private LazyPreprocessedPage preprocess(PageTitle title, String validatedWikitext, boolean forInclusion, EntityMap entityMap, ContentNode parentLog) throws CompilerException {
        PreprocessorLog log = new PreprocessorLog();
        parentLog.getContent().add((AstNode)log);
        log.setForInclusion(forInclusion);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            LazyPreprocessedPage preprocessedAst;
            LazyPreprocessor preprocessor = new LazyPreprocessor((ParserConfigInterface)this.wikiConfig);
            LazyPreprocessedPage lazyPreprocessedPage = preprocessedAst = (LazyPreprocessedPage)preprocessor.parseArticle(validatedWikitext, title.getFullTitle(), forInclusion);
            return lazyPreprocessedPage;
        }
        catch (xtc.parser.ParseException e) {
            log.getContent().add((AstNode)new ParseException(e.getMessage()));
            throw new CompilerException("Preprocessing failed!", e);
        }
        catch (Throwable e) {
            logger.error((Object)"Preprocessing failed!", e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.getContent().add((AstNode)new UnhandledException(e, w.toString()));
            throw new CompilerException("Preprocessing failed!", e);
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    private LazyPreprocessedPage expand(ExpansionCallback callback, PageTitle title, LazyPreprocessedPage ppAst, EntityMap entityMap, LinkedHashMap<String, AstNode> arguments, boolean forInclusion, ContentNode parentLog) throws CompilerException {
        return this.expand(callback, title, ppAst, entityMap, arguments, forInclusion, null, null, parentLog);
    }

    private LazyPreprocessedPage expand(ExpansionCallback callback, PageTitle title, LazyPreprocessedPage ppAst, EntityMap entityMap, Map<String, AstNode> arguments, boolean forInclusion, ExpansionFrame rootFrame, ExpansionFrame parentFrame, ContentNode parentLog) throws CompilerException {
        PpResolverLog log = new PpResolverLog();
        parentLog.getContent().add((AstNode)log);
        if (arguments == null) {
            arguments = new HashMap<String, AstNode>();
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            LazyPreprocessedPage expanded;
            ExpansionFrame frame = rootFrame != null ? new ExpansionFrame(this, callback, title, entityMap, arguments, forInclusion, rootFrame, parentFrame, ppAst.getWarnings(), log) : new ExpansionFrame(this, callback, title, entityMap, ppAst.getWarnings(), log);
            LazyPreprocessedPage lazyPreprocessedPage = expanded = (LazyPreprocessedPage)frame.expand((AstNode)ppAst);
            return lazyPreprocessedPage;
        }
        catch (Throwable e) {
            logger.error((Object)"Resolution failed!", e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.getContent().add((AstNode)new UnhandledException(e, w.toString()));
            throw new CompilerException("Resolution failed!", e);
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    private LazyParsedPage parse(PageTitle title, LazyPreprocessedPage ppAst, EntityMap entityMap, ContentNode parentLog) throws CompilerException {
        ParserLog log = new ParserLog();
        parentLog.getContent().add((AstNode)log);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            PreprocessedWikitext preprocessedWikitext = PreprocessorToParserTransformer.transform((LazyPreprocessedPage)ppAst, (EntityMap)entityMap, (boolean)true);
            LazyParser parser = new LazyParser((ParserConfigInterface)this.wikiConfig);
            LazyParsedPage parsedAst = (LazyParsedPage)parser.parseArticle(preprocessedWikitext, title.getTitle());
            parsedAst.getWarnings().addAll(ppAst.getWarnings());
            LazyParsedPage lazyParsedPage = parsedAst;
            return lazyParsedPage;
        }
        catch (xtc.parser.ParseException e) {
            log.getContent().add((AstNode)new ParseException(e.getMessage()));
            throw new CompilerException("Parsing failed!", e);
        }
        catch (Throwable e) {
            logger.error((Object)"Parsing failed!", e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.getContent().add((AstNode)new UnhandledException(e, w.toString()));
            throw new CompilerException("Parsing failed!", e);
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    private LazyParsedPage postprocess(PageTitle title, LazyParsedPage pAst, CompilerLog parentLog) throws CompilerException {
        PostprocessorLog log = new PostprocessorLog();
        parentLog.getContent().add((AstNode)log);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            LazyPostprocessor lpp = new LazyPostprocessor((ParserConfigInterface)this.wikiConfig);
            LazyParsedPage lazyParsedPage = pAst = (LazyParsedPage)lpp.postprocess((AstNode)pAst, title.getTitle());
            return lazyParsedPage;
        }
        catch (Throwable e) {
            logger.error((Object)"Postprocessing failed!", e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.getContent().add((AstNode)new UnhandledException(e, w.toString()));
            throw new CompilerException("Postprocessing failed!", e);
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }
}

