/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import org.sweble.wikitext.engine.OffendingNodeWarning;
import org.sweble.wikitext.lazy.parser.WarningSeverity;

public class IllegalPagenameWarning
extends OffendingNodeWarning {
    private static final long serialVersionUID = 1L;
    private final String titleString;

    public IllegalPagenameWarning(WarningSeverity severity, String origin, AstNode titleNode, String titleString) {
        super(titleNode, severity, origin, IllegalPagenameWarning.makeMessage(titleString));
        this.titleString = titleString;
    }

    public IllegalPagenameWarning(WarningSeverity severity, Class<?> origin, AstNode titleNode, String titleString) {
        super(titleNode, severity, origin, IllegalPagenameWarning.makeMessage(titleString));
        this.titleString = titleString;
    }

    private static String makeMessage(String titleString) {
        return "The given text `" + titleString + "' " + "does not constitute a valid page name";
    }

    public String getTitleString() {
        return this.titleString;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.titleString == null ? 0 : this.titleString.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IllegalPagenameWarning other = (IllegalPagenameWarning)((Object)obj);
        return !(this.titleString == null ? other.titleString != null : !this.titleString.equals(other.titleString));
    }
}

