/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import java.io.Serializable;
import org.sweble.wikitext.engine.config.Interwiki;
import org.sweble.wikitext.engine.config.Namespace;
import org.sweble.wikitext.engine.config.WikiConfigurationInterface;
import org.sweble.wikitext.lazy.LinkTargetException;
import org.sweble.wikitext.lazy.LinkTargetParser;
import org.sweble.wikitext.lazy.ParserConfigInterface;

public class PageTitle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String fragment;
    private final Namespace namespace;
    private final Interwiki interwiki;
    private final boolean initialColon;
    private final boolean isDefaultNs;

    public String getTitle() {
        return this.title;
    }

    public String getFragment() {
        return this.fragment;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Interwiki getInterwikiLink() {
        return this.interwiki;
    }

    public boolean isLocal() {
        return this.interwiki == null;
    }

    public boolean isInterwiki() {
        return !this.isLocal();
    }

    public boolean hasInitialColon() {
        return this.initialColon;
    }

    public String getFullTitle() {
        String result = "";
        if (this.interwiki != null) {
            result = result + this.interwiki.getPrefix() + ":";
        }
        if (this.namespace != null && !this.isDefaultNs) {
            result = result + this.namespace.getCanonical() + ":";
        }
        result = result + this.getDenormalizedTitle();
        return result;
    }

    public String getDenormalizedTitle() {
        return this.title.replace('_', ' ');
    }

    public String getLinkString() {
        String result = "";
        if (this.interwiki != null) {
            result = result + this.interwiki.getPrefix() + ":";
        }
        if (this.namespace != null && !this.isDefaultNs) {
            result = result + this.namespace.getCanonical() + ":";
        }
        result = result + this.title;
        if (this.fragment != null) {
            result = result + "#" + this.fragment;
        }
        return result;
    }

    protected PageTitle(String title, String fragment, Namespace namespace, Interwiki interwiki, boolean initialColon, boolean isDefaultNs) {
        this.title = title;
        this.fragment = fragment;
        this.namespace = namespace;
        this.interwiki = interwiki;
        this.initialColon = initialColon;
        this.isDefaultNs = isDefaultNs;
    }

    public static PageTitle make(WikiConfigurationInterface config, String target) throws LinkTargetException {
        return PageTitle.make(config, target, null);
    }

    public static PageTitle make(WikiConfigurationInterface config, String target, Namespace defaultNamespace) throws LinkTargetException {
        Interwiki interwiki;
        LinkTargetParser parser = new LinkTargetParser();
        parser.parse((ParserConfigInterface)config, target);
        String title = parser.getTitle();
        String fragment = parser.getFragment();
        boolean initialColon = parser.isInitialColon();
        Namespace namespace = null;
        if (parser.getNamespace() != null) {
            namespace = config.getNamespace(parser.getNamespace());
        }
        if (namespace == null && (namespace = defaultNamespace) == null) {
            namespace = config.getDefaultNamespace();
        }
        if ((interwiki = config.getInterwiki(parser.getInterwiki())) == null && title.length() > 0 && namespace.isCapitalized()) {
            title = Character.toUpperCase(title.charAt(0)) + title.substring(1);
        }
        boolean isDefaultNs = namespace.equals(config.getDefaultNamespace());
        return new PageTitle(title, fragment, namespace, interwiki, initialColon, isDefaultNs);
    }
}

