/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.ParserFunctionBase;
import org.sweble.wikitext.lazy.preprocessor.Template;
import org.sweble.wikitext.lazy.utils.TextUtils;
import org.sweble.wikitext.lazy.utils.WikitextPrinter;

public class ParserFunctionIfError
extends ParserFunctionBase {
    private static final long serialVersionUID = 1L;
    private static final Pattern classErrorPattern = Pattern.compile("<[^<>\\s]*?\\sclass\\s*=\\s*\"error\"[^<>]*>");

    public ParserFunctionIfError() {
        super("#iferror");
    }

    @Override
    public AstNode invoke(Template template, ExpansionFrame preprocessorFrame, LinkedList<AstNode> args) {
        AstNode result;
        if (args.size() < 1) {
            return new NodeList();
        }
        AstNode test = preprocessorFrame.expand(args.get(0));
        boolean wasError = this.searchForError(test);
        if (wasError) {
            result = null;
            if (args.size() >= 2) {
                result = args.get(1);
            }
        } else {
            result = test;
            if (args.size() >= 3) {
                result = args.get(2);
            }
        }
        if (result != test && result != null) {
            result = preprocessorFrame.expand(result);
        }
        if (result == null) {
            result = new NodeList();
        }
        if (result.isNodeType(2)) {
            return TextUtils.trim((NodeList)((NodeList)result));
        }
        return result;
    }

    private boolean searchForError(AstNode test) {
        String s = WikitextPrinter.print((AstNode)test);
        return classErrorPattern.matcher(s).find();
    }
}

