/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import de.fau.cs.osr.ptk.common.EntityMap;
import de.fau.cs.osr.ptk.common.Warning;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.ContentNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import de.fau.cs.osr.utils.StopWatch;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sweble.wikitext.engine.CompiledPage;
import org.sweble.wikitext.engine.Compiler;
import org.sweble.wikitext.engine.CompilerException;
import org.sweble.wikitext.engine.ExpansionCallback;
import org.sweble.wikitext.engine.ExpansionVisitor;
import org.sweble.wikitext.engine.FullPage;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.ParserFunctionBase;
import org.sweble.wikitext.engine.TagExtensionBase;
import org.sweble.wikitext.engine.config.Namespace;
import org.sweble.wikitext.engine.config.WikiConfigurationInterface;
import org.sweble.wikitext.engine.log.IllegalNameException;
import org.sweble.wikitext.engine.log.ParseException;
import org.sweble.wikitext.engine.log.ResolveRedirectLog;
import org.sweble.wikitext.engine.log.ResolveTransclusionLog;
import org.sweble.wikitext.engine.log.UnhandledException;
import org.sweble.wikitext.lazy.LinkTargetException;
import org.sweble.wikitext.lazy.preprocessor.Redirect;
import org.sweble.wikitext.lazy.preprocessor.TagExtension;
import org.sweble.wikitext.lazy.preprocessor.Template;
import org.sweble.wikitext.lazy.preprocessor.TemplateArgument;
import org.sweble.wikitext.lazy.preprocessor.TemplateParameter;
import org.sweble.wikitext.lazy.utils.StringConversionException;
import org.sweble.wikitext.lazy.utils.StringConverter;
import org.sweble.wikitext.lazy.utils.XmlAttribute;

public class ExpansionFrame {
    private final Compiler compiler;
    private final ExpansionFrame rootFrame;
    private final ExpansionFrame parentFrame;
    private final PageTitle title;
    private final Map<String, AstNode> arguments;
    private final boolean forInclusion;
    private final ContentNode frameLog;
    private final ExpansionCallback callback;
    private final List<Warning> warnings;
    private final EntityMap entityMap;

    public ExpansionFrame(Compiler compiler, ExpansionCallback callback, PageTitle title, EntityMap entityMap, List<Warning> warnings, ContentNode frameLog) {
        this.compiler = compiler;
        this.callback = callback;
        this.title = title;
        this.entityMap = entityMap;
        this.arguments = new HashMap<String, AstNode>();
        this.forInclusion = false;
        this.warnings = warnings;
        this.frameLog = frameLog;
        this.rootFrame = this;
        this.parentFrame = null;
    }

    public ExpansionFrame(Compiler compiler, ExpansionCallback callback, PageTitle title, EntityMap entityMap, Map<String, AstNode> arguments, boolean forInclusion, ExpansionFrame rootFrame, ExpansionFrame parentFrame, List<Warning> warnings, ContentNode frameLog) {
        this.compiler = compiler;
        this.callback = callback;
        this.title = title;
        this.entityMap = entityMap;
        this.arguments = arguments;
        this.forInclusion = forInclusion;
        this.warnings = warnings;
        this.frameLog = frameLog;
        this.rootFrame = rootFrame;
        this.parentFrame = parentFrame;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public ExpansionFrame getRootFrame() {
        return this.rootFrame;
    }

    public ExpansionFrame getParentFrame() {
        return this.parentFrame;
    }

    public PageTitle getTitle() {
        return this.title;
    }

    public Map<String, AstNode> getArguments() {
        return this.arguments;
    }

    public boolean isForInclusion() {
        return this.forInclusion;
    }

    public ContentNode getFrameLog() {
        return this.frameLog;
    }

    public WikiConfigurationInterface getWikiConfig() {
        return this.compiler.getWikiConfig();
    }

    public void fileWarning(Warning warning) {
        this.warnings.add(warning);
    }

    private void addAllWarnings(Collection<Warning> warnings) {
        this.warnings.addAll(warnings);
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public AstNode expand(AstNode ppAst) {
        return (AstNode)new ExpansionVisitor(this).go(ppAst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AstNode resolveRedirect(Redirect n, String target) {
        ResolveRedirectLog log = new ResolveRedirectLog(target, false);
        this.frameLog.getContent().add((AstNode)log);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            AstNode astNode = this.redirectTo(n, target, log);
            return astNode;
        }
        catch (LinkTargetException e) {
            log.getContent().add((AstNode)new ParseException(e.getMessage()));
            Redirect redirect = n;
            return redirect;
        }
        catch (Throwable e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.getContent().add((AstNode)new UnhandledException(e, w.toString()));
            Redirect redirect = n;
            return redirect;
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AstNode resolveParserFunction(Template n, String target, List<TemplateArgument> arguments) {
        ResolveTransclusionLog log = new ResolveTransclusionLog(target, false);
        this.frameLog.getContent().add((AstNode)log);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            ParserFunctionBase pfn = this.getWikiConfig().getParserFunction(target);
            if (pfn == null) {
                AstNode astNode = null;
                return astNode;
            }
            AstNode astNode = this.invokeParserFunction(n, pfn, arguments, log);
            return astNode;
        }
        catch (Throwable e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.getContent().add((AstNode)new UnhandledException(e, w.toString()));
            Template template = n;
            return template;
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AstNode resolveTransclusionOrMagicWord(Template n, String target, List<TemplateArgument> arguments) {
        ResolveTransclusionLog log = new ResolveTransclusionLog(target, false);
        this.frameLog.getContent().add((AstNode)log);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            ParserFunctionBase pfn;
            if (arguments.isEmpty() && (pfn = this.getWikiConfig().getParserFunction(target)) != null) {
                AstNode astNode = this.invokeParserFunction(n, pfn, arguments, log);
                return astNode;
            }
            pfn = this.transcludePage(n, target, arguments, log);
            return pfn;
        }
        catch (LinkTargetException e) {
            log.getContent().add((AstNode)new ParseException(e.getMessage()));
            Template template = n;
            return template;
        }
        catch (Throwable e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.getContent().add((AstNode)new UnhandledException(e, w.toString()));
            Template template = n;
            return template;
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    protected AstNode resolveParameter(TemplateParameter n, String name) {
        return this.arguments.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AstNode resolveTagExtension(TagExtension n, String name, NodeList attributes, String body) {
        ResolveTransclusionLog log = new ResolveTransclusionLog(name, false);
        this.frameLog.getContent().add((AstNode)log);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            TagExtensionBase te = this.getWikiConfig().getTagExtension(name);
            if (te == null) {
                TagExtension tagExtension = n;
                return tagExtension;
            }
            AstNode astNode = this.invokeTagExtension(n, attributes, body, te);
            return astNode;
        }
        catch (Throwable e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.getContent().add((AstNode)new UnhandledException(e, w.toString()));
            TagExtension tagExtension = n;
            return tagExtension;
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    private AstNode invokeTagExtension(TagExtension tagExtension, NodeList attributes, String body, TagExtensionBase te) {
        HashMap<String, NodeList> attrs = new HashMap<String, NodeList>();
        for (AstNode attr : attributes) {
            if (!attr.isNodeType(720929)) continue;
            XmlAttribute a = (XmlAttribute)attr;
            attrs.put(a.getName(), a.getValue());
        }
        return te.invoke(this, tagExtension, attrs, body);
    }

    protected void illegalTemplateName(StringConversionException e, NodeList name) {
        this.frameLog.getContent().add((AstNode)new IllegalNameException((AstNode)name, "Cannot resolve target of transclusion to a simple name."));
    }

    protected void illegalParameterName(StringConversionException e, NodeList name) {
        this.frameLog.getContent().add((AstNode)new IllegalNameException((AstNode)name, "Cannot resolve name of parameter to a simple name."));
    }

    private AstNode redirectTo(Redirect n, String target, ResolveRedirectLog log) throws LinkTargetException, CompilerException {
        PageTitle title = PageTitle.make(this.getWikiConfig(), target);
        log.setCanonical(title.getFullTitle());
        FullPage page = this.getWikitext(title, log);
        if (page == null) {
            return n;
        }
        CompiledPage compiledPage = this.compiler.preprocessAndExpand(this.callback, page.getId(), page.getText(), this.forInclusion, this.entityMap, this.arguments, this.rootFrame, this);
        log.setSuccess(true);
        log.getContent().add((AstNode)compiledPage.getLog());
        this.addAllWarnings(compiledPage.getWarnings());
        return compiledPage.getPage().getContent();
    }

    private AstNode transcludePage(Template n, String target, List<TemplateArgument> arguments, ResolveTransclusionLog log) throws LinkTargetException, CompilerException {
        Namespace tmplNs = this.getWikiConfig().getTemplateNamespace();
        PageTitle title = PageTitle.make(this.getWikiConfig(), target, tmplNs);
        log.setCanonical(title.getFullTitle());
        FullPage page = this.getWikitext(title, log);
        if (page == null) {
            return null;
        }
        Map<String, AstNode> args = this.prepareTransclusionArguments(arguments);
        CompiledPage compiledPage = this.compiler.preprocessAndExpand(this.callback, page.getId(), page.getText(), true, this.entityMap, args, this.rootFrame, this);
        log.setSuccess(true);
        log.getContent().add((AstNode)compiledPage.getLog());
        this.addAllWarnings(compiledPage.getWarnings());
        return compiledPage.getPage().getContent();
    }

    private Map<String, AstNode> prepareTransclusionArguments(List<TemplateArgument> arguments) {
        HashMap<String, AstNode> args = new HashMap<String, AstNode>();
        for (TemplateArgument arg : arguments) {
            String id = String.valueOf(args.size() + 1);
            args.put(id, (AstNode)arg.getValue());
            if (!arg.getHasName()) continue;
            try {
                String name = StringConverter.convert((AstNode)arg.getName());
                if ((name = name.trim()).isEmpty() || name.equals(id)) continue;
                args.put(name, (AstNode)arg.getValue());
            }
            catch (StringConversionException e) {
                this.illegalParameterName(e, arg.getName());
            }
        }
        return args;
    }

    private AstNode invokeParserFunction(Template template, ParserFunctionBase pfn, List<TemplateArgument> arguments, ResolveTransclusionLog log) {
        LinkedList<AstNode> args = new LinkedList<AstNode>();
        for (TemplateArgument arg : arguments) {
            if (arg.getHasName()) {
                args.add((AstNode)new NodeList((AstNode)arg.getName(), (AstNode)new Text("="), (AstNode)arg.getValue()));
                continue;
            }
            args.add((AstNode)arg.getValue());
        }
        AstNode result = pfn.invoke(template, this, args);
        log.setSuccess(true);
        return result;
    }

    private FullPage getWikitext(PageTitle title, ContentNode log) {
        try {
            return this.callback.retrieveWikitext(this, title);
        }
        catch (Exception e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.getContent().add((AstNode)new UnhandledException(e, w.toString()));
            return null;
        }
    }
}

