/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import de.fau.cs.osr.utils.Tuple2;
import java.util.LinkedList;
import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.lazy.preprocessor.Redirect;
import org.sweble.wikitext.lazy.preprocessor.TagExtension;
import org.sweble.wikitext.lazy.preprocessor.Template;
import org.sweble.wikitext.lazy.preprocessor.TemplateArgument;
import org.sweble.wikitext.lazy.preprocessor.TemplateParameter;
import org.sweble.wikitext.lazy.utils.StringConversionException;
import org.sweble.wikitext.lazy.utils.StringConverter;
import org.sweble.wikitext.lazy.utils.StringConverterPartial;

public final class ExpansionVisitor
extends AstVisitor {
    private final ExpansionFrame preprocessorFrame;

    public ExpansionVisitor(ExpansionFrame preprocessorFrame) {
        this.preprocessorFrame = preprocessorFrame;
    }

    public AstNode visit(AstNode n) {
        this.mapInPlace(n);
        return n;
    }

    public AstNode visit(Redirect n) {
        String target = n.getTarget();
        AstNode result = this.preprocessorFrame.resolveRedirect(n, target);
        if (result == null) {
            result = n;
        }
        return result;
    }

    public AstNode visit(Template n) {
        Template result = null;
        Tuple2 converted = StringConverterPartial.convert((AstNode)n.getName());
        String title = (String)converted._1;
        NodeList tail = (NodeList)converted._2;
        List args = this.map((AstNode)n.getArgs());
        int i = title.indexOf(58);
        if (i != -1) {
            String pfn = title.substring(0, i).trim();
            NodeList arg0 = new NodeList((AstNode)new Text(title.substring(i + 1)), (AstNode)tail);
            LinkedList<TemplateArgument> pfnArgs = new LinkedList<TemplateArgument>(args);
            pfnArgs.addFirst(new TemplateArgument(arg0, false));
            result = this.preprocessorFrame.resolveParserFunction(n, pfn, pfnArgs);
        }
        if (result == null) {
            if (tail == null) {
                result = this.preprocessorFrame.resolveTransclusionOrMagicWord(n, title, args);
            } else {
                this.preprocessorFrame.illegalTemplateName(new StringConversionException((AstNode)tail), n.getName());
            }
        }
        if (result == null) {
            result = n;
        }
        return result;
    }

    public AstNode visit(TemplateParameter n) {
        this.dispatch((AstNode)n.getName());
        String name = null;
        try {
            name = StringConverter.convert((AstNode)n.getName());
        }
        catch (StringConversionException e) {
            this.preprocessorFrame.illegalParameterName(e, n.getName());
        }
        TemplateParameter value = null;
        if (name != null) {
            name = name.trim();
            value = this.preprocessorFrame.resolveParameter(n, name);
        }
        if (value == null && n.getDefaultValue() != null) {
            TemplateArgument arg = n.getDefaultValue();
            this.dispatch((AstNode)arg.getValue());
            if (arg.getHasName()) {
                this.dispatch((AstNode)arg.getName());
                value = new NodeList();
                value.add((AstNode)arg.getName());
                value.add((AstNode)new Text("="));
                value.add((AstNode)arg.getValue());
            } else {
                value = arg.getValue();
            }
        }
        if (value == null) {
            value = n;
        }
        return value;
    }

    public AstNode visit(TagExtension n) {
        return this.preprocessorFrame.resolveTagExtension(n, n.getName(), n.getXmlAttributes(), n.getBody());
    }
}

