/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

public class MagicWord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Boolean caseSensitive;
    private TreeSet<String> aliases;

    public MagicWord(String name, Boolean caseSensitive, Collection<String> aliases) {
        this.name = name;
        this.caseSensitive = caseSensitive;
        this.aliases = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return MagicWord.this.caseSensitive != false ? o1.compareTo(o2) : o1.compareToIgnoreCase(o2);
            }
        });
        this.aliases.addAll(aliases);
    }

    public String getName() {
        return this.name;
    }

    public Boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public TreeSet<String> getAliases() {
        return this.aliases;
    }

    public boolean hasAlias(String alias) {
        return this.aliases.contains(alias);
    }
}

