/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext;

import de.fau.cs.osr.ptk.common.Warning;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.Text;
import java.util.LinkedList;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.IllegalArgumentsWarning;
import org.sweble.wikitext.engine.IllegalNameWarning;
import org.sweble.wikitext.engine.IllegalPagenameWarning;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.ParserFunctionBase;
import org.sweble.wikitext.engine.config.Interwiki;
import org.sweble.wikitext.lazy.LinkTargetException;
import org.sweble.wikitext.lazy.parser.WarningSeverity;
import org.sweble.wikitext.lazy.preprocessor.Template;
import org.sweble.wikitext.lazy.utils.StringConversionException;
import org.sweble.wikitext.lazy.utils.StringConverter;

public class ParserFunctionFullurl
extends ParserFunctionBase {
    private static final long serialVersionUID = 1L;

    public ParserFunctionFullurl() {
        super("fullurl");
    }

    @Override
    public AstNode invoke(Template template, ExpansionFrame preprocessorFrame, LinkedList<AstNode> args) {
        PageTitle title;
        String titleStr;
        if (args.size() < 1) {
            preprocessorFrame.fileWarning((Warning)new IllegalArgumentsWarning(WarningSeverity.NORMAL, this.getClass(), "Parser function was called with too few arguments!", (AstNode)template));
            return template;
        }
        if (args.size() > 2) {
            preprocessorFrame.fileWarning((Warning)new IllegalArgumentsWarning(WarningSeverity.NONE, this.getClass(), "Parser function was called with too many arguments!", (AstNode)template));
        }
        AstNode titleNode = args.get(0);
        AstNode expTitleNode = preprocessorFrame.expand(titleNode);
        try {
            titleStr = StringConverter.convert((AstNode)expTitleNode).trim();
        }
        catch (StringConversionException e1) {
            preprocessorFrame.fileWarning((Warning)new IllegalNameWarning(WarningSeverity.NORMAL, this.getClass(), expTitleNode));
            return template;
        }
        try {
            title = PageTitle.make(preprocessorFrame.getWikiConfig(), titleStr);
        }
        catch (LinkTargetException e) {
            preprocessorFrame.fileWarning((Warning)new IllegalPagenameWarning(WarningSeverity.NORMAL, this.getClass(), titleNode, titleStr));
            return template;
        }
        Interwiki iw = title.getInterwikiLink();
        String result = iw != null ? iw.getUrl() : preprocessorFrame.getWikiConfig().getWikiUrl();
        Text text = null;
        if (args.size() >= 2) {
            AstNode queryNode = preprocessorFrame.expand(args.get(1));
            try {
                String queryStr = StringConverter.convert((AstNode)queryNode).trim();
                result = result + title.getLinkString();
                result = result + "&" + queryStr;
                text = new Text(result);
            }
            catch (StringConversionException e) {
                preprocessorFrame.fileWarning((Warning)new IllegalNameWarning(WarningSeverity.NORMAL, this.getClass(), expTitleNode));
            }
        } else {
            result = result + title.getLinkString();
            text = new Text(result);
        }
        return text;
    }
}

