/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import java.util.LinkedList;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.ParserFunctionBase;
import org.sweble.wikitext.lazy.preprocessor.Template;
import org.sweble.wikitext.lazy.utils.StringConversionException;
import org.sweble.wikitext.lazy.utils.StringConverter;

public class ParserFunctionSwitch
extends ParserFunctionBase {
    private static final long serialVersionUID = 1L;

    public ParserFunctionSwitch() {
        super("#switch");
    }

    @Override
    public AstNode invoke(Template template, ExpansionFrame preprocessorFrame, LinkedList<AstNode> args) {
        if (args.size() < 1) {
            return new NodeList();
        }
        AstNode arg0 = preprocessorFrame.expand(args.get(0));
        String cmp = null;
        try {
            cmp = StringConverter.convert((AstNode)arg0).trim();
        }
        catch (StringConversionException e) {
            // empty catch block
        }
        boolean numbers = false;
        double icmp = -1.0;
        if (cmp != null) {
            try {
                icmp = Double.parseDouble(cmp);
                numbers = true;
            }
            catch (NumberFormatException e) {
                numbers = false;
            }
        }
        boolean found = false;
        AstNode result = null;
        for (int i = 1; i < args.size(); ++i) {
            NodeList after = null;
            NodeList before = new NodeList();
            if (args.get(i).isNodeType(2)) {
                for (AstNode c : args.get(i)) {
                    if (after == null) {
                        if (c.isNodeType(4097)) {
                            String text = ((Text)c).getContent();
                            int j = text.indexOf(61);
                            if (j != -1) {
                                before.add((AstNode)new Text(text.substring(0, j)));
                                after = new NodeList((AstNode)new Text(text.substring(j + 1)));
                                continue;
                            }
                            before.add(c);
                            continue;
                        }
                        before.add(c);
                        continue;
                    }
                    after.add(c);
                }
            } else {
                AstNode c = args.get(i);
                if (c.isNodeType(4097)) {
                    String text = ((Text)c).getContent();
                    int j = text.indexOf(61);
                    if (j != -1) {
                        before.add((AstNode)new Text(text.substring(0, j)));
                        after = new NodeList((AstNode)new Text(text.substring(j + 1)));
                    } else {
                        before.add(c);
                    }
                }
            }
            if (!found) {
                String cmp2;
                before = (NodeList)preprocessorFrame.expand((AstNode)before);
                try {
                    cmp2 = StringConverter.convert((AstNode)before).trim();
                }
                catch (StringConversionException e) {
                    continue;
                }
                if (cmp2.equals("#default")) {
                    result = after;
                    break;
                }
                if (numbers) {
                    double icmp2 = -1.0;
                    try {
                        icmp2 = Double.parseDouble(cmp2);
                        if (icmp == icmp2) {
                            found = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (!found && cmp != null && cmp.equals(cmp2)) {
                    found = true;
                }
            }
            if (!found || after == null) continue;
            result = after;
            break;
        }
        if (result != null) {
            result = preprocessorFrame.expand(result);
        }
        if (result == null) {
            result = new NodeList();
        }
        return result;
    }
}

