/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import de.fau.cs.osr.ptk.common.Warning;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sweble.wikitext.engine.ExpansionCallback;
import org.sweble.wikitext.engine.ExpansionDebugHooks;
import org.sweble.wikitext.engine.ExpansionException;
import org.sweble.wikitext.engine.ExpansionVisitor;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.WtEngineImpl;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.nodes.EngLogContainer;
import org.sweble.wikitext.engine.utils.UrlService;
import org.sweble.wikitext.parser.WtEntityMap;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;

public class ExpansionFrame {
    private final WtEngineImpl engine;
    private final ExpansionFrame rootFrame;
    private final ExpansionFrame parentFrame;
    private final PageTitle title;
    private final Map<String, WtNodeList> arguments;
    private final boolean forInclusion;
    private final EngLogContainer frameLog;
    private final ExpansionCallback callback;
    private final List<Warning> warnings;
    private final WtEntityMap entityMap;
    private final boolean noRedirect;
    private ExpansionVisitor expansionVisitor;
    private UrlService urlService = new UrlService();

    public ExpansionFrame(WtEngineImpl engine, ExpansionCallback callback, ExpansionDebugHooks hooks, PageTitle title, WtEntityMap entityMap, boolean noRedirect, List<Warning> warnings, EngLogContainer frameLog, boolean timingEnabled, boolean catchAll) {
        this.engine = engine;
        this.callback = callback;
        this.title = title;
        this.entityMap = entityMap;
        this.arguments = new HashMap<String, WtNodeList>();
        this.forInclusion = false;
        this.noRedirect = noRedirect;
        this.warnings = warnings;
        this.frameLog = frameLog;
        this.rootFrame = this;
        this.parentFrame = null;
        this.expansionVisitor = new ExpansionVisitor(this, frameLog, hooks, timingEnabled, catchAll);
    }

    public ExpansionFrame(WtEngineImpl engine, ExpansionCallback callback, ExpansionDebugHooks hooks, PageTitle title, WtEntityMap entityMap, Map<String, WtNodeList> arguments, boolean forInclusion, boolean noRedirect, ExpansionFrame rootFrame, ExpansionFrame parentFrame, List<Warning> warnings, EngLogContainer frameLog, boolean timingEnabled, boolean catchAll) {
        this.engine = engine;
        this.callback = callback;
        this.title = title;
        this.entityMap = entityMap;
        this.arguments = arguments;
        this.forInclusion = forInclusion;
        this.noRedirect = noRedirect;
        this.warnings = warnings;
        this.frameLog = frameLog;
        this.rootFrame = rootFrame;
        this.parentFrame = parentFrame;
        this.expansionVisitor = new ExpansionVisitor(this, frameLog, hooks, timingEnabled, catchAll);
    }

    public WtEngineImpl getEngine() {
        return this.engine;
    }

    public ExpansionFrame getRootFrame() {
        return this.rootFrame;
    }

    public ExpansionFrame getParentFrame() {
        return this.parentFrame;
    }

    public PageTitle getTitle() {
        return this.title;
    }

    public Map<String, WtNodeList> getArguments() {
        return this.arguments;
    }

    public boolean isForInclusion() {
        return this.forInclusion;
    }

    public EngLogContainer getFrameLog() {
        return this.frameLog;
    }

    public WikiConfig getWikiConfig() {
        return this.engine.getWikiConfig();
    }

    public void fileWarning(Warning warning) {
        this.warnings.add(warning);
    }

    public void addWarnings(Collection<Warning> warnings) {
        this.warnings.addAll(warnings);
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public WtEntityMap getEntityMap() {
        return this.entityMap;
    }

    public ExpansionCallback getCallback() {
        return this.callback;
    }

    public boolean isNoRedirect() {
        return this.noRedirect;
    }

    public UrlService getUrlService() {
        return this.urlService;
    }

    public WtNode expand(WtNode ppAst) throws ExpansionException {
        try {
            return (WtNode)this.expansionVisitor.go((AstNode)ppAst);
        }
        catch (Exception e) {
            throw new ExpansionException(e);
        }
    }

    public boolean existsPage(PageTitle pageTitle) {
        return this.callback.retrieveWikitext(this, pageTitle) != null || this.callback.fileUrl(pageTitle, -1, -1) != null;
    }
}

