/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import org.sweble.wikitext.engine.OffendingNodeWarning;
import org.sweble.wikitext.parser.WikitextWarning;
import org.sweble.wikitext.parser.nodes.WtNode;

public class InvalidPagenameWarning
extends OffendingNodeWarning {
    private static final long serialVersionUID = 1L;
    private final String titleString;

    public InvalidPagenameWarning(WikitextWarning.WarningSeverity severity, String origin, WtNode titleNode, String titleString) {
        super(titleNode, severity, origin, InvalidPagenameWarning.makeMessage(titleString));
        this.titleString = titleString;
    }

    public InvalidPagenameWarning(WikitextWarning.WarningSeverity severity, Class<?> origin, WtNode titleNode, String titleString) {
        super(titleNode, severity, origin, InvalidPagenameWarning.makeMessage(titleString));
        this.titleString = titleString;
    }

    private static String makeMessage(String titleString) {
        return "The given text `" + titleString + "' does not constitute a valid page name";
    }

    public String getTitleString() {
        return this.titleString;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.titleString == null ? 0 : this.titleString.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InvalidPagenameWarning other = (InvalidPagenameWarning)((Object)obj);
        return !(this.titleString == null ? other.titleString != null : !this.titleString.equals(other.titleString));
    }
}

