/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import de.fau.cs.osr.ptk.common.Warning;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.utils.StopWatch;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sweble.wikitext.engine.EngineException;
import org.sweble.wikitext.engine.ExpansionCallback;
import org.sweble.wikitext.engine.ExpansionDebugHooks;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.PageId;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.WtEngine;
import org.sweble.wikitext.engine.config.EngineConfig;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.nodes.EngLogContainer;
import org.sweble.wikitext.engine.nodes.EngLogExpansionPass;
import org.sweble.wikitext.engine.nodes.EngLogParserPass;
import org.sweble.wikitext.engine.nodes.EngLogPostprocessorPass;
import org.sweble.wikitext.engine.nodes.EngLogPreprocessorPass;
import org.sweble.wikitext.engine.nodes.EngLogProcessingPass;
import org.sweble.wikitext.engine.nodes.EngLogValidatorPass;
import org.sweble.wikitext.engine.nodes.EngProcessedPage;
import org.sweble.wikitext.engine.nodes.EngineNodeFactory;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.WikitextEncodingValidator;
import org.sweble.wikitext.parser.WikitextParser;
import org.sweble.wikitext.parser.WikitextPostprocessor;
import org.sweble.wikitext.parser.WikitextPreprocessor;
import org.sweble.wikitext.parser.WtEntityMap;
import org.sweble.wikitext.parser.WtEntityMapImpl;
import org.sweble.wikitext.parser.encval.ValidatedWikitext;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtParsedWikitextPage;
import org.sweble.wikitext.parser.nodes.WtPreproWikitextPage;
import org.sweble.wikitext.parser.parser.PreprocessorToParserTransformer;
import org.sweble.wikitext.parser.preprocessor.PreprocessedWikitext;
import xtc.parser.ParseException;

public class WtEngineImpl
implements WtEngine {
    private static final Logger logger = LoggerFactory.getLogger(WtEngineImpl.class);
    private WikiConfig wikiConfig;
    private ParserConfig parserConfig;
    private EngineConfig engineConfig;
    private ExpansionDebugHooks hooks;
    private boolean noRedirect = false;
    private boolean timingEnabled = false;
    private boolean catchAll = true;

    public WtEngineImpl(WikiConfig wikiConfig) {
        this.wikiConfig = wikiConfig;
        this.parserConfig = wikiConfig.getParserConfig();
        this.engineConfig = wikiConfig.getEngineConfig();
    }

    @Override
    public void setDebugHooks(ExpansionDebugHooks hooks) {
        this.hooks = hooks;
    }

    @Override
    public void setNoRedirect(boolean noRedirect) {
        this.noRedirect = noRedirect;
    }

    @Override
    public void setTimingEnabled(boolean timingEnabled) {
        this.timingEnabled = timingEnabled;
    }

    @Override
    public void setCatchAll(boolean catchAll) {
        this.catchAll = catchAll;
    }

    @Override
    public WikiConfig getWikiConfig() {
        return this.wikiConfig;
    }

    @Override
    public ExpansionDebugHooks getDebugHooks() {
        return this.hooks;
    }

    @Override
    public boolean isNoRedirect() {
        return this.noRedirect;
    }

    @Override
    public boolean isTimingEnabled() {
        return this.timingEnabled;
    }

    @Override
    public boolean isCatchAll() {
        return this.catchAll;
    }

    @Override
    public EngineNodeFactory nf() {
        return this.wikiConfig.getNodeFactory();
    }

    @Override
    public EngProcessedPage preprocess(PageId pageId, String wikitext, boolean forInclusion, ExpansionCallback callback) throws EngineException {
        WtPreproWikitextPage pprAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        EngLogProcessingPass log = this.nf().logProcessingPass();
        log.setTitle(title.getDenormalizedFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            WtPreproWikitextPage ppAst;
            ValidatedWikitext validatedWikitext = this.validate(title, wikitext, log, null);
            pprAst = ppAst = this.preprocess(title, validatedWikitext, forInclusion, log);
            if (callback != null) {
                pprAst = this.expand(callback, title, ppAst, null, false, log);
            }
        }
        catch (EngineException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new EngineException(title, "Compilation failed!", e, log);
        }
        return this.nf().processedPage(this.nf().page((WtNodeList)pprAst), log, pprAst.getWarnings());
    }

    @Override
    public EngProcessedPage expand(PageId pageId, String wikitext, ExpansionCallback callback) throws EngineException {
        return this.expand(pageId, wikitext, false, callback);
    }

    @Override
    public EngProcessedPage expand(PageId pageId, String wikitext, boolean forInclusion, ExpansionCallback callback) throws EngineException {
        WtPreproWikitextPage pAst;
        if (pageId == null || callback == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        EngLogProcessingPass log = this.nf().logProcessingPass();
        log.setTitle(title.getDenormalizedFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            WtPreproWikitextPage ppAst;
            ValidatedWikitext validatedWikitext = this.validate(title, wikitext, log, null);
            WtPreproWikitextPage pprAst = ppAst = this.preprocess(title, validatedWikitext, forInclusion, log);
            pAst = pprAst = this.expand(callback, title, ppAst, null, forInclusion, log);
        }
        catch (EngineException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new EngineException(title, "Compilation failed!", e, log);
        }
        return this.nf().processedPage(this.nf().page((WtNodeList)pAst), log, pAst.getWarnings(), pAst.getEntityMap());
    }

    @Override
    public EngProcessedPage parse(PageId pageId, String wikitext, ExpansionCallback callback) throws EngineException {
        WtParsedWikitextPage pAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        EngLogProcessingPass log = this.nf().logProcessingPass();
        log.setTitle(title.getDenormalizedFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            WtPreproWikitextPage ppAst;
            ValidatedWikitext validatedWikitext = this.validate(title, wikitext, log, null);
            WtPreproWikitextPage pprAst = ppAst = this.preprocess(title, validatedWikitext, false, log);
            if (callback != null) {
                pprAst = this.expand(callback, title, ppAst, null, false, log);
            }
            pAst = this.parse(title, pprAst, (EngLogContainer)log);
        }
        catch (EngineException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new EngineException(title, "Compilation failed!", e, log);
        }
        return this.nf().processedPage(this.nf().page((WtNodeList)pAst), log, pAst.getWarnings());
    }

    public EngProcessedPage parseAndPostprocess(PageId pageId, String wikitext, ExpansionCallback callback) throws EngineException {
        WtParsedWikitextPage pAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        EngLogProcessingPass log = this.nf().logProcessingPass();
        log.setTitle(title.getDenormalizedFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            pAst = this.parse(title, wikitext, (EngLogContainer)log);
            pAst = this.postprocess(title, pAst, log);
        }
        catch (EngineException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new EngineException(title, "Compilation failed!", e, log);
        }
        return this.nf().processedPage(this.nf().page((WtNodeList)pAst), log, pAst.getWarnings());
    }

    @Override
    public EngProcessedPage postprocess(PageId pageId, String wikitext, ExpansionCallback callback) throws EngineException {
        WtParsedWikitextPage pAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        EngLogProcessingPass log = this.nf().logProcessingPass();
        log.setTitle(title.getDenormalizedFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            WtPreproWikitextPage ppAst;
            ValidatedWikitext validatedWikitext = this.validate(title, wikitext, log, null);
            WtPreproWikitextPage pprAst = ppAst = this.preprocess(title, validatedWikitext, false, log);
            if (callback != null) {
                pprAst = this.expand(callback, title, ppAst, null, false, log);
            }
            pAst = this.parse(title, pprAst, (EngLogContainer)log);
            pAst = this.postprocess(title, pAst, log);
        }
        catch (EngineException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new EngineException(title, "Compilation failed!", e, log);
        }
        return this.nf().processedPage(this.nf().page((WtNodeList)pAst), log, pAst.getWarnings());
    }

    @Override
    public EngProcessedPage postprocessPpOrExpAst(PageId pageId, WtPreproWikitextPage pprAst) throws EngineException {
        WtParsedWikitextPage pAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        EngLogProcessingPass log = this.nf().logProcessingPass();
        log.setTitle(title.getDenormalizedFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            pAst = this.parse(title, pprAst, (EngLogContainer)log);
            pAst = this.postprocess(title, pAst, log);
        }
        catch (EngineException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new EngineException(title, "Compilation failed!", e, log);
        }
        return this.nf().processedPage(this.nf().page((WtNodeList)pAst), log, pAst.getWarnings());
    }

    protected EngProcessedPage preprocessAndExpand(ExpansionCallback callback, PageId pageId, String wikitext, boolean forInclusion, WtEntityMap entityMap, Map<String, WtNodeList> arguments, ExpansionFrame rootFrame, ExpansionFrame parentFrame) throws EngineException {
        WtPreproWikitextPage pprAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        if (wikitext == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        EngLogProcessingPass log = this.nf().logProcessingPass();
        log.setTitle(title.getDenormalizedFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            ValidatedWikitext validatedWikitext = this.validate(title, wikitext, log, entityMap);
            WtPreproWikitextPage ppAst = this.preprocess(title, validatedWikitext, forInclusion, log);
            pprAst = this.expand(callback, title, ppAst, arguments, forInclusion, rootFrame, parentFrame, log);
        }
        catch (EngineException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new EngineException(title, "Compilation failed!", e, log);
        }
        return this.nf().processedPage(this.nf().page((WtNodeList)pprAst), log, pprAst.getWarnings());
    }

    protected EngProcessedPage expand(ExpansionCallback callback, PageId pageId, WtPreproWikitextPage ppAst, WtEntityMap entityMap, boolean forInclusion, Map<String, WtNodeList> arguments, ExpansionFrame rootFrame, ExpansionFrame parentFrame) throws EngineException {
        WtPreproWikitextPage pprAst;
        if (pageId == null) {
            throw new NullPointerException();
        }
        if (ppAst == null) {
            throw new NullPointerException();
        }
        PageTitle title = pageId.getTitle();
        EngLogProcessingPass log = this.nf().logProcessingPass();
        log.setTitle(title.getDenormalizedFullTitle());
        log.setRevision(pageId.getRevision());
        try {
            pprAst = this.expand(callback, title, ppAst, arguments, forInclusion, rootFrame, parentFrame, log);
        }
        catch (EngineException e) {
            e.attachLog(log);
            throw e;
        }
        catch (Throwable e) {
            throw new EngineException(title, "Compilation failed!", e, log);
        }
        return this.nf().processedPage(this.nf().page((WtNodeList)pprAst), log, pprAst.getWarnings());
    }

    private ValidatedWikitext validate(PageTitle title, String wikitext, EngLogContainer parentLog, WtEntityMap entityMap) throws EngineException {
        EngLogValidatorPass log = this.nf().logValidatorPass();
        parentLog.add((AstNode)log);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            ValidatedWikitext validatedWikitext;
            WikitextEncodingValidator validator = new WikitextEncodingValidator();
            if (entityMap == null) {
                entityMap = new WtEntityMapImpl();
            }
            ValidatedWikitext validatedWikitext2 = validatedWikitext = validator.validate(this.parserConfig, entityMap, title.getDenormalizedFullTitle(), wikitext);
            return validatedWikitext2;
        }
        catch (Exception e) {
            logger.error("Validation failed!", (Throwable)e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.add((AstNode)this.nf().logUnhandledError(e, w.toString()));
            throw new EngineException(title, "Validation failed!", e);
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    private WtPreproWikitextPage preprocess(PageTitle title, ValidatedWikitext validatedWikitext, boolean forInclusion, EngLogContainer parentLog) throws EngineException {
        EngLogPreprocessorPass log = this.nf().logPreprocessorPass();
        parentLog.add((AstNode)log);
        log.setForInclusion(forInclusion);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            WtPreproWikitextPage preprocessedAst;
            WikitextPreprocessor preprocessor = new WikitextPreprocessor(this.parserConfig);
            WtPreproWikitextPage wtPreproWikitextPage = preprocessedAst = (WtPreproWikitextPage)preprocessor.parseArticle(validatedWikitext, title.getDenormalizedFullTitle(), forInclusion);
            return wtPreproWikitextPage;
        }
        catch (ParseException e) {
            log.add((AstNode)this.nf().logParserError(e.getMessage()));
            throw new EngineException(title, "Preprocessing failed!", e);
        }
        catch (Exception e) {
            logger.error("Preprocessing failed!", (Throwable)e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.add((AstNode)this.nf().logUnhandledError(e, w.toString()));
            throw new EngineException(title, "Preprocessing failed!", e);
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    private WtPreproWikitextPage expand(ExpansionCallback callback, PageTitle title, WtPreproWikitextPage ppAst, LinkedHashMap<String, WtNodeList> arguments, boolean forInclusion, EngLogContainer parentLog) throws EngineException {
        return this.expand(callback, title, ppAst, arguments, forInclusion, null, null, parentLog);
    }

    private WtPreproWikitextPage expand(ExpansionCallback callback, PageTitle title, WtPreproWikitextPage ppAst, Map<String, WtNodeList> arguments, boolean forInclusion, ExpansionFrame rootFrame, ExpansionFrame parentFrame, EngLogContainer parentLog) throws EngineException {
        EngLogExpansionPass log = this.nf().logExpansionPass();
        parentLog.add((AstNode)log);
        if (arguments == null) {
            arguments = new HashMap<String, WtNodeList>();
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            LinkedList<Warning> warnings = new LinkedList<Warning>(ppAst.getWarnings());
            ExpansionFrame frame = rootFrame != null ? new ExpansionFrame(this, callback, this.hooks, title, ppAst.getEntityMap(), arguments, forInclusion, this.noRedirect, rootFrame, parentFrame, warnings, log, this.timingEnabled, this.catchAll) : new ExpansionFrame(this, callback, this.hooks, title, ppAst.getEntityMap(), this.noRedirect, warnings, log, this.timingEnabled, this.catchAll);
            WtPreproWikitextPage expanded = (WtPreproWikitextPage)frame.expand((WtNode)ppAst);
            if (!warnings.isEmpty()) {
                ppAst.setWarnings(warnings);
            }
            WtPreproWikitextPage wtPreproWikitextPage = expanded;
            return wtPreproWikitextPage;
        }
        catch (Exception e) {
            logger.error("Resolution failed!", (Throwable)e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.add((AstNode)this.nf().logUnhandledError(e, w.toString()));
            throw new EngineException(title, "Resolution failed!", e);
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    private WtParsedWikitextPage parse(PageTitle title, String wikitext, EngLogContainer parentLog) throws EngineException {
        EngLogParserPass log = this.nf().logParserPass();
        parentLog.add((AstNode)log);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            WtParsedWikitextPage parsedAst;
            WikitextParser parser = new WikitextParser(this.parserConfig);
            WtParsedWikitextPage wtParsedWikitextPage = parsedAst = (WtParsedWikitextPage)parser.parseArticle(wikitext, title.getTitle());
            return wtParsedWikitextPage;
        }
        catch (ParseException e) {
            log.add((AstNode)this.nf().logParserError(e.getMessage()));
            throw new EngineException(title, "Parsing failed!", e);
        }
        catch (Exception e) {
            logger.error("Parsing failed!", (Throwable)e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.add((AstNode)this.nf().logUnhandledError(e, w.toString()));
            throw new EngineException(title, "Parsing failed!", e);
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    private WtParsedWikitextPage parse(PageTitle title, WtPreproWikitextPage ppAst, EngLogContainer parentLog) throws EngineException {
        EngLogParserPass log = this.nf().logParserPass();
        parentLog.add((AstNode)log);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            PreprocessedWikitext preprocessedWikitext = PreprocessorToParserTransformer.transform((WtPreproWikitextPage)ppAst, (boolean)this.engineConfig.isTrimTransparentBeforeParsing());
            WikitextParser parser = new WikitextParser(this.parserConfig);
            WtParsedWikitextPage parsedAst = (WtParsedWikitextPage)parser.parseArticle(preprocessedWikitext, title.getTitle());
            if (parsedAst.getWarnings() == Collections.EMPTY_LIST) {
                parsedAst.setWarnings(ppAst.getWarnings());
            } else {
                parsedAst.getWarnings().addAll(ppAst.getWarnings());
            }
            WtParsedWikitextPage wtParsedWikitextPage = parsedAst;
            return wtParsedWikitextPage;
        }
        catch (ParseException e) {
            log.add((AstNode)this.nf().logParserError(e.getMessage()));
            throw new EngineException(title, "Parsing failed!", e);
        }
        catch (Exception e) {
            logger.error("Parsing failed!", (Throwable)e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.add((AstNode)this.nf().logUnhandledError(e, w.toString()));
            throw new EngineException(title, "Parsing failed!", e);
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }

    private WtParsedWikitextPage postprocess(PageTitle title, WtParsedWikitextPage pAst, EngLogProcessingPass parentLog) throws EngineException {
        EngLogPostprocessorPass log = this.nf().logPostprocessorPass();
        parentLog.add((AstNode)log);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            WikitextPostprocessor lpp = new WikitextPostprocessor(this.parserConfig);
            WtParsedWikitextPage wtParsedWikitextPage = pAst = (WtParsedWikitextPage)lpp.postprocess((WtNode)pAst, title.getTitle());
            return wtParsedWikitextPage;
        }
        catch (Exception e) {
            logger.error("Postprocessing failed!", (Throwable)e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            log.add((AstNode)this.nf().logUnhandledError(e, w.toString()));
            throw new EngineException(title, "Postprocessing failed!", e);
        }
        finally {
            stopWatch.stop();
            log.setTimeNeeded(stopWatch.getElapsedTime());
        }
    }
}

