/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.sweble.wikitext.engine.config.I18nAlias;

@XmlType(name="alias", propOrder={"id", "caseSensitive", "aliases"})
public class I18nAliasImpl
implements I18nAlias,
Serializable,
Comparable<I18nAlias> {
    private static final long serialVersionUID = 1L;
    private String id;
    private Boolean caseSensitive;
    private Set<String> aliases;

    protected I18nAliasImpl() {
    }

    public I18nAliasImpl(String id, boolean caseSensitive, Collection<String> aliases) {
        this.setId(id);
        this.setCaseSensitive(caseSensitive);
        this.setAliases(aliases);
    }

    @Override
    @XmlAttribute
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (this.id != null) {
            throw new UnsupportedOperationException();
        }
        this.id = id;
    }

    @Override
    @XmlAttribute
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (this.caseSensitive != null) {
            throw new UnsupportedOperationException();
        }
        this.caseSensitive = caseSensitive;
    }

    @Override
    @XmlElement(name="alias")
    public Set<String> getAliases() {
        if (this.aliases == null) {
            this.aliases = new TreeSet<String>();
        }
        return this.aliases;
    }

    public void setAliases(Collection<String> aliases) {
        if (aliases == null) {
            throw new IllegalArgumentException();
        }
        this.aliases = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return I18nAliasImpl.this.caseSensitive != false ? o1.compareTo(o2) : o1.compareToIgnoreCase(o2);
            }
        });
        this.aliases.addAll(aliases);
    }

    @Override
    public boolean hasAlias(String alias) {
        return this.aliases.contains(alias);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aliases == null ? 0 : this.aliases.hashCode());
        result = 31 * result + (this.caseSensitive == null ? 0 : this.caseSensitive.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        I18nAliasImpl other = (I18nAliasImpl)obj;
        if (this.aliases == null ? other.aliases != null : !this.aliases.equals(other.aliases)) {
            return false;
        }
        if (this.caseSensitive == null ? other.caseSensitive != null : !this.caseSensitive.equals(other.caseSensitive)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "I18nAliasImpl [name=" + this.id + ", caseSensitive=" + this.caseSensitive + ", aliases=" + this.aliases + "]";
    }

    @Override
    public int compareTo(I18nAlias o) {
        return this.id.compareTo(o.getId());
    }
}

