/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.config;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.Interwiki;
import org.sweble.wikitext.engine.config.WikiConfigurationException;
import org.sweble.wikitext.engine.utils.UrlService;

@XmlType(name="interwiki", propOrder={"prefix", "local", "trans", "url"})
public class InterwikiImpl
implements Interwiki,
Serializable,
Comparable<Interwiki> {
    private static final long serialVersionUID = 1L;
    private String prefix;
    private String url;
    private boolean local;
    private boolean trans;

    public InterwikiImpl() {
    }

    public InterwikiImpl(String prefix, String url, boolean local, boolean trans) {
        this.prefix = prefix;
        this.url = url;
        this.local = local;
        this.trans = trans;
    }

    @Override
    @XmlAttribute
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @XmlAttribute
    public String getUrl() {
        return this.url;
    }

    @Override
    public URL getUrl(PageTitle title) {
        try {
            return UrlService.makeUrlToArticle(this.url, title);
        }
        catch (MalformedURLException e) {
            throw new WikiConfigurationException(e);
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    @XmlAttribute
    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    @Override
    @XmlAttribute
    public boolean isTrans() {
        return this.trans;
    }

    public void setTrans(boolean trans) {
        this.trans = trans;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.local ? 1231 : 1237);
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.trans ? 1231 : 1237);
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterwikiImpl other = (InterwikiImpl)obj;
        if (this.local != other.local) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        if (this.trans != other.trans) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return "InterwikiImpl [prefix=" + this.prefix + ", url=" + this.url + ", local=" + this.local + ", trans=" + this.trans + "]";
    }

    @Override
    public int compareTo(Interwiki o) {
        return this.prefix.compareTo(o.getPrefix());
    }
}

