/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.sweble.wikitext.engine.config.Namespace;

@XmlType(name="namespace", propOrder={"id", "name", "canonical", "canHaveSubpages", "fileNs", "aliases"})
public class NamespaceImpl
implements Namespace,
Serializable,
Comparable<Namespace> {
    private static final long serialVersionUID = 1L;
    private int id;
    private String name;
    private String canonical;
    private boolean canHaveSubpages;
    private boolean fileNs;
    private TreeSet<String> aliases = new TreeSet();
    private static final int NS_MEDIA = -2;

    protected NamespaceImpl() {
    }

    public NamespaceImpl(int id, String name, String canonical, boolean subpages, boolean isFileNs, Collection<String> aliases) {
        this.id = id;
        this.name = name;
        this.canHaveSubpages = subpages;
        this.canonical = canonical;
        this.fileNs = isFileNs;
        this.aliases.addAll(aliases);
    }

    @Override
    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @XmlAttribute
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    @XmlAttribute
    public boolean isCanHaveSubpages() {
        return this.canHaveSubpages;
    }

    public void setCanHaveSubpages(boolean canHaveSubpages) {
        this.canHaveSubpages = canHaveSubpages;
    }

    @Override
    @XmlAttribute
    public String getCanonical() {
        return this.canonical;
    }

    public void setCanonical(String canonical) {
        this.canonical = canonical;
    }

    @Override
    @XmlAttribute
    public boolean isFileNs() {
        return this.fileNs;
    }

    public void setFileNs(boolean fileNs) {
        this.fileNs = fileNs;
    }

    @Override
    public boolean isMediaNs() {
        return this.id == -2;
    }

    @Override
    @XmlElement(name="alias")
    public TreeSet<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(TreeSet<String> aliases) {
        this.aliases = aliases;
    }

    @Override
    public boolean isTalkNamespace() {
        return this.id > 0 && this.id % 2 == 1;
    }

    @Override
    public boolean isSubjectNamespace() {
        return this.id >= 0 && this.id % 2 == 0;
    }

    @Override
    public int getTalkspaceId() {
        if (this.isTalkNamespace()) {
            return this.id;
        }
        return this.id + 1;
    }

    @Override
    public int getSubjectspaceId() {
        if (this.isSubjectNamespace()) {
            return this.id;
        }
        return this.id - 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceImpl other = (NamespaceImpl)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "NamespaceImpl [id=" + this.id + ", name=" + this.name + ", canonical=" + this.canonical + ", canHaveSubpages=" + this.canHaveSubpages + ", fileNs=" + this.fileNs + ", aliases=" + this.aliases + "]";
    }

    @Override
    public int compareTo(Namespace o) {
        return Integer.valueOf(this.getId()).compareTo(o.getId());
    }
}

