/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.sweble.wikitext.engine.config.I18nAliasImpl;
import org.sweble.wikitext.engine.config.NamespaceImpl;
import org.sweble.wikitext.engine.config.WikiConfigImpl;
import org.sweble.wikitext.engine.nodes.EngineNodeFactory;
import org.sweble.wikitext.parser.NonStandardElementBehavior;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.WikitextWarning;
import org.sweble.wikitext.parser.parser.LinkBuilder;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.parser.LinkTargetParser;
import org.sweble.wikitext.parser.utils.AstTextUtils;

@XmlRootElement(name="ParserConfig", namespace="org.sweble.wikitext.engine")
@XmlType(propOrder={"convertIllegalCodePoints", "warningsEnabled", "minSeverity", "autoCorrect", "gatherRtData", "langConvTagsEnabled", "nonStandardElementBehavior", "fosterParenting", "fosterParentingForTransclusions", "preserveSemiPreLeadingSpace", "internalLinkPrefixPattern", "internalLinkPostfixPattern", "jaxbAllowedUrlProtocols", "jaxbXmlEntities", "jaxbLctFlagMappings", "jaxbLctVariantMappings"})
@XmlAccessorType(value=XmlAccessType.NONE)
public class ParserConfigImpl
implements ParserConfig {
    private static final Pattern URL_PROTOCOL_SYNTAX = Pattern.compile("^\\w+(:|://)$");
    private transient WikiConfigImpl wikiConfig;
    private final Map<String, String> xmlEntities = new HashMap<String, String>();
    @XmlElement
    private boolean convertIllegalCodePoints;
    @XmlElement
    private boolean warningsEnabled;
    @XmlElement
    private WikitextWarning.WarningSeverity minSeverity;
    @XmlElement
    private boolean autoCorrect;
    @XmlElement
    private boolean gatherRtData;
    @XmlElement
    private boolean langConvTagsEnabled = true;
    @XmlElement
    private NonStandardElementBehavior nonStandardElementBehavior = NonStandardElementBehavior.UNSPECIFIED;
    @XmlElement
    private boolean fosterParenting = true;
    @XmlElement
    private boolean fosterParentingForTransclusions = true;
    @XmlElement
    private boolean preserveSemiPreLeadingSpace = false;
    private final Set<String> allowedUrlProtocols = new HashSet<String>();
    @XmlElement
    private String internalLinkPrefixPattern;
    @XmlElement
    private String internalLinkPostfixPattern;
    private final Map<String, String> lctFlagMap = new HashMap<String, String>();
    private final Map<String, String> lctVariantMap = new HashMap<String, String>();

    protected ParserConfigImpl() {
    }

    public ParserConfigImpl(WikiConfigImpl wikiConfig) {
        this();
        this.setWikiConfig(wikiConfig);
    }

    protected void setWikiConfig(WikiConfigImpl wikiConfig) {
        if (wikiConfig == null) {
            throw new IllegalArgumentException();
        }
        this.wikiConfig = wikiConfig;
    }

    public void addXmlEntity(String name, String resolvesTo) {
        String old = this.xmlEntities.get(name);
        if (old != null) {
            throw new IllegalArgumentException("XML entity `" + name + "' already registered.");
        }
        this.xmlEntities.put(name, resolvesTo);
    }

    public Map<String, String> getXmlEntities() {
        return this.xmlEntities;
    }

    public String resolveXmlEntity(String name) {
        return this.xmlEntities.get(name);
    }

    public void setConvertIllegalCodePoints(boolean convertIllegalCodePoints) {
        this.convertIllegalCodePoints = convertIllegalCodePoints;
    }

    public boolean isConvertIllegalCodePoints() {
        return this.convertIllegalCodePoints;
    }

    public void setWarningsEnabled(boolean warningsEnabled) {
        this.warningsEnabled = warningsEnabled;
    }

    public boolean isWarningsEnabled() {
        return this.warningsEnabled;
    }

    public void setMinSeverity(WikitextWarning.WarningSeverity minSeverity) {
        this.minSeverity = minSeverity;
    }

    public WikitextWarning.WarningSeverity getMinSeverity() {
        return this.minSeverity;
    }

    public boolean isWarningLevelEnabled(WikitextWarning.WarningSeverity severity) {
        return severity.getLevel() >= this.minSeverity.getLevel();
    }

    public void setAutoCorrect(boolean autoCorrect) {
        this.autoCorrect = autoCorrect;
    }

    public boolean isAutoCorrect() {
        return this.autoCorrect;
    }

    public void setGatherRtData(boolean gatherRtData) {
        this.gatherRtData = gatherRtData;
    }

    public boolean isGatherRtData() {
        return this.gatherRtData;
    }

    public EngineNodeFactory getNodeFactory() {
        return this.wikiConfig.getNodeFactory();
    }

    public AstTextUtils getAstTextUtils() {
        return this.wikiConfig.getAstTextUtils();
    }

    public void addUrlProtocol(String protocol) {
        if (this.allowedUrlProtocols.contains(protocol)) {
            throw new IllegalArgumentException("URL Protocol `" + protocol + "' already registered.");
        }
        if (!URL_PROTOCOL_SYNTAX.matcher(protocol).matches()) {
            throw new IllegalArgumentException("Invalid URL protocol syntax `" + protocol + "'.");
        }
        this.allowedUrlProtocols.add(protocol);
    }

    public boolean isUrlProtocol(String protocol) {
        return this.allowedUrlProtocols.contains(protocol.toLowerCase());
    }

    public void setInternalLinkPrefixPattern(String pat) {
        if (pat == null) {
            this.internalLinkPrefixPattern = null;
        } else {
            try {
                Pattern.compile("(" + pat + ")$");
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Not a valid internal link prefix pattern: `" + pat + "'.", e);
            }
            this.internalLinkPrefixPattern = pat;
        }
    }

    public String getInternalLinkPrefixPattern() {
        return this.internalLinkPrefixPattern;
    }

    public void setInternalLinkPostfixPattern(String pat) {
        if (pat == null) {
            this.internalLinkPostfixPattern = null;
        } else {
            try {
                Pattern.compile(pat);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Not a valid internal link postfix pattern: `" + pat + "'.", e);
            }
            this.internalLinkPostfixPattern = pat;
        }
    }

    public String getInternalLinkPostfixPattern() {
        return this.internalLinkPostfixPattern;
    }

    public LinkBuilder.LinkType classifyTarget(String target) {
        NamespaceImpl ns;
        LinkTargetParser ltp = new LinkTargetParser();
        try {
            ltp.parse((ParserConfig)this, target);
        }
        catch (LinkTargetException e) {
            return LinkBuilder.LinkType.INVALID;
        }
        String nsStr = ltp.getNamespace();
        if (nsStr != null && (ns = this.wikiConfig.getNamespace(nsStr)) != null && ns.isFileNs() && !ltp.isInitialColon()) {
            return LinkBuilder.LinkType.IMAGE;
        }
        return LinkBuilder.LinkType.PAGE;
    }

    public boolean isNamespace(String nsName) {
        return this.wikiConfig.getNamespace(nsName) != null;
    }

    public boolean isTalkNamespace(String nsName) {
        NamespaceImpl ns = this.wikiConfig.getNamespace(nsName);
        return ns != null && ns.isTalkNamespace();
    }

    public boolean isInterwikiName(String iwName) {
        return this.wikiConfig.getInterwiki(iwName) != null;
    }

    public boolean isIwPrefixOfThisWiki(String iwPrefix) {
        return iwPrefix.equals(this.wikiConfig.getInterwikiPrefix());
    }

    public boolean isValidPageSwitchName(String name) {
        return this.wikiConfig.getPageSwitch(name) != null;
    }

    public boolean isValidExtensionTagName(String name) {
        return this.wikiConfig.getTagExtension(name) != null;
    }

    public boolean isRedirectKeyword(String keyword) {
        I18nAliasImpl alias = this.wikiConfig.getI18nAliasById("redirect");
        if (alias == null) {
            return false;
        }
        return alias.hasAlias(keyword);
    }

    public boolean isValidXmlEntityRef(String name) {
        return this.resolveXmlEntity(name) != null;
    }

    public void setNonStandardElementBehavior(NonStandardElementBehavior nonStandardElementBehavior) {
        this.nonStandardElementBehavior = nonStandardElementBehavior;
    }

    public NonStandardElementBehavior getNonStandardElementBehavior(String elementName) {
        return this.nonStandardElementBehavior;
    }

    public void setFosterParenting(boolean fosterParenting) {
        this.fosterParenting = fosterParenting;
    }

    public boolean isFosterParenting() {
        return this.fosterParenting;
    }

    public void setFosterParentingForTransclusions(boolean fosterParentingForTransclusions) {
        this.fosterParentingForTransclusions = fosterParentingForTransclusions;
    }

    public boolean isFosterParentingForTransclusions() {
        return this.fosterParentingForTransclusions;
    }

    public void setPreserveSemiPreLeadingSpace(boolean preserveSemiPreLeadingSpace) {
        this.preserveSemiPreLeadingSpace = preserveSemiPreLeadingSpace;
    }

    public boolean isPreserveSemiPreLeadingSpace() {
        return this.preserveSemiPreLeadingSpace;
    }

    public void setLangConvTagsEnabled(boolean langConvTagsEnabled) {
        this.langConvTagsEnabled = langConvTagsEnabled;
    }

    public boolean isLangConvTagsEnabled() {
        return this.langConvTagsEnabled;
    }

    public boolean isLctFlag(String flag) {
        return this.lctFlagMap.containsKey(this.normalizeLctFlag(flag));
    }

    public String normalizeLctFlag(String flag) {
        String normalized = this.lctFlagMap.get(flag = flag.trim().toUpperCase());
        if (normalized == null) {
            normalized = flag;
        }
        return normalized;
    }

    public void addLctFlagMapping(String name, String normalized) {
        String old = this.lctFlagMap.get(name);
        if (old != null) {
            throw new IllegalArgumentException("LCT flag mapping `" + name + "' already registered.");
        }
        this.lctFlagMap.put(name, normalized);
    }

    public boolean isLctVariant(String variant) {
        return this.lctVariantMap.containsKey(this.normalizeLctVariant(variant));
    }

    public String normalizeLctVariant(String variant) {
        String normalized = this.lctVariantMap.get(variant = variant.trim().toUpperCase());
        if (normalized == null) {
            normalized = variant;
        }
        return normalized;
    }

    public void addLctVariantMapping(String name, String normalized) {
        String old = this.lctVariantMap.get(name);
        if (old != null) {
            throw new IllegalArgumentException("LCT variant mapping `" + name + "' already registered.");
        }
        this.lctVariantMap.put(name, normalized);
    }

    @XmlElement(name="entity")
    @XmlElementWrapper(name="xmlEntities")
    private XmlEntityMapEntry[] getJaxbXmlEntities() {
        Object[] array = new XmlEntityMapEntry[this.xmlEntities.size()];
        int i = 0;
        for (Map.Entry<String, String> e : this.xmlEntities.entrySet()) {
            array[i++] = new XmlEntityMapEntry(e.getKey(), e.getValue());
        }
        Arrays.sort(array);
        return array;
    }

    private void setJaxbXmlEntities(XmlEntityMapEntry[] xmlEntities) {
        for (XmlEntityMapEntry e : xmlEntities) {
            this.addXmlEntity(e.name, e.value);
        }
    }

    @XmlElement(name="protocol")
    @XmlElementWrapper(name="allowedUrlProtocols")
    private UrlProtocolEntry[] getJaxbAllowedUrlProtocols() {
        UrlProtocolEntry[] array = new UrlProtocolEntry[this.allowedUrlProtocols.size()];
        int i = 0;
        for (String protocol : this.allowedUrlProtocols) {
            array[i++] = new UrlProtocolEntry(protocol);
        }
        return array;
    }

    private void setJaxbAllowedUrlProtocols(UrlProtocolEntry[] protocols) {
        for (UrlProtocolEntry protocol : protocols) {
            this.addUrlProtocol(protocol.name);
        }
    }

    @XmlElement(name="lctFlag")
    @XmlElementWrapper(name="lctFlagMappings")
    private LctFlagMapEntry[] getJaxbLctFlagMappings() {
        Object[] array = new LctFlagMapEntry[this.lctFlagMap.size()];
        int i = 0;
        for (Map.Entry<String, String> e : this.lctFlagMap.entrySet()) {
            array[i++] = new LctFlagMapEntry(e.getKey(), e.getValue());
        }
        Arrays.sort(array);
        return array;
    }

    private void setJaxbLctFlagMappings(LctFlagMapEntry[] lctFlagMap) {
        for (LctFlagMapEntry e : lctFlagMap) {
            this.addLctFlagMapping(e.name, e.normalized);
        }
    }

    @XmlElement(name="lctVariant")
    @XmlElementWrapper(name="lctVariantMappings")
    private LctVariantMapEntry[] getJaxbLctVariantMappings() {
        Object[] array = new LctVariantMapEntry[this.lctVariantMap.size()];
        int i = 0;
        for (Map.Entry<String, String> e : this.lctVariantMap.entrySet()) {
            array[i++] = new LctVariantMapEntry(e.getKey(), e.getValue());
        }
        Arrays.sort(array);
        return array;
    }

    private void setJaxbLctVariantMappings(LctVariantMapEntry[] lctVariantMap) {
        for (LctVariantMapEntry e : lctVariantMap) {
            this.addLctVariantMapping(e.name, e.normalized);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowedUrlProtocols == null ? 0 : this.allowedUrlProtocols.hashCode());
        result = 31 * result + (this.autoCorrect ? 1231 : 1237);
        result = 31 * result + (this.fosterParenting ? 1231 : 1237);
        result = 31 * result + (this.fosterParentingForTransclusions ? 1231 : 1237);
        result = 31 * result + (this.gatherRtData ? 1231 : 1237);
        result = 31 * result + (this.internalLinkPostfixPattern == null ? 0 : this.internalLinkPostfixPattern.hashCode());
        result = 31 * result + (this.internalLinkPrefixPattern == null ? 0 : this.internalLinkPrefixPattern.hashCode());
        result = 31 * result + (this.langConvTagsEnabled ? 1231 : 1237);
        result = 31 * result + (this.lctFlagMap == null ? 0 : this.lctFlagMap.hashCode());
        result = 31 * result + (this.lctVariantMap == null ? 0 : this.lctVariantMap.hashCode());
        result = 31 * result + (this.minSeverity == null ? 0 : this.minSeverity.hashCode());
        result = 31 * result + (this.nonStandardElementBehavior == null ? 0 : this.nonStandardElementBehavior.hashCode());
        result = 31 * result + (this.warningsEnabled ? 1231 : 1237);
        result = 31 * result + (this.xmlEntities == null ? 0 : this.xmlEntities.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParserConfigImpl other = (ParserConfigImpl)obj;
        if (this.allowedUrlProtocols == null ? other.allowedUrlProtocols != null : !this.allowedUrlProtocols.equals(other.allowedUrlProtocols)) {
            return false;
        }
        if (this.autoCorrect != other.autoCorrect) {
            return false;
        }
        if (this.fosterParenting != other.fosterParenting) {
            return false;
        }
        if (this.fosterParentingForTransclusions != other.fosterParentingForTransclusions) {
            return false;
        }
        if (this.gatherRtData != other.gatherRtData) {
            return false;
        }
        if (this.internalLinkPostfixPattern == null ? other.internalLinkPostfixPattern != null : !this.internalLinkPostfixPattern.equals(other.internalLinkPostfixPattern)) {
            return false;
        }
        if (this.internalLinkPrefixPattern == null ? other.internalLinkPrefixPattern != null : !this.internalLinkPrefixPattern.equals(other.internalLinkPrefixPattern)) {
            return false;
        }
        if (this.langConvTagsEnabled != other.langConvTagsEnabled) {
            return false;
        }
        if (this.lctFlagMap == null ? other.lctFlagMap != null : !this.lctFlagMap.equals(other.lctFlagMap)) {
            return false;
        }
        if (this.lctVariantMap == null ? other.lctVariantMap != null : !this.lctVariantMap.equals(other.lctVariantMap)) {
            return false;
        }
        if (this.minSeverity != other.minSeverity) {
            return false;
        }
        if (this.nonStandardElementBehavior != other.nonStandardElementBehavior) {
            return false;
        }
        if (this.warningsEnabled != other.warningsEnabled) {
            return false;
        }
        return !(this.xmlEntities == null ? other.xmlEntities != null : !this.xmlEntities.equals(other.xmlEntities));
    }

    private static final class LctVariantMapEntry
    implements Comparable<LctVariantMapEntry> {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String normalized;

        private LctVariantMapEntry() {
        }

        private LctVariantMapEntry(String name, String normalized) {
            this.name = name;
            this.normalized = normalized;
        }

        @Override
        public int compareTo(LctVariantMapEntry o) {
            return this.name.compareTo(o.name);
        }
    }

    private static final class LctFlagMapEntry
    implements Comparable<LctFlagMapEntry> {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String normalized;

        private LctFlagMapEntry() {
        }

        private LctFlagMapEntry(String name, String normalized) {
            this.name = name;
            this.normalized = normalized;
        }

        @Override
        public int compareTo(LctFlagMapEntry o) {
            return this.name.compareTo(o.name);
        }
    }

    private static final class UrlProtocolEntry {
        @XmlAttribute
        private String name;

        public UrlProtocolEntry() {
        }

        public UrlProtocolEntry(String name) {
            this.name = name;
        }
    }

    private static final class XmlEntityMapEntry
    implements Comparable<XmlEntityMapEntry> {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String value;

        private XmlEntityMapEntry() {
        }

        private XmlEntityMapEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public int compareTo(XmlEntityMapEntry o) {
            return this.name.compareTo(o.name);
        }
    }
}

