/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.sweble.wikitext.engine.TagExtensionBase;

@XmlType(name="tagExtGroup")
public class TagExtensionGroup
implements Serializable,
Comparable<TagExtensionGroup> {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private String name;
    private final transient HashSet<String> tagExtIds = new HashSet();
    private final HashSet<TagExtensionBase> tagExtensions = new HashSet();

    public TagExtensionGroup() {
    }

    public TagExtensionGroup(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection<TagExtensionBase> getTagExtensions() {
        return Collections.unmodifiableCollection(this.tagExtensions);
    }

    public void addTagExtension(TagExtensionBase tagExt) {
        if (this.tagExtIds.contains(tagExt.getId())) {
            throw new IllegalArgumentException("Tag extensions group already contains tag extensions with ID: " + tagExt.getId());
        }
        this.tagExtIds.add(tagExt.getId());
        this.tagExtensions.add(tagExt);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tagExtensions == null ? 0 : this.tagExtensions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagExtensionGroup)) {
            return false;
        }
        TagExtensionGroup other = (TagExtensionGroup)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tagExtensions == null ? other.tagExtensions != null : !this.tagExtensions.equals(other.tagExtensions));
    }

    public String toString() {
        return "TagExtensionGroup [name=" + this.name + ", tagExtensions=" + this.tagExtensions + "]";
    }

    @Override
    public int compareTo(TagExtensionGroup o) {
        return this.name.compareTo(o.getName());
    }

    @XmlElement(name="tagExt")
    private ArrayList<TagExtensionBase> getJaxbTagExtensions() {
        ArrayList<TagExtensionBase> sorted = new ArrayList<TagExtensionBase>(this.tagExtensions);
        Collections.sort(sorted);
        return sorted;
    }

    private void setJaxbTagExtensions(ArrayList<TagExtensionBase> tagExts) {
        for (TagExtensionBase tagExt : tagExts) {
            this.addTagExtension(tagExt);
        }
    }
}

