/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.builtin;

import java.util.Map;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.TagExtensionBase;
import org.sweble.wikitext.engine.config.TagExtensionGroup;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.nodes.EngineRtData;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtTagExtension;
import org.sweble.wikitext.parser.nodes.WtTagExtensionBody;
import org.sweble.wikitext.parser.nodes.WtXmlElement;

public class BuiltInTagExtensions
extends TagExtensionGroup {
    private static final long serialVersionUID = 1L;

    protected BuiltInTagExtensions(WikiConfig wikiConfig) {
        super("Built-in Tag Extensions");
        this.addTagExtension(new TagExtensionPre(wikiConfig));
        this.addTagExtension(new TagExtensionNowiki(wikiConfig));
    }

    public static BuiltInTagExtensions group(WikiConfig wikiConfig) {
        return new BuiltInTagExtensions(wikiConfig);
    }

    public static final class TagExtensionNowiki
    extends TagExtensionBase {
        private static final long serialVersionUID = 1L;

        public TagExtensionNowiki() {
            super("nowiki");
        }

        public TagExtensionNowiki(WikiConfig wikiConfig) {
            super(wikiConfig, "nowiki");
        }

        @Override
        public WtNode invoke(ExpansionFrame frame, WtTagExtension tagExt, Map<String, WtNodeList> attrs, WtTagExtensionBody body) {
            return EngineRtData.set(this.nf().nowiki(body.getContent()));
        }
    }

    public static final class TagExtensionPre
    extends TagExtensionBase {
        private static final long serialVersionUID = 1L;

        public TagExtensionPre() {
            super("pre");
        }

        public TagExtensionPre(WikiConfig wikiConfig) {
            super(wikiConfig, "pre");
        }

        @Override
        public WtNode invoke(ExpansionFrame frame, WtTagExtension tagExt, Map<String, WtNodeList> attrs, WtTagExtensionBody body) {
            WtXmlElement pre = this.nf().elem("pre", tagExt.getXmlAttributes(), this.nf().body(this.nf().list((WtNode)this.nf().text(body.getContent()))));
            pre.setRtd(tagExt.getRtd());
            return pre;
        }
    }
}

