/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.convert;

import de.fau.cs.osr.utils.StringTools;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.ParserFunctionBase;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.convert.DefCvt;
import org.sweble.wikitext.engine.ext.convert.NumberFormater;
import org.sweble.wikitext.engine.ext.convert.Units;
import org.sweble.wikitext.engine.nodes.EngSoftErrorNode;
import org.sweble.wikitext.engine.nodes.EngineRtData;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class Convert
extends ParserFunctionBase {
    private static int MIN_ARGS = 2;
    private static int DEFAULT_SIG_FIG = 2;
    private int sigFig = DEFAULT_SIG_FIG;
    private AbbreviationMode abbrMode = AbbreviationMode.OUT;
    private boolean isUsNameUsed = false;

    public Convert() {
        super("convert");
    }

    public Convert(WikiConfig wikiConfig) {
        super(wikiConfig, "convert");
    }

    @Override
    public WtNode invoke(WtNode pnf, ExpansionFrame frame, List<? extends WtNode> args) {
        double value;
        ArrayList<String> strArgs;
        this.sigFig = DEFAULT_SIG_FIG;
        this.isUsNameUsed = false;
        this.abbrMode = AbbreviationMode.OUT;
        try {
            strArgs = this.parseArguments(frame, args);
            value = NumberFormater.parseNumber(strArgs.get(0));
        }
        catch (Exception ex) {
            return this.error(ex.getMessage());
        }
        Units srcUnit = Units.searchUnitFromName(strArgs.get(1));
        if (srcUnit == null) {
            return this.error("Cannot convert source unit argument!");
        }
        String srcValueStr = strArgs.get(0).replaceAll("-", "\u2212");
        if (strArgs.size() == MIN_ARGS) {
            String dest = Convert.convertToDefaultUnit(value, srcUnit, this.abbrMode, this.sigFig, this.isUsNameUsed);
            String srcUnitName = Convert.getSourceUnitName(srcUnit, this.abbrMode, Math.abs(value) != 1.0, this.isUsNameUsed);
            if (srcUnitName == null) {
                return this.error("Cannot determinate output format!");
            }
            String result = srcValueStr + " " + srcUnitName + "(" + dest + ")";
            return this.nf().text(result);
        }
        Units destUnit = Units.searchUnitFromName(strArgs.get(2));
        if (destUnit == null) {
            return this.error("Cannot convert destination unit argument!");
        }
        if (!Units.isSameUnitType(srcUnit, destUnit)) {
            return this.error("Cannot convert units with different types!");
        }
        double convertedValue = srcUnit.getScale() * value / destUnit.getScale();
        String srcUnitName = Convert.getSourceUnitName(srcUnit, this.abbrMode, Math.abs(value) != 1.0, this.isUsNameUsed);
        if (srcUnitName == null) {
            return this.error("Cannot determinate output format!");
        }
        String destUnitName = Convert.getDestUnitName(destUnit, this.abbrMode, Math.abs(convertedValue) != 1.0, this.isUsNameUsed);
        String result = srcValueStr + " " + srcUnitName + "(" + NumberFormater.formatNumberDefault(convertedValue, this.sigFig) + destUnitName + ")";
        return this.nf().text(result);
    }

    private String expandArgToString(ExpansionFrame preprocessorFrame, List<? extends WtNode> args, int index) {
        WtNode arg = preprocessorFrame.expand(args.get(index));
        this.tu().trim(arg);
        String format = null;
        try {
            format = this.tu().astToText(arg).trim();
        }
        catch (StringConversionException stringConversionException) {
            // empty catch block
        }
        return format;
    }

    private EngSoftErrorNode error(String msg) {
        return EngineRtData.set(this.nf().softError(EngineRtData.set(this.nf().nowiki(StringTools.escHtml((String)msg)))));
    }

    private ArrayList<String> parseArguments(ExpansionFrame frame, List<? extends WtNode> args) throws IllegalArgumentException {
        if (args.size() < MIN_ARGS) {
            throw new IllegalArgumentException("Too few arguments!");
        }
        ArrayList<String> strArgs = new ArrayList<String>(args.size());
        for (int i = 0; i < args.size(); ++i) {
            String tmpStr = this.expandArgToString(frame, args, i);
            if (tmpStr == null) {
                throw new IllegalArgumentException("Cannot convert argument to string!");
            }
            strArgs.add(tmpStr);
        }
        if (!NumberFormater.isNumberValid((String)strArgs.get(0))) {
            throw new IllegalArgumentException("The first argument is not a vaild number!");
        }
        ArrayList<String> cleanArgs = new ArrayList<String>(strArgs.size());
        cleanArgs.add((String)strArgs.get(0));
        for (int i = 1; i < strArgs.size(); ++i) {
            String arg = (String)strArgs.get(i);
            if (arg.contains("=")) {
                String[] spl = arg.split("=");
                String opt = StringUtils.trim((String)spl[0]);
                String param = StringUtils.trim((String)spl[1]);
                if (opt.equals("abbr")) {
                    if (param.equals("in")) {
                        this.abbrMode = AbbreviationMode.IN;
                        continue;
                    }
                    if (param.equals("off") || param.equals("none")) {
                        this.abbrMode = AbbreviationMode.OFF;
                        continue;
                    }
                    if (param.equals("on")) {
                        this.abbrMode = AbbreviationMode.ON;
                        continue;
                    }
                    if (param.equals("out")) {
                        this.abbrMode = AbbreviationMode.OUT;
                        continue;
                    }
                    if (param.equals("unit")) {
                        this.abbrMode = AbbreviationMode.UNIT;
                        continue;
                    }
                    if (param.equals("values")) {
                        this.abbrMode = AbbreviationMode.VALUES;
                        continue;
                    }
                    if (param.equals("~")) {
                        this.abbrMode = AbbreviationMode.TILDE;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid abbreviation parameter!");
                }
                if (opt.equals("sigfig")) {
                    this.sigFig = Integer.parseInt(param);
                    if (this.sigFig > 0) continue;
                    throw new IllegalArgumentException("\"sigfig=\" needs a positive integer!");
                }
                if (opt.equals("sp")) {
                    this.isUsNameUsed = param.equals("us");
                    continue;
                }
                throw new IllegalArgumentException("Unknow argument!");
            }
            cleanArgs.add(arg);
        }
        return cleanArgs;
    }

    protected static String convertToDefaultUnit(double value, Units srcUnit, AbbreviationMode abbreviationMode, int sigFig, boolean isUsNameUsed) {
        assert (srcUnit != null);
        double siBasedValue = srcUnit.getScale() * (value - srcUnit.getOffset());
        DefCvt defCvt = srcUnit.getDefaultCvt();
        String[] cvtUnits = defCvt.getUnits();
        Units destUnitA = Units.searchUnitFromName(cvtUnits[0]);
        if (destUnitA == null) {
            return null;
        }
        if (cvtUnits.length <= 1) {
            return Convert.convertBaseTo(siBasedValue, destUnitA, abbreviationMode, sigFig, isUsNameUsed);
        }
        if (defCvt.isMixedNotation()) {
            String minorUnitName;
            String majorUnitName;
            int limit = defCvt.getMixedNotationLimit();
            if (value >= (double)limit) {
                return Convert.convertBaseTo(siBasedValue, destUnitA, abbreviationMode, sigFig, isUsNameUsed);
            }
            Units majorUnit = destUnitA;
            Units minorUnit = Units.searchUnitFromName(cvtUnits[1]);
            if (minorUnit == null) {
                return null;
            }
            double convertedVal = srcUnit.getScale() * value / minorUnit.getScale();
            double transitScale = majorUnit.getScale() / minorUnit.getScale();
            double convertedMinorVal = convertedVal % transitScale;
            double convertedMajorVal = (convertedVal - convertedMinorVal) / transitScale;
            switch (abbreviationMode) {
                case OUT: 
                case ON: 
                case UNIT: 
                case VALUES: 
                case TILDE: {
                    majorUnitName = majorUnit.getSymbol();
                    minorUnitName = minorUnit.getSymbol();
                    break;
                }
                case IN: 
                case NONE: 
                case OFF: {
                    if (value == 1.0) {
                        majorUnitName = majorUnit.getName();
                        minorUnitName = minorUnit.getName();
                        break;
                    }
                    majorUnitName = majorUnit.getPluralName();
                    minorUnitName = minorUnit.getPluralName();
                    break;
                }
                default: {
                    return null;
                }
            }
            return NumberFormater.formatRegular(convertedMajorVal) + " " + majorUnitName + " " + NumberFormater.formatRegular(convertedMinorVal) + " " + minorUnitName;
        }
        Units destUnitB = Units.searchUnitFromName(cvtUnits[1]);
        if (destUnitB == null) {
            return null;
        }
        return Convert.convertBaseTo(siBasedValue, destUnitA, abbreviationMode, sigFig, isUsNameUsed) + "; " + Convert.convertBaseTo(siBasedValue, destUnitB, abbreviationMode, sigFig, isUsNameUsed);
    }

    protected static String convertBaseTo(double siBaseValue, Units destUnit, AbbreviationMode abbreviationMode, int sigFig, boolean isUsNameUsed) {
        assert (destUnit != null);
        double convertedValue = siBaseValue / destUnit.getScale() + destUnit.getOffset();
        String destNameStr = Convert.getDestUnitName(destUnit, abbreviationMode, Math.abs(convertedValue) != 1.0, isUsNameUsed);
        if (destNameStr == null) {
            return null;
        }
        return NumberFormater.formatNumberDefault(convertedValue, sigFig) + destNameStr;
    }

    private static String getSourceUnitName(Units srcUnit, AbbreviationMode abbrMode, boolean isPlural, boolean isUsNameUsed) {
        String srcUnitName;
        switch (abbrMode) {
            case ON: 
            case UNIT: 
            case IN: {
                if (isUsNameUsed) {
                    srcUnitName = srcUnit.getUsName() + " ";
                    break;
                }
                srcUnitName = srcUnit.getSymbol() + " ";
                break;
            }
            case OUT: 
            case NONE: 
            case OFF: {
                if (isUsNameUsed) {
                    if (isPlural) {
                        srcUnitName = srcUnit.getUsName() + "s ";
                        break;
                    }
                    srcUnitName = srcUnit.getUsName() + " ";
                    break;
                }
                if (isPlural) {
                    srcUnitName = srcUnit.getPluralName() + " ";
                    break;
                }
                srcUnitName = srcUnit.getName() + " ";
                break;
            }
            case VALUES: {
                srcUnitName = "";
                break;
            }
            case TILDE: {
                srcUnitName = isPlural ? srcUnit.getPluralName() : srcUnit.getName();
                srcUnitName = srcUnitName + " [" + srcUnit.getSymbol() + "] ";
                break;
            }
            default: {
                return null;
            }
        }
        return srcUnitName;
    }

    private static String getDestUnitName(Units destUnit, AbbreviationMode abbrMode, boolean isPlural, boolean isUsNameUsed) {
        String destUnitName;
        switch (abbrMode) {
            case OUT: 
            case ON: 
            case UNIT: 
            case TILDE: {
                destUnitName = " " + destUnit.getSymbol();
                break;
            }
            case VALUES: {
                destUnitName = "";
                break;
            }
            case IN: 
            case NONE: 
            case OFF: {
                if (isUsNameUsed) {
                    if (isPlural) {
                        destUnitName = " " + destUnit.getUsName() + "s";
                        break;
                    }
                    destUnitName = " " + destUnit.getUsName();
                    break;
                }
                if (isPlural) {
                    destUnitName = " " + destUnit.getPluralName();
                    break;
                }
                destUnitName = " " + destUnit.getName();
                break;
            }
            default: {
                return null;
            }
        }
        return destUnitName;
    }

    static enum AbbreviationMode {
        OUT,
        ON,
        UNIT,
        IN,
        NONE,
        OFF,
        VALUES,
        TILDE;

    }
}

