/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.convert;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NumberFormater {
    private static final DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.US);
    private static final DecimalFormat sciFmt = new DecimalFormat("0.0E0;\u2212#", symbols);
    private static final DecimalFormat fmt = new DecimalFormat("#0;\u2212#", symbols);

    private NumberFormater() {
        throw new UnsupportedOperationException();
    }

    public static String formatScientific(double number) {
        String[] split = sciFmt.format(number).split("E");
        String supExp = NumberFormater.asSuperscriptNumber(split[1]);
        return split[0] + "\u00d710" + supExp;
    }

    public static String formatRegular(double number) {
        return fmt.format(number);
    }

    public static String formatRegular(BigDecimal number) {
        return fmt.format(number);
    }

    public static String formatNumberRounded(double convertedValue, int digitsAfterFloatingPoint) {
        int MAX_DIGITS_AFTER_FLOATING_POINT = 16;
        if (digitsAfterFloatingPoint > 16) {
            digitsAfterFloatingPoint = 16;
        }
        DecimalFormat tmpFmt = (DecimalFormat)fmt.clone();
        tmpFmt.setMinimumFractionDigits(digitsAfterFloatingPoint);
        tmpFmt.setMaximumFractionDigits(digitsAfterFloatingPoint);
        return tmpFmt.format(convertedValue);
    }

    protected static String formatNumberDefault(double convertedValue, int sigFig) {
        String convertedValStr;
        double absValue = Math.abs(convertedValue);
        if (absValue < 1.0E-9 || absValue > 1.0E9) {
            convertedValStr = NumberFormater.formatScientific(convertedValue);
        } else {
            BigDecimal bd = new BigDecimal(convertedValue);
            int prec = bd.precision() - bd.scale();
            if (sigFig > prec) {
                convertedValStr = NumberFormater.formatNumberRounded(convertedValue, sigFig - prec);
            } else {
                bd = bd.round(new MathContext(sigFig, RoundingMode.HALF_UP));
                convertedValStr = NumberFormater.formatRegular(bd);
            }
        }
        return convertedValStr;
    }

    protected static boolean isNumberValid(String numberStr) {
        return numberStr.matches("[0-9,.e/\u2044\\-\\+\u2013]+");
    }

    protected static double parseNumber(String numberStr) throws NumberFormatException {
        String number = numberStr.replace(",", "");
        number = number.replaceAll("\u2013", "-");
        Matcher fractionMatcher = Pattern.compile("[/\u2044]").matcher(number);
        if (fractionMatcher.find()) {
            int idxMinus;
            String[] fraction = number.split("//|[/\u2044]");
            if (fraction.length != 2) {
                throw new NumberFormatException("Invalid fraction!");
            }
            String numerator = fraction[0];
            String denominator = fraction[1];
            int idxPlus = numerator.lastIndexOf(43);
            if (idxPlus > (idxMinus = numerator.lastIndexOf(45)) && idxMinus != -1) {
                throw new NumberFormatException("Should be a number, not a expression which requires calculations!");
            }
            double wholeNum = 0.0;
            int idx = Math.max(idxPlus, idxMinus);
            if (idx != -1) {
                String wholeNumStr = numerator.substring(0, idx);
                numerator = numerator.substring(idx);
                wholeNum = Double.parseDouble(wholeNumStr);
            }
            double value = wholeNum + Double.parseDouble(numerator) / Double.parseDouble(denominator);
            return value;
        }
        double value = Double.parseDouble(number);
        return value;
    }

    public static String asSuperscriptNumber(String numStr) {
        numStr = numStr.replaceAll("0", "\u2070");
        numStr = numStr.replaceAll("1", "\u00b9");
        numStr = numStr.replaceAll("2", "\u00b2");
        numStr = numStr.replaceAll("3", "\u00b3");
        numStr = numStr.replaceAll("4", "\u2074");
        numStr = numStr.replaceAll("5", "\u2075");
        numStr = numStr.replaceAll("6", "\u2076");
        numStr = numStr.replaceAll("7", "\u2077");
        numStr = numStr.replaceAll("8", "\u2078");
        numStr = numStr.replaceAll("9", "\u2079");
        numStr = numStr.replaceAll("-", "\u207b");
        return numStr;
    }

    public static String asSubscriptNumber(String numStr) {
        numStr = numStr.replaceAll("0", "\u2080");
        numStr = numStr.replaceAll("1", "\u2081");
        numStr = numStr.replaceAll("2", "\u2082");
        numStr = numStr.replaceAll("3", "\u2083");
        numStr = numStr.replaceAll("4", "\u2084");
        numStr = numStr.replaceAll("5", "\u2085");
        numStr = numStr.replaceAll("6", "\u2086");
        numStr = numStr.replaceAll("7", "\u2087");
        numStr = numStr.replaceAll("8", "\u2088");
        numStr = numStr.replaceAll("9", "\u2089");
        numStr = numStr.replaceAll("-", "\u208b");
        return numStr;
    }

    static {
        fmt.setRoundingMode(RoundingMode.HALF_UP);
        fmt.setGroupingSize(3);
        fmt.setGroupingUsed(true);
    }
}

