/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.convert;

import java.util.HashMap;
import org.sweble.wikitext.engine.ext.convert.DefCvt;

public final class Units
extends Enum<Units> {
    public static final /* enum */ Units GRAY = new Units(UnitType.ABSORBED_RADIATION_DOSE, 1.0, "Gy", "gray", DefCvt.RAD, new String[]{"Gy"});
    public static final /* enum */ Units RAD = new Units(UnitType.ABSORBED_RADIATION_DOSE, 0.01, "rad", "rad", DefCvt.GY);
    public static final /* enum */ Units CENTIMETRE_PER_SEC_SQ = new Units(UnitType.ACCELERATION, 0.01, "cm/s\u00b2", "centimetre per second squared", DefCvt.FT_PER_S2, new String[]{"cm/s2"}, "centimetres per second squared", "centimeters per second squared");
    public static final /* enum */ Units FOOT_PER_SEC_SQ = new Units(UnitType.ACCELERATION, 0.3048, "ft/s\u00b2", "foot per second squared", DefCvt.M_PER_S2, new String[]{"ft/s2"}, "feet per second squared", null);
    public static final /* enum */ Units STANDARD_GRAVITY = new Units(UnitType.ACCELERATION, 9.80665, "g\u2080", "standard gravity", DefCvt.M_PER_S2, new String[]{"g0"}, "standard gravities", null);
    public static final /* enum */ Units KILOMETRE_PER_H_PER_SEC = new Units(UnitType.ACCELERATION, 0.2777777777777778, "km/(h\u22c5s)", "kilometre per hour per second", DefCvt.MPH_PER_S, new String[]{"km/hs, km/h/s"}, "kilometres per hour per second", "kilometers per hour per second");
    public static final /* enum */ Units KILOMETRE_PER_SEC_SQ = new Units(UnitType.ACCELERATION, 1000.0, "km/s\u00b2", "kilometre per second squared", DefCvt.MPH_PER_S, new String[]{"km/s2"}, "kilometres per second squared", "kilometers per second squared");
    public static final /* enum */ Units METRE_PER_SEC_SQ = new Units(UnitType.ACCELERATION, 1.0, "m/s\u00b2", "metre per second squared", DefCvt.FT_PER_S2, new String[]{"m/s2"}, "metres per second squared", "meters per second squared");
    public static final /* enum */ Units MILE_PER_H_PER_SEC = new Units(UnitType.ACCELERATION, 0.44704, "mph/s", "mile per hour per second", DefCvt.KM_PER_HS, new String[]{"mph/s"}, "miles per hour per second", null);
    public static final /* enum */ Units SQUARE_KILOMETRE = new Units(UnitType.AREA, 1000000.0, "km\u00b2", "square kilometre", DefCvt.SQMI, new String[]{"km2", "km\u00b2", "sqkm"}, null, "square kilometer");
    public static final /* enum */ Units SQUARE_HECTOMETRE = new Units(UnitType.AREA, 10000.0, "hm\u00b2", "square hectometre", DefCvt.ACRE, new String[]{"hm2", "hm\u00b2"}, null, "square hectometer");
    public static final /* enum */ Units SQUARE_DECAMETRE = new Units(UnitType.AREA, 100.0, "dam\u00b2", "square decametre", DefCvt.SQFT, new String[]{"dam2", "dam\u00b2"}, null, "square dekameter");
    public static final /* enum */ Units SQUARE_METRE = new Units(UnitType.AREA, 1.0, "m\u00b2", "square metre", DefCvt.SQFT, new String[]{"m2", "m\u00b2", "sqm"}, null, "square meter");
    public static final /* enum */ Units SQUARE_DECIMETRE = new Units(UnitType.AREA, 0.01, "dm\u00b2", "square decimetre", DefCvt.SQIN, new String[]{"dm2", "dm\u00b2"}, null, "square decimeter");
    public static final /* enum */ Units SQUARE_CENTIMETRE = new Units(UnitType.AREA, 1.0E-4, "cm\u00b2", "square centimetre", DefCvt.SQIN, new String[]{"cm2", "cm\u00b2"}, null, "square centimeter");
    public static final /* enum */ Units SQUARE_MILLIMETRE = new Units(UnitType.AREA, 1.0E-6, "mm\u00b2", "square millimetre", DefCvt.SQIN, new String[]{"mm2", "mm\u00b2"}, null, "square millimeter");
    public static final /* enum */ Units THOUSAND_SQFT = new Units(UnitType.AREA, 92.90304, "1000\u00a0sq\u00a0ft", "thousand square feet", DefCvt.M2, null, "thousand square feet", null);
    public static final /* enum */ Units ARE = new Units(UnitType.AREA, 100.0, "a", "are", DefCvt.SQFT, new String[]{"a"});
    public static final /* enum */ Units ACRE = new Units(UnitType.AREA, 4046.8564224, "acres", "acre", DefCvt.HA, new String[]{"acre-sing", "acres"});
    public static final /* enum */ Units ARPENT = new Units(UnitType.AREA, 3418.89, "arpent", "arpent", DefCvt.HA, new String[]{"sq arp"});
    public static final /* enum */ Units CUERDA = new Units(UnitType.AREA, 3930.395625, "cda", "cuerda", DefCvt.HA_ACRE);
    public static final /* enum */ Units DAA = new Units(UnitType.AREA, 1000.0, "daa", "decare", DefCvt.KM2_SQMI, new String[]{"daa"});
    public static final /* enum */ Units DUNAM = new Units(UnitType.AREA, 1000.0, "dunam", "dunam", DefCvt.KM2_SQMI);
    public static final /* enum */ Units DUNUM = new Units(UnitType.AREA, 1000.0, "dunum", "dunum", DefCvt.KM2_SQMI);
    public static final /* enum */ Units HECTARE = new Units(UnitType.AREA, 10000.0, "ha", "hectare", DefCvt.ACRE);
    public static final /* enum */ Units IRISH_ACRE = new Units(UnitType.AREA, 6555.2385024, "Irish\u00a0acres", "Irish acre", DefCvt.HA);
    public static final /* enum */ Units PONDEMAAT = new Units(UnitType.AREA, 3674.363358816, "pond", "pondemaat", DefCvt.M2, new String[]{"pond"});
    public static final /* enum */ Units PYEONG = new Units(UnitType.AREA, 3.3057851239669422, "pyeong", "pyeong", DefCvt.M2);
    public static final /* enum */ Units RAI = new Units(UnitType.AREA, 1600.0, "rai", "rai", DefCvt.M2);
    public static final /* enum */ Units ROOD = new Units(UnitType.AREA, 1011.7141056, "rood", "rood", DefCvt.SQFT_M2);
    public static final /* enum */ Units SQUARE_FOOT = new Units(UnitType.AREA, 0.09290304, "sq\u00a0ft", "square foot", DefCvt.M2, new String[]{"sqft", "ft2"}, "square feet", null);
    public static final /* enum */ Units SQUARE_FOOT2 = new Units(UnitType.AREA, 0.09290304, "sq\u00a0ft", "square foot", DefCvt.M2, new String[]{"sqfoot", "foot2"}, "square foot", null);
    public static final /* enum */ Units SQUARE_INCH = new Units(UnitType.AREA, 6.4516E-4, "sq\u00a0in", "square inch", DefCvt.CM2, new String[]{"sqin", "in2"}, "square inches", null);
    public static final /* enum */ Units SQUARE_NAUTICAL_MILE = new Units(UnitType.AREA, 3429904.0, "sq\u00a0nmi", "square nautical mile", DefCvt.KM2_SQMI, new String[]{"nmi2"});
    public static final /* enum */ Units SQUARE_MILE = new Units(UnitType.AREA, 2589988.110336, "sq\u00a0mi", "square mile", DefCvt.KM2, new String[]{"sqmi", "mi2"});
    public static final /* enum */ Units SQUARE_PERCH = new Units(UnitType.AREA, 25.29285264, "perch", "perches", DefCvt.M2);
    public static final /* enum */ Units SQUARE_VERST = new Units(UnitType.AREA, 1138062.24, "square verst", "square verst", DefCvt.KM2_SQMI, new String[]{"sqverst", "verst2"});
    public static final /* enum */ Units SQUARE_YARD = new Units(UnitType.AREA, 0.83612736, "sq\u00a0yd", "square yard", DefCvt.M2, new String[]{"sqyd", "yd2"});
    public static final /* enum */ Units TSUBO = new Units(UnitType.AREA, 3.3057851239669422, "tsubo", "tsubo", DefCvt.M2, null, "tsubo", null);
    public static final /* enum */ Units M2_PER_HA = new Units(UnitType.AREA_PER_UNIT_AREA, 1.0E-4, "m\u00b2/ha", "square metre per hectare", DefCvt.SQFT_PER_ACRE, new String[]{"m2/ha"}, "square metres per hectare", "square meters per hectare");
    public static final /* enum */ Units SQFT_PER_ACRE = new Units(UnitType.AREA_PER_UNIT_AREA, 2.295684113865932E-5, "sq\u00a0ft/acre", "square foot per acre", DefCvt.M2_PER_HA, null, "square feet per acre", null);
    public static final /* enum */ Units CENT = new Units(UnitType.CENT, 1.0, "\u00a2", "cent", DefCvt.CENT, new String[]{"\u00a2"});
    public static final /* enum */ Units AMPERE_HOUR = new Units(UnitType.CHARGE, 3600.0, "A\u22c5h", "ampere-hour", DefCvt.COULOMB, new String[]{"A.h"});
    public static final /* enum */ Units COULOMB = new Units(UnitType.CHARGE, 1.0, "C", "coulomb", DefCvt.E);
    public static final /* enum */ Units E = new Units(UnitType.CHARGE, 1.602176487E-19, "e", "elementary charge", DefCvt.COULOMB, new String[]{"e"});
    public static final /* enum */ Units GRAM_MOLE = new Units(UnitType.CHEMICAL_AMOUNT, 1.0, "g\u8209mol", "gram-mole", DefCvt.LBMOL, new String[]{"g-mol"});
    public static final /* enum */ Units GRAM_MOLE2 = new Units(UnitType.CHEMICAL_AMOUNT, 1.0, "gmol", "gram-mole", DefCvt.LBMOL, new String[]{"gmol"});
    public static final /* enum */ Units KILOMOLE = new Units(UnitType.CHEMICAL_AMOUNT, 1000.0, "kmol", "kilomole", DefCvt.LBMOL, new String[]{"kmol"});
    public static final /* enum */ Units POUND_MOLE = new Units(UnitType.CHEMICAL_AMOUNT, 453.59237, "lb\u8209mol", "pound-mole", DefCvt.MOL, new String[]{"lb-mol"});
    public static final /* enum */ Units POUND_MOLE2 = new Units(UnitType.CHEMICAL_AMOUNT, 453.59237, "lbmol", "pound-mole", DefCvt.MOL, new String[]{"lbmol"});
    public static final /* enum */ Units MOLE = new Units(UnitType.CHEMICAL_AMOUNT, 1.0, "mol", "mole", DefCvt.LBMOL, new String[]{"mol"});
    public static final /* enum */ Units KILOGRAM_PER_LITRE = new Units(UnitType.CO2_PER_UNIT_VOLUME, 1000.0, "kg(CO\u2082)/L", "kilogram per litre", DefCvt.LB_CO2_PER_US_GAL, new String[]{"kgCO2/L"}, "kilograms per litre", "kilograms per liter");
    public static final /* enum */ Units POUNT_PER_US_GAL = new Units(UnitType.CO2_PER_UNIT_VOLUME, 119.82642731689663, "lbCO2/US\u00a0gal", "pound per US gallon", DefCvt.KG_CO2_PER_L, new String[]{"lbCO2/USgal"}, "pounds per US gallon", null);
    public static final /* enum */ Units GRAMM_PER_CUBIC_DM = new Units(UnitType.DENSITY, 1.0, "g/dm\u00b3", "gram per cubic decimetre", DefCvt.KG_PER_M3, new String[]{"g/dm3"}, "grams per cubic decimetre", "grams per cubic decimeter");
    public static final /* enum */ Units GRAM_PER_LITRE = new Units(UnitType.DENSITY, 1.0, "g/L", "gram per litre", DefCvt.LB_PER_CUIN, new String[]{"g/L"}, "grams per litre", "grams per liter");
    public static final /* enum */ Units GRAM_PER_ML = new Units(UnitType.DENSITY, 1000.0, "g/mL", "gram per millilitre", DefCvt.LB_PER_CUIN, new String[]{"g/mL", "g/ml"}, "grams per millilitre", "grams per milliliter");
    public static final /* enum */ Units KILOGRAM_PER_DM3 = new Units(UnitType.DENSITY, 1000.0, "kg/dm\u00b3", "kilogram per cubic decimetre", DefCvt.LB_CUFT, new String[]{"kg/dm3"}, "kilograms per cubic decimetre", "kilograms per cubic decimeter");
    public static final /* enum */ Units KILOGRAMM_PER_LITRE = new Units(UnitType.DENSITY, 1000.0, "kg/L", "kilogram per litre", DefCvt.LB_PER_US_GAL, new String[]{"kg/L", "kg/l"}, "kilograms per litre", "kilograms per liter");
    public static final /* enum */ Units KILOGRAMM_PER_CUBIC_M = new Units(UnitType.DENSITY, 1.0, "kg/m\u00b3", "kilogram per cubic metre", DefCvt.LB_PER_CUYD, new String[]{"kg/m3"}, "kilograms per cubic metre", "kilograms per cubic meter");
    public static final /* enum */ Units POUND_PER_CUBIC_FT = new Units(UnitType.DENSITY, 16.01846337396014, "lb/cu\u00a0ft", "pound per cubic foot", DefCvt.G_PER_CM3, new String[]{"lb/cuft", "lb/ft3"}, "pounds per cubic foot", null);
    public static final /* enum */ Units POUND_PER_CUBIC_IN = new Units(UnitType.DENSITY, 27679.90471020312, "lb/cu\u00a0in", "pound per cubic inch", DefCvt.G_PER_CM3, new String[]{"lb/cuin"}, "pounds per cubic inch", null);
    public static final /* enum */ Units POUND_PER_CUBIC_IN2 = new Units(UnitType.DENSITY, 27679.90471020312, "lb/cu\u2009in", "pound per cubic inch", DefCvt.G_PER_CM3, new String[]{"lb/in3"}, "pounds per cubic inch", null);
    public static final /* enum */ Units POUND_PER_CUBIC_YD = new Units(UnitType.DENSITY, 0.5932764212577829, "lb/cu\u00a0yd", "pound per cubic yard", DefCvt.KG_PER_M3, new String[]{"lb/cuyd", "lb/yd3"}, "pounds per cubic yard", null);
    public static final /* enum */ Units POUND_PER_IMP_GAL = new Units(UnitType.DENSITY, 99.7763726631017, "lb/imp\u00a0gal", "pound per imperial gallon", DefCvt.KG_PER_L, new String[]{"lb/impgal"}, "pounds per imperial gallon", null);
    public static final /* enum */ Units POUND_PER_US_GAL = new Units(UnitType.DENSITY, 119.82642731689663, "lb/U.S.\u00a0gal", "pound per U.S. gallon", DefCvt.KG_PER_L, new String[]{"lb/U.S.gal"}, "pounds per U.S. gallon", null);
    public static final /* enum */ Units POUND_PER_US_GAL2 = new Units(UnitType.DENSITY, 119.82642731689663, "lb/US\u00a0gal", "pound per US gallon", DefCvt.KG_PER_L, new String[]{"lb/USgal"}, "pounds per US gallon", null);
    public static final /* enum */ Units POUND_PER_US_BUSHEL = new Units(UnitType.DENSITY, 12.871859780974471, "lb/US\u00a0bu", "pound per US bushel", DefCvt.KG_PER_M3, new String[]{"lb/USbu"}, "pounds per US bushel", null);
    public static final /* enum */ Units POUND_MASS_PER_CUBIC_IN = new Units(UnitType.DENSITY, 27679.90471020312, "lbm/cu\u2009in", "pound mass per cubic inch", DefCvt.G_PER_CM3, new String[]{"lbm/cuin"}, "pounds mass per cubic inch", null);
    public static final /* enum */ Units MILLIGRAM_PER_LITRE = new Units(UnitType.DENSITY, 0.001, "mg/L", "milligram per litre", DefCvt.LB_PER_CUIN, new String[]{"mg/L"}, "milligrams per litre", "milligrams per liter");
    public static final /* enum */ Units OUNCE_PER_CUBIC_IN = new Units(UnitType.DENSITY, 1729.994044387695, "oz/cu\u00a0in", "ounce per cubic inch", DefCvt.G_PER_CM3, new String[]{"oz/cuin", "oz/in3"}, "ounces per cubic inch", null);
    public static final /* enum */ Units BOARD_OF_TRADE_UNIT = new Units(UnitType.ENERGY, 3600000.0, "B.O.T.U.", "Board of Trade Unit", DefCvt.MEGAJ, new String[]{"B.O.T.U."});
    public static final /* enum */ Units BARREL_OF_OIL_EQUIVALENT = new Units(UnitType.ENERGY, 6.1178632E9, "bboe", "barrel of oil equivalent", DefCvt.GJ, new String[]{"bboe"}, "barrels of oil equivalent", null);
    public static final /* enum */ Units BARREL_OF_OIL_EQUIVALENT2 = new Units(UnitType.ENERGY, 6.1178632E9, "BOE", "barrel of oil equivalent", DefCvt.GJ, new String[]{"BOE"}, "barrels of oil equivalent", null);
    public static final /* enum */ Units BTU = new Units(UnitType.ENERGY, 1055.05585262, "BTU", "British thermal unit", DefCvt.KJ, new String[]{"BTU", "Btu"});
    public static final /* enum */ Units BTU_39F = new Units(UnitType.ENERGY, 1059.67, "BTU<sub>39\u00b0F</sub>", "British thermal unit (39\u00b0F)", DefCvt.KJ, new String[]{"BTU-39F", "Btu-39F"}, "British thermal units (39\u00b0F)", null);
    public static final /* enum */ Units BTU_59F = new Units(UnitType.ENERGY, 1054.804, "BTU<sub>59\u00b0F</sub>", "British thermal unit (59\u00b0F)", DefCvt.KJ, new String[]{"BTU-59F", "Btu-59F"}, "British thermal units (59\u00b0F)", null);
    public static final /* enum */ Units BTU_60F = new Units(UnitType.ENERGY, 1054.68, "BTU<sub>60\u00b0F</sub>", "British thermal unit (60\u00b0F)", DefCvt.KJ, new String[]{"BTU-60F", "Btu-60F"}, "British thermal units (60\u00b0F)", null);
    public static final /* enum */ Units BTU_63F = new Units(UnitType.ENERGY, 1054.6, "BTU<sub>63\u00b0F</sub>", "British thermal unit (63\u00b0F)", DefCvt.KJ, new String[]{"BTU-63F", "Btu-63F"}, "British thermal units (63\u00b0F)", null);
    public static final /* enum */ Units BTU_ISO = new Units(UnitType.ENERGY, 1055.056, "BTU<sub>ISO</sub>", "British thermal unit (ISO)", DefCvt.KJ, new String[]{"BTU-ISO", "Btu-ISO"}, "British thermal units (ISO)", null);
    public static final /* enum */ Units BTU_IT = new Units(UnitType.ENERGY, 1055.05585262, "BTU<sub>IT</sub>", "British thermal unit (IT)", DefCvt.KJ, new String[]{"BTU-IT", "Btu-IT"}, "British thermal units (IT)", null);
    public static final /* enum */ Units BTU_MEAN = new Units(UnitType.ENERGY, 1055.87, "BTU<sub>mean</sub>", "British thermal unit (mean)", DefCvt.KJ, new String[]{"BTU-mean", "Btu-mean"}, "British thermal units (mean)", null);
    public static final /* enum */ Units BTU_TH = new Units(UnitType.ENERGY, 1054.35026444, "BTU<sub>th</sub>", "British thermal unit (thermochemical)", DefCvt.KJ, new String[]{"BTU-th", "Btu-th"}, "British thermal units (thermochemical)", null);
    public static final /* enum */ Units CALORIE = new Units(UnitType.ENERGY, 4184.0, "Cal", "calorie", DefCvt.KJ, new String[]{"Cal"});
    public static final /* enum */ Units CALORIE2 = new Units(UnitType.ENERGY, 4.184, "cal", "calorie", DefCvt.J, new String[]{"cal"});
    public static final /* enum */ Units CAL_15C = new Units(UnitType.ENERGY, 4185.8, "Cal\u00b9\u2075", "Calorie (15\u00b0C)", DefCvt.KJ, new String[]{"Cal-15"}, "Calories (15\u00b0C)", null);
    public static final /* enum */ Units CAL_15C2 = new Units(UnitType.ENERGY, 4.1858, "cal\u00b9\u2075", "calorie (15\u00b0C)", DefCvt.J, new String[]{"cal-15"}, "calories (15\u00b0C)", null);
    public static final /* enum */ Units CAL_IT = new Units(UnitType.ENERGY, 4185.8, "Cal<sub>IT</sub>", "Calorie (International Steam Table)", DefCvt.KJ, new String[]{"Cal-IT"}, "Calories (International Steam Table)", null);
    public static final /* enum */ Units CAL_IT2 = new Units(UnitType.ENERGY, 4.1868, "cal<sub>IT</sub>", "calorie (International Steam Table)", DefCvt.J, new String[]{"cal-IT"}, "calories (International Steam Table)", null);
    public static final /* enum */ Units CAL_TH = new Units(UnitType.ENERGY, 4184.0, "Cal<sub>th</sub>", "Calorie (thermochemical)", DefCvt.KJ, new String[]{"Cal-th"}, "Calories (thermochemical)", null);
    public static final /* enum */ Units CAL_TH2 = new Units(UnitType.ENERGY, 4.184, "cal<sub>th</sub>", "calorie (thermochemical)", DefCvt.J, new String[]{"cal-th"}, "calories (thermochemical)", null);
    public static final /* enum */ Units CCATM = new Units(UnitType.ENERGY, 0.101325, "cc atm", "cubic centimetre-atmosphere", DefCvt.MILLIJ, new String[]{"ccatm"}, null, "cubic centimeter-atmosphere");
    public static final /* enum */ Units KILOCALORIE = new Units(UnitType.ENERGY, 4184.0, "kcal", "kilocalorie", DefCvt.KJ, new String[]{"kcal"});
    public static final /* enum */ Units GIGAJOULE = new Units(UnitType.ENERGY, 1.0E9, "GJ", "magejoule", DefCvt.CAL, new String[]{"GJ"}, null, null);
    public static final /* enum */ Units MEGAJOULE = new Units(UnitType.ENERGY, 1000000.0, "MJ", "magejoule", DefCvt.CAL, new String[]{"MJ"}, null, null);
    public static final /* enum */ Units KILOJOULE = new Units(UnitType.ENERGY, 1000.0, "kJ", "kilojoule", DefCvt.CAL, new String[]{"kJ"}, null, null);
    public static final /* enum */ Units JOULE = new Units(UnitType.ENERGY, 1.0, "J", "joule", DefCvt.CAL, new String[]{"J"}, null, null);
    public static final /* enum */ Units MILLIJOULE = new Units(UnitType.ENERGY, 0.001, "mJ", "joule", DefCvt.CAL, new String[]{"mJ"}, null, null);
    public static final /* enum */ Units GIGAMETRE = new Units(UnitType.LENGTH, 1.0E9, "Gm", "gigametre", DefCvt.MI, new String[]{"Gm"}, null, "gigameter");
    public static final /* enum */ Units MEAGAMETRE = new Units(UnitType.LENGTH, 1000000.0, "Mm", "megametre", DefCvt.MI, new String[]{"Mm"}, null, "megameter");
    public static final /* enum */ Units KILOMETRE = new Units(UnitType.LENGTH, 1000.0, "km", "kilometre", DefCvt.MI, new String[]{"km"}, null, "kilometer");
    public static final /* enum */ Units HECTOMETRE = new Units(UnitType.LENGTH, 100.0, "hm", "hectometre", DefCvt.MI, new String[]{"hm"}, null, "hectometer");
    public static final /* enum */ Units DECAMETRE = new Units(UnitType.LENGTH, 10.0, "dam", "decametre", DefCvt.MI, new String[]{"dam"}, null, "dekameter");
    public static final /* enum */ Units METRE = new Units(UnitType.LENGTH, 1.0, "m", "metre", DefCvt.FT_AND_IN, new String[]{"m", "meters", "metres"}, null, "meter");
    public static final /* enum */ Units DECIMETRE = new Units(UnitType.LENGTH, 0.1, "dm", "decimetre", DefCvt.IN, null, null, "decimeter");
    public static final /* enum */ Units CENTIMETRE = new Units(UnitType.LENGTH, 0.01, "cm", "centimetre", DefCvt.IN, null, null, "centimeter");
    public static final /* enum */ Units MILLIMETRE = new Units(UnitType.LENGTH, 0.001, "mm", "millimetre", DefCvt.IN, null, null, "millimeter");
    public static final /* enum */ Units MICROMETRE = new Units(UnitType.LENGTH, 1.0E-6, "\u00b5m", "micrometre", DefCvt.IN, new String[]{"\u00b5m", "um"}, null, "micrometer");
    public static final /* enum */ Units NANOMETRE = new Units(UnitType.LENGTH, 1.0E-9, "nm", "nanometre", DefCvt.IN, null, null, "nanometer");
    public static final /* enum */ Units ANGSTROM = new Units(UnitType.LENGTH, 1.0E-10, "\u00c5", "\u00e5ngstr\u00f6m", DefCvt.IN, new String[]{"\u00c5", "angstrom"}, null, null);
    public static final /* enum */ Units MILE = new Units(UnitType.LENGTH, 1609.344, "mi", "mile", DefCvt.KM);
    public static final /* enum */ Units FURLONG = new Units(UnitType.LENGTH, 201.168, "fur", "furlong", DefCvt.FT_M);
    public static final /* enum */ Units CHAIN = new Units(UnitType.LENGTH, 20.11684023368, "ch", "chain", DefCvt.FT_M);
    public static final /* enum */ Units ROD = new Units(UnitType.LENGTH, 5.0292, "rd", "rod", DefCvt.FT_M);
    public static final /* enum */ Units POLE = new Units(UnitType.LENGTH, 5.0292, "pole", "pole", DefCvt.FT_M);
    public static final /* enum */ Units PERCH = new Units(UnitType.LENGTH, 5.0292, "perch", "perch", DefCvt.FT_M);
    public static final /* enum */ Units FATHOM = new Units(UnitType.LENGTH, 1.8288, "fathom", "fathom", DefCvt.FT_M);
    public static final /* enum */ Units YHARD = new Units(UnitType.LENGTH, 0.9144, "yd", "yard", DefCvt.M);
    public static final /* enum */ Units FOOT = new Units(UnitType.LENGTH, 0.3048, "ft", "foot", DefCvt.M, null, "feet", null);
    public static final /* enum */ Units HAND = new Units(UnitType.LENGTH, 0.1016, "hand", "hand", DefCvt.IN_CM);
    public static final /* enum */ Units INCH = new Units(UnitType.LENGTH, 0.0254, "in", "inch", DefCvt.MM, null, "inches", null);
    public static final /* enum */ Units MICORINCH = new Units(UnitType.LENGTH, 2.54E-8, "\u00b5in", "microinch", DefCvt.NM, new String[]{"\u00b5in", "uin"}, "microinches", null);
    public static final /* enum */ Units BANANA = new Units(UnitType.LENGTH, 0.1778, "banana", "banana", DefCvt.IN_CM);
    public static final /* enum */ Units NAUTICAL_MILE = new Units(UnitType.LENGTH, 1852.0, "nmi", "nautical mile", DefCvt.KM_MI);
    public static final /* enum */ Units NAUTICAL_MILE_OLD_BRIT = new Units(UnitType.LENGTH, 1853.184, "(Brit) nmi", "British nautical mile", DefCvt.KM_MI, new String[]{"oldUKnmi", "admiralty nmi", "Brnmi", "admi"}, null, null);
    public static final /* enum */ Units NAUTICAL_MILE_OLD_US = new Units(UnitType.LENGTH, 1853.24496, "(pre\u20111954 US) nmi", "(pre-1954 US) nautical mile", DefCvt.KM_MI, new String[]{"oldUSnmi", "pre1954USnmi", "pre1954U.S.nmi"}, null, null);
    public static final /* enum */ Units GIGAPARSEC = new Units(UnitType.LENGTH, 3.0856776E25, "Gpc", "gigaparsec", DefCvt.GLY);
    public static final /* enum */ Units MEGAPARSEC = new Units(UnitType.LENGTH, 3.0856776E22, "Mpc", "megaparsec", DefCvt.MLY);
    public static final /* enum */ Units KILOPARSEC = new Units(UnitType.LENGTH, 3.0856776E19, "kpc", "kiloparsec", DefCvt.KLY);
    public static final /* enum */ Units PARSEC = new Units(UnitType.LENGTH, 3.0856776E16, "pc", "parsec", DefCvt.LY);
    public static final /* enum */ Units GIGALIGHT_YEAR = new Units(UnitType.LENGTH, 9.4607304725808E24, "Gly", "gigalight-year", DefCvt.MPC);
    public static final /* enum */ Units MEGALIGHT_YEAR = new Units(UnitType.LENGTH, 9.4607304725808E21, "Mly", "megalight-year", DefCvt.KPC);
    public static final /* enum */ Units KILOLIGHT_YEAR = new Units(UnitType.LENGTH, 9.4607304725808E18, "kly", "kilolight-year", DefCvt.PC);
    public static final /* enum */ Units LIGHT_YEAR = new Units(UnitType.LENGTH, 9.4607304725808E15, "ly", "light-year", DefCvt.AU);
    public static final /* enum */ Units ASTRONOMICAL_UNIT = new Units(UnitType.LENGTH, 1.49597870691E11, "AU", "astronomical unit", DefCvt.KM_MI);
    public static final /* enum */ Units KILOGRAM = new Units(UnitType.MASS, 1.0, "kg", "kilogram", DefCvt.LB);
    public static final /* enum */ Units GRAM = new Units(UnitType.MASS, 0.001, "g", "gram", DefCvt.OZ);
    public static final /* enum */ Units DECIGRAM = new Units(UnitType.MASS, 1.0E-4, "dg", "decigram", DefCvt.OZ);
    public static final /* enum */ Units MILLIGRAM = new Units(UnitType.MASS, 1.0E-6, "mg", "milligram", DefCvt.GR);
    public static final /* enum */ Units MICROGRAM = new Units(UnitType.MASS, 1.0E-9, "\u00b5g", "microgram", DefCvt.GR, new String[]{"\u00b5g", "ug", "mcg"}, null, null);
    public static final /* enum */ Units TONNE = new Units(UnitType.MASS, 1000.0, "t", "tonne", DefCvt.LT_ST);
    public static final /* enum */ Units METRIC_TON = new Units(UnitType.MASS, 1000.0, "t", "metric ton", DefCvt.LT_ST, new String[]{"MT"}, null, null);
    public static final /* enum */ Units LONG_TON = new Units(UnitType.MASS, 1016.0469088, "long ton", "long ton", DefCvt.T, new String[]{"LT"}, null, null);
    public static final /* enum */ Units SHORT_TON = new Units(UnitType.MASS, 907.18474, "short ton", "short ton", DefCvt.T, new String[]{"ST"}, null, null);
    public static final /* enum */ Units LONG_HUNDREDWEIGHT = new Units(UnitType.MASS, 50.80234544, "long\u00a0cwt", "long hundredweight", DefCvt.LB_KG, new String[]{"long cwt"}, null, null);
    public static final /* enum */ Units SHORT_HUNDREDWEIGHT = new Units(UnitType.MASS, 45.359237, "short\u00a0cwt", "short hundredweight", DefCvt.LB_KG, new String[]{"short cwt"}, null, null);
    public static final /* enum */ Units LONG_QUARTER = new Units(UnitType.MASS, 12.70058636, "long\u00a0qtr", "long quarter", DefCvt.LB_KG, new String[]{"long qtr"}, null, null);
    public static final /* enum */ Units SHORT_QUARTER = new Units(UnitType.MASS, 11.33980925, "short\u00a0qtr", "short quarter", DefCvt.LB_KG, new String[]{"short qtr"}, null, null);
    public static final /* enum */ Units STONE = new Units(UnitType.MASS, 6.35029318, "st", "stone", DefCvt.LB_KG);
    public static final /* enum */ Units POUND = new Units(UnitType.MASS, 0.45359237, "lb", "pound", DefCvt.KG);
    public static final /* enum */ Units OUNCE = new Units(UnitType.MASS, 0.028349523125, "oz", "ounce", DefCvt.G);
    public static final /* enum */ Units DRACHM = new Units(UnitType.MASS, 0.001771845195, "drachm", "drachm", DefCvt.G, new String[]{"dram"}, null, null);
    public static final /* enum */ Units GRAIN = new Units(UnitType.MASS, 6.479891E-5, "gr", "grain", DefCvt.G);
    public static final /* enum */ Units TROY_POUND = new Units(UnitType.MASS, 0.3732417216, "troy pound", "troy pound", DefCvt.LB_KG);
    public static final /* enum */ Units TROY_OUNCE = new Units(UnitType.MASS, 0.0311034768, "ozt", "troy ounce", DefCvt.OZ_G);
    public static final /* enum */ Units PENNYWEIGHT = new Units(UnitType.MASS, 0.00155517384, "dwt", "pennyweight", DefCvt.OZ_G);
    public static final /* enum */ Units CARAT = new Units(UnitType.MASS, 2.0E-4, "carat", "carat", DefCvt.G);
    public static final /* enum */ Units DEGREE_CELSIUS = new Units(UnitType.TEMPERATURE, 1.0, -273.15, "\u00b0C", true, "degree Celsius", DefCvt.F, new String[]{"C", "Celsius", "\u00b0C"}, "degrees Celsius", null);
    public static final /* enum */ Units DEGREE_FAHRENHEIT = new Units(UnitType.TEMPERATURE, 0.5555555555555556, -459.66999999999996, "\u00b0F", true, "degree Fahrenheit", DefCvt.C, new String[]{"F", "\u00b0F"}, "degrees Fahrenheit", null);
    public static final /* enum */ Units KELVIN = new Units(UnitType.TEMPERATURE, 1.0, 0.0, "K", true, "kelvin", DefCvt.C_F, new String[]{"K"}, null, null);
    public static final /* enum */ Units KILOELECTRONVOLT = new Units(UnitType.TEMPERATURE, 1.1604505E7, "keV", "kiloelectronvolt", DefCvt.MK, new String[]{"keVT"});
    public static final /* enum */ Units DEGREE_RANKINE = new Units(UnitType.TEMPERATURE, 0.5555555555555556, 0.0, "\u00b0R", true, "degree Rankine", DefCvt.K_F_C, new String[]{"R", "\u00b0R"}, "degrees Rankine", null);
    private final UnitType type;
    private final double scale;
    private final double offset;
    private final String symbol;
    private final boolean isSymbolDesc;
    private final String name;
    private final String[] altCodes;
    private final DefCvt defaultConv;
    private final String plural;
    private final String usName;
    private static final HashMap<String, Units> NAME_CODE_MAP;
    private static final /* synthetic */ Units[] $VALUES;

    public static Units[] values() {
        return (Units[])$VALUES.clone();
    }

    public static Units valueOf(String name) {
        return Enum.valueOf(Units.class, name);
    }

    private Units(UnitType type, double scale, String symbol, String name, DefCvt defCvt) {
        this(type, scale, 0.0, symbol, false, name, defCvt, null, null, null);
    }

    private Units(UnitType type, double scale, String symbol, String name, DefCvt defCvt, String[] altCodes) {
        this(type, scale, 0.0, symbol, false, name, defCvt, altCodes, null, null);
    }

    private Units(UnitType type, double scale, String symbol, String name, DefCvt defCvt, String[] altCodes, String plural, String usName) {
        this(type, scale, 0.0, symbol, false, name, defCvt, altCodes, plural, usName);
    }

    private Units(UnitType type, double scale, double offset, String symbol, boolean isSymbolDesc, String name, DefCvt defCvt, String[] altCodes, String plural, String usName) {
        assert (type != null);
        assert (symbol != null);
        assert (name != null);
        assert (defCvt != null);
        this.type = type;
        this.scale = scale;
        this.offset = offset;
        this.symbol = symbol;
        this.isSymbolDesc = isSymbolDesc;
        this.name = name;
        this.altCodes = altCodes;
        this.defaultConv = defCvt;
        this.plural = plural;
        this.usName = usName;
    }

    public final double getScale() {
        return this.scale;
    }

    public final double getOffset() {
        return this.offset;
    }

    public final String getSymbol() {
        return this.symbol;
    }

    public final String getName() {
        if (this.isSymbolDesc) {
            return this.symbol;
        }
        return this.name;
    }

    public final String[] getAltCodes() {
        return this.altCodes;
    }

    public final DefCvt getDefaultCvt() {
        return this.defaultConv;
    }

    public final String getPluralName() {
        if (this.isSymbolDesc) {
            return this.symbol;
        }
        if (this.plural == null) {
            return this.name + "s";
        }
        return this.plural;
    }

    public final String getUsName() {
        return this.usName;
    }

    public static Units searchUnitFromName(String name) {
        if (NAME_CODE_MAP.containsKey(name)) {
            return NAME_CODE_MAP.get(name);
        }
        for (Units ut : Units.values()) {
            if (!name.equals(ut.getSymbol())) continue;
            return ut;
        }
        return null;
    }

    public static boolean isSameUnitType(Units a, Units b) {
        return a.type == b.type;
    }

    static {
        $VALUES = new Units[]{GRAY, RAD, CENTIMETRE_PER_SEC_SQ, FOOT_PER_SEC_SQ, STANDARD_GRAVITY, KILOMETRE_PER_H_PER_SEC, KILOMETRE_PER_SEC_SQ, METRE_PER_SEC_SQ, MILE_PER_H_PER_SEC, SQUARE_KILOMETRE, SQUARE_HECTOMETRE, SQUARE_DECAMETRE, SQUARE_METRE, SQUARE_DECIMETRE, SQUARE_CENTIMETRE, SQUARE_MILLIMETRE, THOUSAND_SQFT, ARE, ACRE, ARPENT, CUERDA, DAA, DUNAM, DUNUM, HECTARE, IRISH_ACRE, PONDEMAAT, PYEONG, RAI, ROOD, SQUARE_FOOT, SQUARE_FOOT2, SQUARE_INCH, SQUARE_NAUTICAL_MILE, SQUARE_MILE, SQUARE_PERCH, SQUARE_VERST, SQUARE_YARD, TSUBO, M2_PER_HA, SQFT_PER_ACRE, CENT, AMPERE_HOUR, COULOMB, E, GRAM_MOLE, GRAM_MOLE2, KILOMOLE, POUND_MOLE, POUND_MOLE2, MOLE, KILOGRAM_PER_LITRE, POUNT_PER_US_GAL, GRAMM_PER_CUBIC_DM, GRAM_PER_LITRE, GRAM_PER_ML, KILOGRAM_PER_DM3, KILOGRAMM_PER_LITRE, KILOGRAMM_PER_CUBIC_M, POUND_PER_CUBIC_FT, POUND_PER_CUBIC_IN, POUND_PER_CUBIC_IN2, POUND_PER_CUBIC_YD, POUND_PER_IMP_GAL, POUND_PER_US_GAL, POUND_PER_US_GAL2, POUND_PER_US_BUSHEL, POUND_MASS_PER_CUBIC_IN, MILLIGRAM_PER_LITRE, OUNCE_PER_CUBIC_IN, BOARD_OF_TRADE_UNIT, BARREL_OF_OIL_EQUIVALENT, BARREL_OF_OIL_EQUIVALENT2, BTU, BTU_39F, BTU_59F, BTU_60F, BTU_63F, BTU_ISO, BTU_IT, BTU_MEAN, BTU_TH, CALORIE, CALORIE2, CAL_15C, CAL_15C2, CAL_IT, CAL_IT2, CAL_TH, CAL_TH2, CCATM, KILOCALORIE, GIGAJOULE, MEGAJOULE, KILOJOULE, JOULE, MILLIJOULE, GIGAMETRE, MEAGAMETRE, KILOMETRE, HECTOMETRE, DECAMETRE, METRE, DECIMETRE, CENTIMETRE, MILLIMETRE, MICROMETRE, NANOMETRE, ANGSTROM, MILE, FURLONG, CHAIN, ROD, POLE, PERCH, FATHOM, YHARD, FOOT, HAND, INCH, MICORINCH, BANANA, NAUTICAL_MILE, NAUTICAL_MILE_OLD_BRIT, NAUTICAL_MILE_OLD_US, GIGAPARSEC, MEGAPARSEC, KILOPARSEC, PARSEC, GIGALIGHT_YEAR, MEGALIGHT_YEAR, KILOLIGHT_YEAR, LIGHT_YEAR, ASTRONOMICAL_UNIT, KILOGRAM, GRAM, DECIGRAM, MILLIGRAM, MICROGRAM, TONNE, METRIC_TON, LONG_TON, SHORT_TON, LONG_HUNDREDWEIGHT, SHORT_HUNDREDWEIGHT, LONG_QUARTER, SHORT_QUARTER, STONE, POUND, OUNCE, DRACHM, GRAIN, TROY_POUND, TROY_OUNCE, PENNYWEIGHT, CARAT, DEGREE_CELSIUS, DEGREE_FAHRENHEIT, KELVIN, KILOELECTRONVOLT, DEGREE_RANKINE};
        NAME_CODE_MAP = new HashMap();
        for (Units unit : Units.values()) {
            if (!NAME_CODE_MAP.containsKey(unit.name)) {
                NAME_CODE_MAP.put(unit.name, unit);
            }
            if (unit.usName != null) {
                NAME_CODE_MAP.put(unit.usName, unit);
            }
            if (unit.altCodes == null) continue;
            for (String altCode : unit.altCodes) {
                assert (!NAME_CODE_MAP.containsKey(altCode)) : "Alternative Name Code \"" + altCode + "\" should be unique, but was already added in Map before!";
                NAME_CODE_MAP.put(altCode, unit);
            }
        }
    }

    private static enum UnitType {
        ABSORBED_RADIATION_DOSE,
        ACCELERATION,
        AREA,
        AREA_PER_UNIT_AREA,
        CENT,
        CHARGE,
        CHEMICAL_AMOUNT,
        CO2_PER_UNIT_VOLUME,
        DENSITY,
        ENERGY,
        LENGTH,
        MASS,
        TEMPERATURE;

    }
}

