/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.core;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.PfnArgumentMode;
import org.sweble.wikitext.engine.config.ParserFunctionGroup;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.core.CorePfnFunction;
import org.sweble.wikitext.engine.utils.ApplyToText;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class CorePfnFunctionsFormatting
extends ParserFunctionGroup {
    private static final long serialVersionUID = 1L;

    protected CorePfnFunctionsFormatting(WikiConfig wikiConfig) {
        super("Core - Parser Functions - Formatting");
        this.addParserFunction(new LcPfn(wikiConfig));
        this.addParserFunction(new LcFirstPfn(wikiConfig));
        this.addParserFunction(new UcPfn(wikiConfig));
        this.addParserFunction(new UcFirstPfn(wikiConfig));
        this.addParserFunction(new PadLeftPfn(wikiConfig));
    }

    public static CorePfnFunctionsFormatting group(WikiConfig wikiConfig) {
        return new CorePfnFunctionsFormatting(wikiConfig);
    }

    public static final class PadLeftPfn
    extends CorePfnFunction {
        private static final long serialVersionUID = 1L;

        public PadLeftPfn() {
            super(PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "padleft");
        }

        public PadLeftPfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "padleft");
        }

        @Override
        public WtNode invoke(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
            int len;
            String text;
            String padStr;
            WtNode arg0;
            block10: {
                if (args.size() < 1) {
                    return this.nf().list();
                }
                arg0 = frame.expand(args.get(0));
                if (args.size() < 2) {
                    return arg0;
                }
                padStr = "0";
                try {
                    text = this.tu().astToText(arg0).trim();
                    WtNode arg1 = frame.expand(args.get(1));
                    String lenStr = this.tu().astToText(arg1).trim();
                    len = Integer.parseInt(lenStr);
                    if (len <= 0) {
                        return arg0;
                    }
                    if (args.size() < 3) break block10;
                    WtNode arg2 = frame.expand(args.get(2));
                    try {
                        padStr = this.tu().astToText(arg2);
                    }
                    catch (StringConversionException stringConversionException) {
                        // empty catch block
                    }
                    if (padStr.isEmpty()) {
                        return arg0;
                    }
                }
                catch (StringConversionException e) {
                    return arg0;
                }
                catch (NumberFormatException e) {
                    return arg0;
                }
            }
            int padLen = len - text.length();
            if (padLen <= 0) {
                return arg0;
            }
            int repeat = 1 + (padLen - 1) / padStr.length();
            String padding = StringUtils.repeat((String)padStr, (int)repeat);
            padding = padding.substring(0, padLen);
            return this.nf().text(padding + text);
        }
    }

    public static final class UcFirstPfn
    extends CorePfnFunction {
        private static final long serialVersionUID = 1L;

        public UcFirstPfn() {
            super(PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "ucfirst");
        }

        public UcFirstPfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "ucfirst");
        }

        @Override
        public WtNode invoke(WtTemplate pfn, ExpansionFrame preprocessorFrame, List<? extends WtNode> args) {
            if (args.size() < 1) {
                return this.nf().list();
            }
            new ApplyToText(new ApplyToText.Functor(){

                @Override
                public String apply(String text) {
                    if (text.isEmpty()) {
                        return text;
                    }
                    return text.substring(0, 1).toUpperCase() + text.substring(1);
                }
            }).go(args.get(0));
            return args.get(0);
        }
    }

    public static final class UcPfn
    extends CorePfnFunction {
        private static final long serialVersionUID = 1L;

        public UcPfn() {
            super(PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "uc");
        }

        public UcPfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "uc");
        }

        @Override
        public WtNode invoke(WtTemplate pfn, ExpansionFrame preprocessorFrame, List<? extends WtNode> args) {
            if (args.size() < 1) {
                return this.nf().list();
            }
            new ApplyToText(new ApplyToText.Functor(){

                @Override
                public String apply(String text) {
                    return text.toUpperCase();
                }
            }).go(args.get(0));
            return args.get(0);
        }
    }

    public static final class LcFirstPfn
    extends CorePfnFunction {
        private static final long serialVersionUID = 1L;

        public LcFirstPfn() {
            super(PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "lcfirst");
        }

        public LcFirstPfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "lcfirst");
        }

        @Override
        public WtNode invoke(WtTemplate pfn, ExpansionFrame preprocessorFrame, List<? extends WtNode> args) {
            if (args.size() < 1) {
                return this.nf().list();
            }
            new ApplyToText(new ApplyToText.Functor(){

                @Override
                public String apply(String text) {
                    if (text.isEmpty()) {
                        return text;
                    }
                    return text.substring(0, 1).toLowerCase() + text.substring(1);
                }
            }).go(args.get(0));
            return args.get(0);
        }
    }

    public static final class LcPfn
    extends CorePfnFunction {
        private static final long serialVersionUID = 1L;

        public LcPfn() {
            super(PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "lc");
        }

        public LcPfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "lc");
        }

        @Override
        public WtNode invoke(WtTemplate pfn, ExpansionFrame preprocessorFrame, List<? extends WtNode> args) {
            if (args.size() < 1) {
                return this.nf().list();
            }
            new ApplyToText(new ApplyToText.Functor(){

                @Override
                public String apply(String text) {
                    return text.toLowerCase();
                }
            }).go(args.get(0));
            return args.get(0);
        }
    }
}

