/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.core;

import de.fau.cs.osr.utils.XmlGrammar;
import java.util.List;
import java.util.ListIterator;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.PfnArgumentMode;
import org.sweble.wikitext.engine.config.ParserFunctionGroup;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.core.CorePfnFunction;
import org.sweble.wikitext.engine.nodes.EngineRtData;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtTagExtension;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.nodes.WtTemplateArgument;
import org.sweble.wikitext.parser.utils.StringConversionException;
import org.sweble.wikitext.parser.utils.WtRtDataPrinter;

public class CorePfnFunctionsMiscellaneous
extends ParserFunctionGroup {
    private static final long serialVersionUID = 1L;

    protected CorePfnFunctionsMiscellaneous(WikiConfig wikiConfig) {
        super("Core - Parser Functions - Miscellaneous");
        this.addParserFunction(new TagPfn(wikiConfig));
    }

    public static CorePfnFunctionsMiscellaneous group(WikiConfig wikiConfig) {
        return new CorePfnFunctionsMiscellaneous(wikiConfig);
    }

    public static final class TagPfn
    extends CorePfnFunction {
        private static final long serialVersionUID = 1L;

        public TagPfn() {
            super(PfnArgumentMode.TEMPLATE_ARGUMENTS, "tag");
        }

        public TagPfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.TEMPLATE_ARGUMENTS, "tag");
        }

        @Override
        public WtNode invoke(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> argsValues) {
            String nameStr;
            if (argsValues.size() < 2) {
                return pfn;
            }
            WtTemplateArgument nameNode = (WtTemplateArgument)argsValues.get(0);
            try {
                WtNode expNameNode = frame.expand((WtNode)nameNode.getValue());
                nameStr = this.tu().astToText(expNameNode).trim();
            }
            catch (StringConversionException e) {
                return pfn;
            }
            WtTemplateArgument bodyNode = (WtTemplateArgument)argsValues.get(1);
            WtNode expValueNode = frame.expand((WtNode)bodyNode.getValue());
            expValueNode = this.stripComments(expValueNode);
            String bodyStr = WtRtDataPrinter.print((WtNode)expValueNode);
            WtNodeList attrs = this.nf().list();
            for (int i = 2; i < argsValues.size(); ++i) {
                String argValue;
                String argName;
                WtTemplateArgument arg = (WtTemplateArgument)argsValues.get(i);
                WtNode argNameNode = frame.expand((WtNode)arg.getName());
                WtNode argValueNode = frame.expand((WtNode)arg.getValue());
                if (argNameNode == null || argValueNode == null) continue;
                try {
                    argName = this.tu().astToText(argNameNode);
                    argValue = this.tu().astToText(argValueNode);
                }
                catch (StringConversionException e) {
                    continue;
                }
                if (!XmlGrammar.xmlName().matcher(argName).matches()) continue;
                WtNodeList argValueList = this.nf().list((WtNode)this.nf().text(argValue));
                attrs.add((Object)this.nf().attr(this.nf().name(this.nf().list((WtNode)this.nf().text(argName))), this.nf().value(argValueList)));
            }
            WtTagExtension tagExt = EngineRtData.set(this.nf().tagExt(nameStr, this.nf().attrs(attrs), this.nf().tagExtBody(bodyStr)));
            return frame.expand((WtNode)tagExt);
        }

        private WtNode stripComments(WtNode n) {
            ListIterator i = n.listIterator();
            block3: while (i.hasNext()) {
                WtNode child = (WtNode)i.next();
                switch (child.getNodeType()) {
                    case 196613: 
                    case 458754: {
                        i.remove();
                        continue block3;
                    }
                }
                if (child.isEmpty()) continue;
                this.stripComments(child);
            }
            return n;
        }
    }
}

