/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.core;

import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.config.Namespace;
import org.sweble.wikitext.engine.config.ParserFunctionGroup;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.core.CorePfnFunction;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class CorePfnFunctionsNamespaces
extends ParserFunctionGroup {
    private static final long serialVersionUID = 1L;

    protected CorePfnFunctionsNamespaces(WikiConfig wikiConfig) {
        super("Core - Parser Functions - Namespaces");
        this.addParserFunction(new NsPfn(wikiConfig));
    }

    public static CorePfnFunctionsNamespaces group(WikiConfig wikiConfig) {
        return new CorePfnFunctionsNamespaces(wikiConfig);
    }

    public static final class NsPfn
    extends CorePfnFunction {
        private static final long serialVersionUID = 1L;

        public NsPfn() {
            super("ns");
        }

        public NsPfn(WikiConfig wikiConfig) {
            super(wikiConfig, "ns");
        }

        @Override
        public WtNode invoke(WtTemplate wtTemplate, ExpansionFrame preprocessorFrame, List<? extends WtNode> args) {
            String arg;
            if (args.size() < 0) {
                return null;
            }
            WtNode arg0 = preprocessorFrame.expand(args.get(0));
            try {
                arg = this.tu().astToText(arg0).trim();
            }
            catch (StringConversionException e1) {
                return null;
            }
            Namespace namespace = preprocessorFrame.getWikiConfig().getNamespace(arg);
            if (namespace == null) {
                int ns;
                try {
                    ns = Integer.parseInt(arg);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                namespace = preprocessorFrame.getWikiConfig().getNamespace(ns);
            }
            String result = "";
            if (namespace != null) {
                result = namespace.getName();
            }
            return this.nf().text(result);
        }
    }
}

