/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.core;

import de.fau.cs.osr.ptk.common.Warning;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.IllegalArgumentsWarning;
import org.sweble.wikitext.engine.InvalidNameWarning;
import org.sweble.wikitext.engine.InvalidPagenameWarning;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.PfnArgumentMode;
import org.sweble.wikitext.engine.config.Namespace;
import org.sweble.wikitext.engine.config.ParserFunctionGroup;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.core.CorePfnFunction;
import org.sweble.wikitext.engine.nodes.EngineRtData;
import org.sweble.wikitext.engine.utils.UrlEncoding;
import org.sweble.wikitext.engine.utils.UrlType;
import org.sweble.wikitext.parser.WikitextWarning;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class CorePfnFunctionsUrlData
extends ParserFunctionGroup {
    private static final long serialVersionUID = 1L;

    protected CorePfnFunctionsUrlData(WikiConfig wikiConfig) {
        super("Core - Parser Functions - URL data");
        this.addParserFunction(new FullurlPfn(wikiConfig));
        this.addParserFunction(new FilepathPfn(wikiConfig));
        this.addParserFunction(new UrlencodePfn(wikiConfig));
    }

    public static CorePfnFunctionsUrlData group(WikiConfig wikiConfig) {
        return new CorePfnFunctionsUrlData(wikiConfig);
    }

    public static final class UrlencodePfn
    extends CorePfnFunction {
        private static final long serialVersionUID = 1L;

        public UrlencodePfn() {
            super("urlencode");
        }

        public UrlencodePfn(WikiConfig wikiConfig) {
            super(wikiConfig, "urlencode");
        }

        @Override
        public WtNode invoke(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
            String text;
            if (args.size() < 1) {
                return pfn;
            }
            try {
                text = this.tu().astToText(args.get(0)).trim();
            }
            catch (StringConversionException e1) {
                return pfn;
            }
            UrlEncoding encoder = UrlEncoding.QUERY;
            if (args.size() > 1) {
                try {
                    String encoderName = this.tu().astToText(args.get(1)).trim();
                    encoder = UrlEncoding.valueOf(encoderName.toUpperCase());
                }
                catch (StringConversionException stringConversionException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return this.nf().text(encoder.encode(text));
        }
    }

    public static final class FilepathPfn
    extends CorePfnFunction {
        private static final long serialVersionUID = 1L;

        public FilepathPfn() {
            super("filepath");
        }

        public FilepathPfn(WikiConfig wikiConfig) {
            super(wikiConfig, "filepath");
        }

        @Override
        public WtNode invoke(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
            String url;
            PageTitle title;
            if (args.size() < 1) {
                return pfn;
            }
            try {
                String titleStr = this.tu().astToText(args.get(0)).trim();
                title = PageTitle.make(frame.getWikiConfig(), titleStr);
                title = title.newWithNamespace(frame.getWikiConfig().getFileNamespace());
            }
            catch (StringConversionException e1) {
                return pfn;
            }
            catch (LinkTargetException e) {
                return pfn;
            }
            int size = -1;
            boolean nowiki = false;
            if (args.size() > 1) {
                try {
                    String opt1 = this.tu().astToText(args.get(1)).trim();
                    String opt2 = null;
                    if (args.size() > 2) {
                        opt2 = this.tu().astToText(args.get(2)).trim();
                    }
                    String sizeStr = opt1;
                    if ("nowiki".equals(opt1)) {
                        nowiki = true;
                        sizeStr = opt2;
                    } else if ("nowiki".equals(opt2)) {
                        nowiki = true;
                    }
                    if (sizeStr != null) {
                        size = Integer.parseInt(sizeStr);
                    }
                }
                catch (StringConversionException opt1) {
                }
                catch (NumberFormatException opt1) {
                    // empty catch block
                }
            }
            try {
                url = frame.getCallback().fileUrl(title, size, -1);
            }
            catch (Exception e) {
                return pfn;
            }
            if (url == null) {
                return this.nf().text("");
            }
            return nowiki ? EngineRtData.set(this.nf().nowiki(url)) : this.nf().text(url);
        }
    }

    public static final class FullurlPfn
    extends CorePfnFunction {
        private static final long serialVersionUID = 1L;

        public FullurlPfn() {
            super(PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "fullurl");
        }

        public FullurlPfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "fullurl");
        }

        @Override
        public WtNode invoke(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> argsValues) {
            URL titleUrl;
            Namespace ns;
            PageTitle title;
            String titleStr;
            if (argsValues.size() < 1) {
                frame.fileWarning((Warning)new IllegalArgumentsWarning(WikitextWarning.WarningSeverity.NORMAL, this.getClass(), "Parser function was called with too few arguments!", (WtNode)pfn));
                return pfn;
            }
            if (argsValues.size() > 2) {
                frame.fileWarning((Warning)new IllegalArgumentsWarning(WikitextWarning.WarningSeverity.NONE, this.getClass(), "Parser function was called with too many arguments!", (WtNode)pfn));
            }
            WtNode titleNode = argsValues.get(0);
            try {
                titleStr = this.tu().astToText(titleNode);
            }
            catch (StringConversionException e1) {
                frame.fileWarning((Warning)new InvalidNameWarning(WikitextWarning.WarningSeverity.NORMAL, this.getClass(), titleNode));
                return pfn;
            }
            try {
                title = PageTitle.make(frame.getWikiConfig(), titleStr);
            }
            catch (LinkTargetException e) {
                try {
                    titleStr = URLDecoder.decode(titleStr, "UTF-8");
                    title = PageTitle.make(frame.getWikiConfig(), titleStr);
                }
                catch (LinkTargetException e2) {
                    frame.fileWarning((Warning)new InvalidPagenameWarning(WikitextWarning.WarningSeverity.NORMAL, this.getClass(), titleNode, titleStr));
                    return pfn;
                }
                catch (UnsupportedEncodingException e2) {
                    frame.fileWarning((Warning)new InvalidNameWarning(WikitextWarning.WarningSeverity.NORMAL, this.getClass(), titleNode));
                    return pfn;
                }
            }
            String queryStr = null;
            if (argsValues.size() >= 2) {
                WtNode queryNode = argsValues.get(1);
                try {
                    queryStr = this.tu().astToText(queryNode);
                }
                catch (StringConversionException e) {
                    frame.fileWarning((Warning)new InvalidNameWarning(WikitextWarning.WarningSeverity.NORMAL, this.getClass(), queryNode));
                }
            }
            if ((ns = title.getNamespace()).isMediaNs()) {
                title = title.newWithNamespace(frame.getWikiConfig().getFileNamespace());
            }
            try {
                titleUrl = title.getUrl(queryStr);
            }
            catch (MalformedURLException e) {
                titleUrl = title.getUrl();
                frame.fileWarning((Warning)new InvalidNameWarning(WikitextWarning.WarningSeverity.NORMAL, this.getClass(), (WtNode)pfn));
            }
            URL url = frame.getUrlService().convertUrl(UrlType.FULL, titleUrl);
            return this.nf().text(url.toExternalForm());
        }
    }
}

