/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.core;

import java.util.Calendar;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.config.ParserFunctionGroup;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.core.CorePfnVariable;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;

public class CorePfnVariablesDateAndTime
extends ParserFunctionGroup {
    private static final long serialVersionUID = 1L;

    protected CorePfnVariablesDateAndTime(WikiConfig wikiConfig) {
        super("Core - Variables - Date and Time");
        this.addParserFunction(new CurrentYearPfn(wikiConfig));
        this.addParserFunction(new CurrentMonthPfn(wikiConfig));
        this.addParserFunction(new CurrentDayPfn(wikiConfig));
    }

    public static CorePfnVariablesDateAndTime group(WikiConfig wikiConfig) {
        return new CorePfnVariablesDateAndTime(wikiConfig);
    }

    public static final class CurrentDayPfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public CurrentDayPfn() {
            super("currentday");
        }

        public CurrentDayPfn(WikiConfig wikiConfig) {
            super(wikiConfig, "currentday");
        }

        @Override
        protected final WtNode invoke(WtTemplate var, ExpansionFrame frame) {
            Calendar cal = this.getWikiConfig().getRuntimeInfo().getDateAndTime();
            return this.nf().text(String.valueOf(cal.get(5)));
        }
    }

    public static final class CurrentMonthPfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public CurrentMonthPfn() {
            super("currentmonth");
        }

        public CurrentMonthPfn(WikiConfig wikiConfig) {
            super(wikiConfig, "currentmonth");
        }

        @Override
        protected final WtNode invoke(WtTemplate var, ExpansionFrame frame) {
            Calendar cal = this.getWikiConfig().getRuntimeInfo().getDateAndTime();
            return this.nf().text(String.format("%02d", cal.get(2) + 1));
        }
    }

    public static final class CurrentYearPfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public CurrentYearPfn() {
            super("currentyear");
        }

        public CurrentYearPfn(WikiConfig wikiConfig) {
            super(wikiConfig, "currentyear");
        }

        @Override
        protected final WtNode invoke(WtTemplate var, ExpansionFrame frame) {
            Calendar cal = this.getWikiConfig().getRuntimeInfo().getDateAndTime();
            return this.nf().text(String.valueOf(cal.get(1)));
        }
    }
}

