/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.core;

import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.PfnArgumentMode;
import org.sweble.wikitext.engine.config.Namespace;
import org.sweble.wikitext.engine.config.ParserFunctionGroup;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.core.CorePfnVariable;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class CorePfnVariablesNamespaces
extends ParserFunctionGroup {
    private static final long serialVersionUID = 1L;

    protected CorePfnVariablesNamespaces(WikiConfig wikiConfig) {
        super("Core - Variables - Namespaces");
        this.addParserFunction(new NamespacePfn(wikiConfig));
        this.addParserFunction(new TalkspacePfn(wikiConfig));
        this.addParserFunction(new SubjectspacePfn(wikiConfig));
    }

    public static CorePfnVariablesNamespaces group(WikiConfig wikiConfig) {
        return new CorePfnVariablesNamespaces(wikiConfig);
    }

    public static final class TalkspacePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public TalkspacePfn() {
            super("talkspace");
        }

        public TalkspacePfn(WikiConfig wikiConfig) {
            super(wikiConfig, "talkspace");
        }

        @Override
        protected final WtNode invoke(WtTemplate var, ExpansionFrame frame) {
            PageTitle title = frame.getRootFrame().getTitle();
            Namespace talkNs = frame.getWikiConfig().getTalkNamespaceFor(title.getNamespace());
            return this.nf().text(talkNs.getName());
        }
    }

    public static final class SubjectspacePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public SubjectspacePfn() {
            super("subjectspace");
        }

        public SubjectspacePfn(WikiConfig wikiConfig) {
            super(wikiConfig, "subjectspace");
        }

        @Override
        protected final WtNode invoke(WtTemplate var, ExpansionFrame frame) {
            PageTitle title = frame.getRootFrame().getTitle();
            Namespace talkNs = frame.getWikiConfig().getSubjectNamespaceFor(title.getNamespace());
            return this.nf().text(talkNs.getName());
        }
    }

    public static final class NamespacePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public NamespacePfn() {
            super(PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "namespace");
        }

        public NamespacePfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "namespace");
        }

        @Override
        public WtNode invoke(WtTemplate var, ExpansionFrame frame, List<? extends WtNode> argsValues) {
            PageTitle title;
            if (argsValues.size() > 0) {
                WtNode titleNode = argsValues.get(0);
                try {
                    String titleStr = this.tu().astToText(titleNode);
                    title = PageTitle.make(frame.getWikiConfig(), titleStr);
                }
                catch (StringConversionException e) {
                    return var;
                }
                catch (LinkTargetException e) {
                    return var;
                }
            } else {
                title = frame.getRootFrame().getTitle();
            }
            return this.nf().text(title.getNamespace().getName());
        }
    }
}

