/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.core;

import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.PfnArgumentMode;
import org.sweble.wikitext.engine.config.ParserFunctionGroup;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.core.CorePfnVariable;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;

public class CorePfnVariablesTechnicalMetadata
extends ParserFunctionGroup {
    private static final long serialVersionUID = 1L;

    protected CorePfnVariablesTechnicalMetadata(WikiConfig wikiConfig) {
        super("Core - Variables - Technical Metadata");
        this.addParserFunction(new SitenamePfn(wikiConfig));
        this.addParserFunction(new ContentLanguagePfn(wikiConfig));
        this.addParserFunction(new ProtectionLevelPfn(wikiConfig));
        this.addParserFunction(new DefaultsortPfn(wikiConfig));
    }

    public static CorePfnVariablesTechnicalMetadata group(WikiConfig wikiConfig) {
        return new CorePfnVariablesTechnicalMetadata(wikiConfig);
    }

    public static final class DefaultsortPfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public DefaultsortPfn() {
            super(PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "defaultsort");
        }

        public DefaultsortPfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "defaultsort");
        }

        @Override
        public WtNode invoke(WtTemplate var, ExpansionFrame frame, List<? extends WtNode> args) {
            return this.nf().list();
        }
    }

    public static final class ProtectionLevelPfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public ProtectionLevelPfn() {
            super(PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "protectionlevel");
        }

        public ProtectionLevelPfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "protectionlevel");
        }

        @Override
        public WtNode invoke(WtTemplate var, ExpansionFrame frame, List<? extends WtNode> args) {
            return this.nf().list();
        }
    }

    public static final class ContentLanguagePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public ContentLanguagePfn() {
            super("contentlanguage");
        }

        public ContentLanguagePfn(WikiConfig wikiConfig) {
            super(wikiConfig, "contentlanguage");
        }

        @Override
        public WtNode invoke(WtTemplate var, ExpansionFrame frame, List<? extends WtNode> args) {
            return this.nf().text(frame.getWikiConfig().getContentLanguage());
        }
    }

    public static final class SitenamePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public SitenamePfn() {
            super("sitename");
        }

        public SitenamePfn(WikiConfig wikiConfig) {
            super(wikiConfig, "sitename");
        }

        @Override
        public WtNode invoke(WtTemplate var, ExpansionFrame frame, List<? extends WtNode> args) {
            return this.nf().text(frame.getWikiConfig().getSiteName());
        }
    }
}

