/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.parser_functions;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ExprParser {
    private static final int maxStackSize = 100;
    private static final Map<String, Token> TOKENS = new HashMap<String, Token>();
    private final Stack<Double> operands = new Stack();
    private final Stack<Token> operators = new Stack();
    private Production expecting;

    public String parse(String expr) throws ExprError {
        this.operands.clear();
        this.operators.clear();
        this.expecting = Production.EXPR;
        int i = 0;
        expr = this.unescape(expr);
        block9: while (i < expr.length()) {
            if (this.operands.size() > 100 || this.operators.size() > 100) {
                throw new ExprError("operands_exhausted");
            }
            char ch = expr.charAt(i);
            if (this.isWs(ch)) {
                i = this.skipWs(expr, i);
                continue;
            }
            if (this.isNumberChar(ch)) {
                this.expect(Production.EXPR, "unexpected_number");
                i = this.pushOperand(expr, i);
                this.expecting = Production.OPERATOR;
                continue;
            }
            String word = null;
            Token token = null;
            if (this.isAlphaChar(ch)) {
                word = this.parseWordToken(expr, i).toLowerCase();
                token = TOKENS.get(word);
            } else {
                if (i + 1 < expr.length()) {
                    word = expr.substring(i, i + 2);
                    token = TOKENS.get(word);
                }
                if (token == null) {
                    word = "" + ch;
                    token = TOKENS.get(word);
                }
            }
            if (token == null) {
                throw new ExprError("Unrecognised word \"%s\".", word);
            }
            i += word.length();
            switch (token) {
                case E: {
                    if (this.expecting == Production.OPERATOR) {
                        this.processBinaryOp(Token.SCIENTIFIC, word);
                        continue block9;
                    }
                }
                case PI: {
                    if (this.expecting != Production.EXPR) continue block9;
                    token.apply(this.operands);
                    this.expecting = Production.OPERATOR;
                    continue block9;
                }
                case NOT: 
                case SINE: 
                case COSINE: 
                case TANGENS: 
                case ARCSINE: 
                case ARCCOS: 
                case ARCTAN: 
                case EXP: 
                case LN: 
                case ABS: 
                case FLOOR: 
                case TRUNC: 
                case CEIL: {
                    this.expect(Production.EXPR, "unexpected_operator", word);
                    this.operators.push(token);
                    continue block9;
                }
                case PLUS: 
                case MINUS: {
                    if (this.expecting == Production.EXPR) {
                        this.operators.push(token == Token.PLUS ? Token.POS : Token.NEG);
                        continue block9;
                    }
                    this.processBinaryOp(token, word);
                    continue block9;
                }
                case EQ: 
                case NEQ: 
                case LE: 
                case GR: 
                case LEQ: 
                case GEQ: 
                case TIMES: 
                case DIVIDE: 
                case MOD: 
                case POW: 
                case ROUND: 
                case AND: 
                case OR: {
                    this.processBinaryOp(token, word);
                    continue block9;
                }
                case LPAREN: {
                    this.expect(Production.EXPR, "unexpected_operator", word);
                    this.operators.push(token);
                    continue block9;
                }
                case RPAREN: {
                    Token lastOp = null;
                    while (!this.operators.isEmpty() && (lastOp = this.operators.peek()) != Token.LPAREN) {
                        lastOp.apply(this.operands);
                        this.operators.pop();
                    }
                    if (lastOp != Token.LPAREN) {
                        throw new ExprError("unexpected_closing_bracket");
                    }
                    this.operators.pop();
                    this.expecting = Production.OPERATOR;
                    continue block9;
                }
            }
            throw new AssertionError();
        }
        while (!this.operators.isEmpty()) {
            Token op = this.operators.pop();
            if (op == Token.LPAREN) {
                throw new ExprError("unclosed_bracket");
            }
            op.apply(this.operands);
        }
        return this.implode("<br />\n", this.operands);
    }

    private String unescape(String expr) {
        expr = expr.replace("&lt;", "<");
        expr = expr.replace("&gt;", ">");
        expr = expr.replace("&minus;", "-");
        expr = expr.replace("\u2212", "-");
        return expr;
    }

    private boolean isWs(char ch) {
        return Character.isWhitespace(ch);
    }

    private int skipWs(String expr, int i) {
        int j;
        for (j = i + 1; j < expr.length() && this.isWs(expr.charAt(j)); ++j) {
        }
        return j;
    }

    private boolean isNumberChar(char ch) {
        return ch == '.' || Character.isDigit(ch);
    }

    private int pushOperand(String expr, int i) {
        char ch;
        int j;
        for (j = i + 1; j < expr.length() && this.isNumberChar(ch = expr.charAt(j)); ++j) {
        }
        try {
            this.operands.push(Double.parseDouble(expr.substring(i, j)));
        }
        catch (NumberFormatException e) {
            this.operands.push(0.0);
        }
        return j;
    }

    private boolean isAlphaChar(char ch) {
        return Character.isLetter(ch);
    }

    private String parseWordToken(String expr, int i) {
        char chx;
        int j;
        for (j = i + 1; j < expr.length() && this.isAlphaChar(chx = expr.charAt(j)); ++j) {
        }
        return expr.substring(i, j);
    }

    private void expect(Production p, String msg) throws ExprError {
        if (this.expecting != p) {
            throw new ExprError(msg);
        }
    }

    private void expect(Production p, String msg, String word) throws ExprError {
        if (this.expecting != p) {
            throw new ExprError(msg, word);
        }
    }

    private void processBinaryOp(Token op, String word) throws ExprError {
        this.expect(Production.OPERATOR, "unexpected_operator", word);
        while (!this.operators.isEmpty()) {
            Token lastOp = this.operators.peek();
            if (op.getPrecedence() > lastOp.getPrecedence()) break;
            lastOp.apply(this.operands);
            this.operators.pop();
        }
        this.operators.push(op);
        this.expecting = Production.EXPR;
    }

    private String implode(String serparator, Stack<Double> operands) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < operands.size()) {
            double result = (Double)operands.get(i);
            if ((double)((int)result) == result) {
                b.append((int)result);
            } else {
                b.append(result);
            }
            if (++i >= operands.size()) continue;
            b.append(serparator);
        }
        return b.toString();
    }

    static {
        TOKENS.put("(", Token.LPAREN);
        TOKENS.put(")", Token.RPAREN);
        TOKENS.put("!=", Token.NEQ);
        TOKENS.put("*", Token.TIMES);
        TOKENS.put("+", Token.PLUS);
        TOKENS.put("-", Token.MINUS);
        TOKENS.put("/", Token.DIVIDE);
        TOKENS.put("<", Token.LE);
        TOKENS.put("<=", Token.LEQ);
        TOKENS.put("<>", Token.NEQ);
        TOKENS.put("=", Token.EQ);
        TOKENS.put(">", Token.GR);
        TOKENS.put(">=", Token.GEQ);
        TOKENS.put("^", Token.POW);
        TOKENS.put("abs", Token.ABS);
        TOKENS.put("acos", Token.ARCCOS);
        TOKENS.put("and", Token.AND);
        TOKENS.put("asin", Token.ARCSINE);
        TOKENS.put("atan", Token.ARCTAN);
        TOKENS.put("ceil", Token.CEIL);
        TOKENS.put("cos", Token.COSINE);
        TOKENS.put("div", Token.DIVIDE);
        TOKENS.put("e", Token.E);
        TOKENS.put("exp", Token.EXP);
        TOKENS.put("floor", Token.FLOOR);
        TOKENS.put("ln", Token.LN);
        TOKENS.put("mod", Token.MOD);
        TOKENS.put("not", Token.NOT);
        TOKENS.put("or", Token.OR);
        TOKENS.put("pi", Token.PI);
        TOKENS.put("round", Token.ROUND);
        TOKENS.put("sin", Token.SINE);
        TOKENS.put("tan", Token.TANGENS);
        TOKENS.put("trunc", Token.TRUNC);
    }

    private static enum Token {
        E(-1, "e"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                operands.push(Math.E);
            }
        }
        ,
        PI(-1, "pi"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                operands.push(Math.PI);
            }
        }
        ,
        SCIENTIFIC(10, "e"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left * Math.pow(10.0, right));
            }
        }
        ,
        POS(10, "+"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
            }
        }
        ,
        NEG(10, "-"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                operands.push(-arg);
            }
        }
        ,
        NOT(9, "not"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                operands.push(arg == 0.0 ? 1.0 : 0.0);
            }
        }
        ,
        SINE(9, "sin"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                operands.push(Math.sin(arg));
            }
        }
        ,
        COSINE(9, "cos"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                operands.push(Math.cos(arg));
            }
        }
        ,
        TANGENS(9, "tan"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                operands.push(Math.tan(arg));
            }
        }
        ,
        ARCSINE(9, "asin"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                if (arg < -1.0 || arg > 1.0) {
                    throw new ExprError("invalid_argument", this.toString());
                }
                operands.push(Math.asin(arg));
            }
        }
        ,
        ARCCOS(9, "acos"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                if (arg < -1.0 || arg > 1.0) {
                    throw new ExprError("invalid_argument", this.toString());
                }
                operands.push(Math.acos(arg));
            }
        }
        ,
        ARCTAN(9, "atan"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                operands.push(Math.atan(arg));
            }
        }
        ,
        EXP(9, "exp"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                operands.push(Math.exp(arg));
            }
        }
        ,
        LN(9, "ln"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                if (arg <= 0.0) {
                    throw new ExprError("invalid_argument_ln", this.toString());
                }
                operands.push(Math.log(arg));
            }
        }
        ,
        ABS(9, "abs"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                operands.push(Math.abs(arg));
            }
        }
        ,
        FLOOR(9, "floor"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                operands.push(Math.floor(arg));
            }
        }
        ,
        TRUNC(9, "trunc"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                operands.push(Double.valueOf((int)arg));
            }
        }
        ,
        CEIL(9, "ceil"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireOneOp((Token)this, operands);
                double arg = operands.pop();
                operands.push(Math.ceil(arg));
            }
        }
        ,
        POW(8, "^"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                double result = Math.pow(left, right);
                if (Double.isNaN(result)) {
                    throw new ExprError("division_by_zero", this.toString());
                }
                operands.push(result);
            }
        }
        ,
        TIMES(7, "*"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left * right);
            }
        }
        ,
        DIVIDE(7, "/"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                if (right == 0.0) {
                    throw new ExprError("division_by_zero", this.toString());
                }
                operands.push(left / right);
            }
        }
        ,
        MOD(7, "mod"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                if (right == 0.0) {
                    throw new ExprError("division_by_zero", this.toString());
                }
                operands.push(left % right);
            }
        }
        ,
        PLUS(6, "+"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left + right);
            }
        }
        ,
        MINUS(6, "-"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left - right);
            }
        }
        ,
        ROUND(5, "round"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                int digits = (int)operands.pop().doubleValue();
                double value = operands.pop();
                value = Token.round(value, digits);
                operands.push(value);
            }
        }
        ,
        EQ(4, "="){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left == right ? 1.0 : 0.0);
            }
        }
        ,
        NEQ(4, "!="){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left != right ? 1.0 : 0.0);
            }
        }
        ,
        LE(4, "<"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left < right ? 1.0 : 0.0);
            }
        }
        ,
        GR(4, ">"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left > right ? 1.0 : 0.0);
            }
        }
        ,
        LEQ(4, "<="){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left <= right ? 1.0 : 0.0);
            }
        }
        ,
        GEQ(4, ">="){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left >= right ? 1.0 : 0.0);
            }
        }
        ,
        AND(3, "and"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left != 0.0 && right != 0.0 ? 1.0 : 0.0);
            }
        }
        ,
        OR(2, "or"){

            @Override
            public void apply(Stack<Double> operands) throws ExprError {
                Token.requireTwoOps((Token)this, operands);
                double right = operands.pop();
                double left = operands.pop();
                operands.push(left != 0.0 || right != 0.0 ? 1.0 : 0.0);
            }
        }
        ,
        LPAREN(-1, "("){

            @Override
            public void apply(Stack<Double> operands) {
                throw new AssertionError();
            }
        }
        ,
        RPAREN(-1, ")"){

            @Override
            public void apply(Stack<Double> operands) {
                throw new AssertionError();
            }
        };

        private final int precedence;
        private final String name;

        private Token(int precedence, String name) {
            this.name = name;
            this.precedence = precedence;
        }

        public abstract void apply(Stack<Double> var1) throws ExprError;

        public int getPrecedence() {
            return this.precedence;
        }

        public String toString() {
            return this.name;
        }

        private static void requireOneOp(Token op, Stack<Double> operands) throws ExprError {
            if (operands.isEmpty()) {
                throw new ExprError("Missing operand for %s.", op.toString());
            }
        }

        private static void requireTwoOps(Token op, Stack<Double> operands) throws ExprError {
            if (operands.size() < 2) {
                throw new ExprError("Missing operand for %s.", op.toString());
            }
        }

        private static double round(double value, int digits) {
            return new BigDecimal(value).setScale(digits, 4).doubleValue();
        }
    }

    private static enum Production {
        EXPR,
        OPERATOR;

    }

    public static final class ExprError
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String param;

        public ExprError(String message) {
            this(message, (String)null);
        }

        public ExprError(String message, String param) {
            super(ExprError.makeMessage(message, param));
            this.param = param;
        }

        private static String makeMessage(String message, String param) {
            String msg = message;
            if (param != null) {
                msg = String.format(message, param);
            }
            return "Expression error: " + msg;
        }

        public String getParam() {
            return this.param;
        }
    }
}

