/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.parser_functions;

import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.parser_functions.ExprParser;
import org.sweble.wikitext.engine.ext.parser_functions.ParserFunctionsExtPfn;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class ParserFunctionIfExpr
extends ParserFunctionsExtPfn.IfThenElseStmt {
    private static final long serialVersionUID = 1L;

    public ParserFunctionIfExpr() {
        super("ifexpr", 1);
    }

    public ParserFunctionIfExpr(WikiConfig wikiConfig) {
        super(wikiConfig, "ifexpr", 1);
    }

    @Override
    protected boolean evaluateCondition(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
        String result;
        WtNode test = frame.expand(args.get(0));
        String expr = null;
        try {
            expr = this.tu().astToText(test).trim();
        }
        catch (StringConversionException e) {
            return false;
        }
        if (expr.isEmpty()) {
            return false;
        }
        ExprParser p = new ExprParser();
        try {
            result = p.parse(expr);
        }
        catch (ExprParser.ExprError e) {
            return false;
        }
        if (result == null || result.isEmpty()) {
            return false;
        }
        return Double.parseDouble(result) != 0.0;
    }
}

