/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.parser_functions;

import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.parser_functions.ParserFunctionsExtPfn;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class ParserFunctionIfeq
extends ParserFunctionsExtPfn.IfThenElseStmt {
    private static final long serialVersionUID = 1L;

    public ParserFunctionIfeq() {
        super("ifeq", 2);
    }

    public ParserFunctionIfeq(WikiConfig wikiConfig) {
        super(wikiConfig, "ifeq", 2);
    }

    @Override
    protected boolean evaluateCondition(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
        WtNode arg0 = frame.expand(args.get(0));
        WtNode arg1 = frame.expand(args.get(1));
        String a = null;
        String b = null;
        try {
            a = this.tu().astToText(arg0).trim();
            b = this.tu().astToText(arg1).trim();
        }
        catch (StringConversionException stringConversionException) {
            // empty catch block
        }
        boolean eval = false;
        if (a != null && b != null) {
            boolean numbers = false;
            double ia = -1.0;
            double ib = 1.0;
            try {
                ia = Double.parseDouble(a);
                ib = Double.parseDouble(b);
                numbers = true;
            }
            catch (NumberFormatException e) {
                numbers = false;
            }
            eval = numbers ? ia == ib : a.equals(b);
        }
        return eval;
    }
}

