/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.parser_functions;

import de.fau.cs.osr.utils.StringTools;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.parser_functions.ParserFunctionsExtPfn;
import org.sweble.wikitext.engine.nodes.EngSoftErrorNode;
import org.sweble.wikitext.engine.nodes.EngineRtData;
import org.sweble.wikitext.engine.utils.StringToDateTimeConverter;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class ParserFunctionTime
extends ParserFunctionsExtPfn {
    private static final long serialVersionUID = 1L;

    public ParserFunctionTime() {
        super("time");
    }

    public ParserFunctionTime(WikiConfig wikiConfig) {
        super(wikiConfig, "time");
    }

    @Override
    public WtNode invoke(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
        if (args.size() < 1) {
            return pfn;
        }
        String format = this.expandArgToString(frame, args, 0);
        if (format == null) {
            return this.error("Cannot convert format argument to string!");
        }
        String languageTag = null;
        if (args.size() >= 3 && (languageTag = this.expandArgToString(frame, args, 2)) == null) {
            return this.error("Cannot convert language argument to string!");
        }
        Locale locale = null;
        if (languageTag != null && !languageTag.isEmpty() && (locale = Locale.forLanguageTag(languageTag)) == null) {
            return this.notYetImplemented("Cannot handle non-empty language argument!");
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"), locale);
        timestamp.set(16, 0);
        if (args.size() >= 2) {
            String timestampStr = this.expandArgToString(frame, args, 1);
            if (timestampStr == null) {
                return this.error("Cannot convert timestamp argument to string!");
            }
            if (!timestampStr.isEmpty()) {
                StringToDateTimeConverter conv = new StringToDateTimeConverter();
                Date argumentDate = conv.convertString(timestampStr);
                if (argumentDate != null) {
                    timestamp.setTime(argumentDate);
                } else {
                    return this.notYetImplemented("Cannot handle non-empty timestamp argument!");
                }
            }
        }
        return this.nf().text(ParserFunctionTime.format(format, timestamp, locale));
    }

    protected static String format(String format, Calendar timestamp, Locale locale) {
        StringBuilder sb = new StringBuilder();
        boolean isCharInComment = false;
        block35: for (int i = 0; i < format.length(); ++i) {
            char ch = format.charAt(i);
            if (ch == '\"') {
                isCharInComment = !isCharInComment;
                continue;
            }
            if (isCharInComment) {
                sb.append(ch);
                continue;
            }
            switch (ch) {
                case 'Y': {
                    sb.append(timestamp.get(1));
                    continue block35;
                }
                case 'y': {
                    sb.append(timestamp.get(1) % 100);
                    continue block35;
                }
                case 'L': {
                    GregorianCalendar gregCal = new GregorianCalendar(locale);
                    if (gregCal.isLeapYear(timestamp.get(1))) {
                        sb.append('1');
                        continue block35;
                    }
                    sb.append('0');
                    continue block35;
                }
                case 'n': {
                    sb.append(timestamp.get(2) + 1);
                    continue block35;
                }
                case 'm': {
                    int tmp = timestamp.get(2) + 1;
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp);
                    continue block35;
                }
                case 'M': {
                    sb.append(timestamp.getDisplayName(2, 1, locale));
                    continue block35;
                }
                case 'F': {
                    sb.append(timestamp.getDisplayName(2, 2, locale));
                    continue block35;
                }
                case 'W': {
                    int tmp = timestamp.get(3);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp);
                    continue block35;
                }
                case 'j': {
                    sb.append(timestamp.get(5));
                    continue block35;
                }
                case 'd': {
                    int tmp = timestamp.get(5);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp);
                    continue block35;
                }
                case 'z': {
                    sb.append(timestamp.get(6) - 1);
                    continue block35;
                }
                case 'D': {
                    sb.append(timestamp.getDisplayName(7, 1, locale));
                    continue block35;
                }
                case 'l': {
                    sb.append(timestamp.getDisplayName(7, 2, locale));
                    continue block35;
                }
                case 'N': {
                    sb.append((timestamp.get(7) + 5) % 7 + 1);
                    continue block35;
                }
                case 'w': {
                    sb.append(timestamp.get(7) - 1);
                    continue block35;
                }
                case 'a': {
                    if (timestamp.get(9) == 0) {
                        sb.append("am");
                        continue block35;
                    }
                    sb.append("pm");
                    continue block35;
                }
                case 'A': {
                    if (timestamp.get(9) == 0) {
                        sb.append("AM");
                        continue block35;
                    }
                    sb.append("PM");
                    continue block35;
                }
                case 'g': {
                    sb.append(timestamp.get(10));
                    continue block35;
                }
                case 'h': {
                    int tmp = timestamp.get(10);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp);
                    continue block35;
                }
                case 'G': {
                    sb.append(timestamp.get(11));
                    continue block35;
                }
                case 'H': {
                    int tmp = timestamp.get(11);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp);
                    continue block35;
                }
                case 'i': {
                    int tmp = timestamp.get(12);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp);
                    continue block35;
                }
                case 's': {
                    int tmp = timestamp.get(13);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp);
                    continue block35;
                }
                case 'U': {
                    long timeUtc = timestamp.getTimeInMillis();
                    timeUtc += (long)timestamp.getTimeZone().getOffset(timeUtc);
                    sb.append(timeUtc / 1000L);
                    continue block35;
                }
                case 'e': {
                    sb.append(timestamp.getTimeZone().getID());
                    continue block35;
                }
                case 'I': {
                    sb.append(timestamp.get(16) != 0 ? (char)'1' : '0');
                    continue block35;
                }
                case 'O': {
                    sb.append(ParserFunctionTime.localOffsetAsString(timestamp));
                    continue block35;
                }
                case 'P': {
                    sb.append(ParserFunctionTime.localOffsetAsStringWithColon(timestamp));
                    continue block35;
                }
                case 'Z': {
                    sb.append((long)timestamp.getTimeZone().getOffset(timestamp.getTimeInMillis()) / 1000L);
                    continue block35;
                }
                case 'T': {
                    sb.append(timestamp.getTimeZone().getID());
                    continue block35;
                }
                case 't': {
                    sb.append(timestamp.getActualMaximum(5));
                    continue block35;
                }
                case 'c': {
                    sb.append(timestamp.get(1)).append('-');
                    int tmp = timestamp.get(2) + 1;
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp).append('-');
                    tmp = timestamp.get(5);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp).append('T');
                    tmp = timestamp.get(11);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp).append(':');
                    tmp = timestamp.get(12);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp).append(':');
                    tmp = timestamp.get(13);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp).append(ParserFunctionTime.localOffsetAsStringWithColon(timestamp));
                    continue block35;
                }
                case 'r': {
                    sb.append(timestamp.getDisplayName(7, 1, Locale.US)).append(", ").append(timestamp.get(5)).append(' ').append(timestamp.getDisplayName(2, 1, Locale.US)).append(' ').append(timestamp.get(1)).append(' ');
                    int tmp = timestamp.get(11);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp).append(':');
                    tmp = timestamp.get(12);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp).append(':');
                    tmp = timestamp.get(13);
                    if (tmp < 10) {
                        sb.append('0');
                    }
                    sb.append(tmp).append(' ').append(ParserFunctionTime.localOffsetAsString(timestamp));
                    continue block35;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static String localOffsetAsString(Calendar timestamp) {
        StringBuilder sb = new StringBuilder();
        int offset = timestamp.getTimeZone().getOffset(timestamp.getTimeInMillis());
        offset = offset / 1000 / 60;
        int hours = offset / 60;
        int minutes = offset % 60;
        if (offset < 0) {
            sb.append('-');
        } else {
            sb.append('+');
        }
        hours = Math.abs(hours);
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        minutes = Math.abs(minutes);
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        return sb.toString();
    }

    private static String localOffsetAsStringWithColon(Calendar timestamp) {
        StringBuilder sb = new StringBuilder();
        int offset = timestamp.getTimeZone().getOffset(timestamp.getTimeInMillis());
        offset = offset / 1000 / 60;
        int hours = offset / 60;
        int minutes = offset % 60;
        if (offset < 0) {
            sb.append('-');
        } else {
            sb.append('+');
        }
        hours = Math.abs(hours);
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours).append(':');
        minutes = Math.abs(minutes);
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        return sb.toString();
    }

    private String expandArgToString(ExpansionFrame preprocessorFrame, List<? extends WtNode> args, int index) {
        WtNode arg = preprocessorFrame.expand(args.get(index));
        this.tu().trim(arg);
        String format = null;
        try {
            format = this.tu().astToText(arg).trim();
        }
        catch (StringConversionException stringConversionException) {
            // empty catch block
        }
        return format;
    }

    private EngSoftErrorNode error(String msg) {
        return EngineRtData.set(this.nf().softError(EngineRtData.set(this.nf().nowiki(StringTools.escHtml((String)msg)))));
    }

    private EngSoftErrorNode notYetImplemented(String msg) {
        return this.nf().addCssClass(EngineRtData.set(this.nf().softError(EngineRtData.set(this.nf().nowiki(StringTools.escHtml((String)msg))))), "not-yet-implemented");
    }
}

