/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.parser_functions;

import de.fau.cs.osr.utils.StringTools;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.parser_functions.ParserFunctionTime;
import org.sweble.wikitext.engine.ext.parser_functions.ParserFunctionsExtPfn;
import org.sweble.wikitext.engine.nodes.EngSoftErrorNode;
import org.sweble.wikitext.engine.nodes.EngineRtData;
import org.sweble.wikitext.engine.utils.StringToDateTimeConverter;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class ParserFunctionTimeLocal
extends ParserFunctionsExtPfn {
    public ParserFunctionTimeLocal() {
        super("timel");
    }

    public ParserFunctionTimeLocal(WikiConfig wikiConfig) {
        super(wikiConfig, "timel");
    }

    @Override
    public WtNode invoke(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
        if (args.size() < 1) {
            return pfn;
        }
        String format = this.expandArgToString(frame, args, 0);
        if (format == null) {
            return this.error("Cannot convert format argument to string!");
        }
        String languageTag = null;
        if (args.size() >= 3 && (languageTag = this.expandArgToString(frame, args, 2)) == null) {
            return this.error("Cannot convert language argument to string!");
        }
        Locale locale = null;
        if (languageTag != null && !languageTag.isEmpty() && (locale = Locale.forLanguageTag(languageTag)) == null) {
            return this.notYetImplemented("Cannot handle non-empty language argument!");
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        Calendar timestamp = this.getWikiConfig().getRuntimeInfo().getDateAndTime(locale);
        if (args.size() >= 2) {
            String timestampStr = this.expandArgToString(frame, args, 1);
            if (timestampStr == null) {
                return this.error("Cannot convert timestamp argument to string!");
            }
            if (!timestampStr.isEmpty()) {
                StringToDateTimeConverter conv = new StringToDateTimeConverter(timestamp);
                Date argumentDate = conv.convertString(timestampStr);
                if (argumentDate != null) {
                    timestamp.setTime(argumentDate);
                } else {
                    return this.notYetImplemented("Cannot handle non-empty timestamp argument!");
                }
            }
        }
        return this.nf().text(ParserFunctionTime.format(format, timestamp, locale));
    }

    private String expandArgToString(ExpansionFrame preprocessorFrame, List<? extends WtNode> args, int index) {
        WtNode arg = preprocessorFrame.expand(args.get(index));
        this.tu().trim(arg);
        String format = null;
        try {
            format = this.tu().astToText(arg).trim();
        }
        catch (StringConversionException stringConversionException) {
            // empty catch block
        }
        return format;
    }

    private EngSoftErrorNode error(String msg) {
        return EngineRtData.set(this.nf().softError(EngineRtData.set(this.nf().nowiki(StringTools.escHtml((String)msg)))));
    }

    private EngSoftErrorNode notYetImplemented(String msg) {
        return this.nf().addCssClass(EngineRtData.set(this.nf().softError(EngineRtData.set(this.nf().nowiki(StringTools.escHtml((String)msg))))), "not-yet-implemented");
    }
}

