/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.parser_functions;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.parser_functions.ParserFunctionsExtPfn;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class ParserFunctionTitleparts
extends ParserFunctionsExtPfn {
    private static final long serialVersionUID = 1L;

    public ParserFunctionTitleparts() {
        super("titleparts");
    }

    public ParserFunctionTitleparts(WikiConfig wikiConfig) {
        super(wikiConfig, "titleparts");
    }

    @Override
    public WtNode invoke(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
        PageTitle pageTitle;
        if (args.size() < 1) {
            return pfn;
        }
        WtNode arg0 = frame.expand(args.get(0));
        if (args.size() < 2) {
            return arg0;
        }
        Integer partCount = null;
        Integer firstPart = null;
        try {
            String titleStr = this.tu().astToText(arg0).trim();
            pageTitle = PageTitle.make(frame.getWikiConfig(), titleStr);
            WtNode arg1 = frame.expand(args.get(1));
            String countStr = this.tu().astToText(arg1).trim();
            try {
                partCount = Integer.parseInt(countStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (args.size() > 2) {
                WtNode arg2 = frame.expand(args.get(2));
                String firstStr = this.tu().astToText(arg2).trim();
                try {
                    firstPart = Integer.parseInt(firstStr);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (StringConversionException ee) {
            return pfn;
        }
        catch (LinkTargetException e) {
            return pfn;
        }
        String title = pageTitle.getTitle();
        String[] parts = title.split("/", 25);
        if (partCount != null) {
            if (partCount < 0) {
                partCount = parts.length + partCount;
            } else if (partCount == 0) {
                partCount = parts.length;
            }
            if (partCount <= 0) {
                return this.nf().text("");
            }
        } else {
            partCount = parts.length;
        }
        if (firstPart != null) {
            if (firstPart > parts.length) {
                return this.nf().text("");
            }
            if (firstPart < 0) {
                firstPart = parts.length + firstPart;
            }
            if (firstPart <= 0) {
                firstPart = 1;
            }
        } else {
            firstPart = 1;
        }
        int from = firstPart - 1;
        int to = Math.min(from + partCount, parts.length);
        String newTitle = StringUtils.join((Object[])Arrays.copyOfRange(parts, from, to), (String)"/");
        return this.nf().text(pageTitle.newWithTitle(newTitle).getDenormalizedFullTitle());
    }
}

