/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.parser_functions;

import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.ParserFunctionBase;
import org.sweble.wikitext.engine.PfnArgumentMode;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;

public abstract class ParserFunctionsExtPfn
extends ParserFunctionBase {
    private static final long serialVersionUID = 1L;

    public ParserFunctionsExtPfn(String name) {
        super(name);
    }

    public ParserFunctionsExtPfn(PfnArgumentMode argMode, String name) {
        super(argMode, name);
    }

    public ParserFunctionsExtPfn(WikiConfig wikiConfig, String name) {
        super(wikiConfig, name);
    }

    public ParserFunctionsExtPfn(WikiConfig wikiConfig, PfnArgumentMode argMode, String name) {
        super(wikiConfig, argMode, name);
    }

    @Override
    public final WtNode invoke(WtNode template, ExpansionFrame frame, List<? extends WtNode> argsValues) {
        return this.invoke((WtTemplate)template, frame, argsValues);
    }

    public abstract WtNode invoke(WtTemplate var1, ExpansionFrame var2, List<? extends WtNode> var3);

    public static abstract class IfThenElseStmt
    extends CtrlStmt {
        private static final long serialVersionUID = 1L;
        private final boolean hasDefault;
        private WtNode defaultValue;
        private final int thenArgIndex;

        protected IfThenElseStmt(String name, int thenArgIndex) {
            super(name);
            this.hasDefault = false;
            this.thenArgIndex = thenArgIndex;
        }

        protected IfThenElseStmt(String name, int thenArgIndex, boolean hasDefault) {
            super(name);
            this.hasDefault = hasDefault;
            this.thenArgIndex = thenArgIndex;
        }

        protected IfThenElseStmt(WikiConfig wikiConfig, String name, int thenArgIndex) {
            super(wikiConfig, name);
            this.hasDefault = false;
            this.thenArgIndex = thenArgIndex;
        }

        protected IfThenElseStmt(WikiConfig wikiConfig, String name, int thenArgIndex, boolean hasDefault) {
            super(wikiConfig, name);
            this.hasDefault = hasDefault;
            this.thenArgIndex = thenArgIndex;
        }

        @Override
        protected WtNode evaluate(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
            if (args.size() <= (this.hasDefault ? this.thenArgIndex - 1 : this.thenArgIndex)) {
                return this.nf().text("");
            }
            boolean cond = this.evaluateCondition(pfn, frame, args);
            WtNode result = this.defaultValue;
            if (cond) {
                if (args.size() > this.thenArgIndex) {
                    result = args.get(this.thenArgIndex);
                }
            } else {
                int elseArgIndex = this.thenArgIndex + 1;
                if (args.size() > elseArgIndex) {
                    result = args.get(elseArgIndex);
                }
            }
            return result;
        }

        protected void setDefault(WtNode defaultValue) {
            this.defaultValue = defaultValue;
        }

        protected abstract boolean evaluateCondition(WtTemplate var1, ExpansionFrame var2, List<? extends WtNode> var3);
    }

    public static abstract class CtrlStmt
    extends ParserFunctionsExtPfn {
        private static final long serialVersionUID = 1L;

        protected CtrlStmt(String name) {
            super(PfnArgumentMode.UNEXPANDED_VALUES, name);
        }

        protected CtrlStmt(WikiConfig wikiConfig, String name) {
            super(wikiConfig, PfnArgumentMode.UNEXPANDED_VALUES, name);
        }

        @Override
        public final WtNode invoke(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
            WtNode result = this.evaluate(pfn, frame, args);
            if (result != null) {
                return this.tu().trim(frame.expand(result));
            }
            return this.nf().text("");
        }

        protected abstract WtNode evaluate(WtTemplate var1, ExpansionFrame var2, List<? extends WtNode> var3);
    }
}

