/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.output;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.utils.FmtNotYetImplementedError;
import de.fau.cs.osr.utils.StringTools;
import de.fau.cs.osr.utils.visitor.VisitingException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.nodes.CompleteEngineVisitorNoReturn;
import org.sweble.wikitext.engine.nodes.EngNowiki;
import org.sweble.wikitext.engine.nodes.EngPage;
import org.sweble.wikitext.engine.nodes.EngProcessedPage;
import org.sweble.wikitext.engine.nodes.EngSoftErrorNode;
import org.sweble.wikitext.engine.nodes.EngineNodeFactory;
import org.sweble.wikitext.engine.output.HtmlRendererBase;
import org.sweble.wikitext.engine.output.HtmlRendererCallback;
import org.sweble.wikitext.engine.output.MediaInfo;
import org.sweble.wikitext.engine.output.SafeLinkTitlePrinter;
import org.sweble.wikitext.engine.utils.EngineAstTextUtils;
import org.sweble.wikitext.engine.utils.UrlEncoding;
import org.sweble.wikitext.parser.nodes.WtBody;
import org.sweble.wikitext.parser.nodes.WtBold;
import org.sweble.wikitext.parser.nodes.WtDefinitionList;
import org.sweble.wikitext.parser.nodes.WtDefinitionListDef;
import org.sweble.wikitext.parser.nodes.WtDefinitionListTerm;
import org.sweble.wikitext.parser.nodes.WtExternalLink;
import org.sweble.wikitext.parser.nodes.WtHeading;
import org.sweble.wikitext.parser.nodes.WtHorizontalRule;
import org.sweble.wikitext.parser.nodes.WtIgnored;
import org.sweble.wikitext.parser.nodes.WtIllegalCodePoint;
import org.sweble.wikitext.parser.nodes.WtImEndTag;
import org.sweble.wikitext.parser.nodes.WtImStartTag;
import org.sweble.wikitext.parser.nodes.WtImageLink;
import org.sweble.wikitext.parser.nodes.WtInternalLink;
import org.sweble.wikitext.parser.nodes.WtItalics;
import org.sweble.wikitext.parser.nodes.WtLinkOptionAltText;
import org.sweble.wikitext.parser.nodes.WtLinkOptionGarbage;
import org.sweble.wikitext.parser.nodes.WtLinkOptionKeyword;
import org.sweble.wikitext.parser.nodes.WtLinkOptionLinkTarget;
import org.sweble.wikitext.parser.nodes.WtLinkOptionResize;
import org.sweble.wikitext.parser.nodes.WtLinkOptions;
import org.sweble.wikitext.parser.nodes.WtLinkTitle;
import org.sweble.wikitext.parser.nodes.WtListItem;
import org.sweble.wikitext.parser.nodes.WtName;
import org.sweble.wikitext.parser.nodes.WtNewline;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtOnlyInclude;
import org.sweble.wikitext.parser.nodes.WtOrderedList;
import org.sweble.wikitext.parser.nodes.WtPageName;
import org.sweble.wikitext.parser.nodes.WtPageSwitch;
import org.sweble.wikitext.parser.nodes.WtParagraph;
import org.sweble.wikitext.parser.nodes.WtParsedWikitextPage;
import org.sweble.wikitext.parser.nodes.WtPreproWikitextPage;
import org.sweble.wikitext.parser.nodes.WtRedirect;
import org.sweble.wikitext.parser.nodes.WtSection;
import org.sweble.wikitext.parser.nodes.WtSemiPre;
import org.sweble.wikitext.parser.nodes.WtSemiPreLine;
import org.sweble.wikitext.parser.nodes.WtSignature;
import org.sweble.wikitext.parser.nodes.WtTable;
import org.sweble.wikitext.parser.nodes.WtTableCaption;
import org.sweble.wikitext.parser.nodes.WtTableCell;
import org.sweble.wikitext.parser.nodes.WtTableHeader;
import org.sweble.wikitext.parser.nodes.WtTableImplicitTableBody;
import org.sweble.wikitext.parser.nodes.WtTableRow;
import org.sweble.wikitext.parser.nodes.WtTagExtension;
import org.sweble.wikitext.parser.nodes.WtTagExtensionBody;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.nodes.WtTemplateArgument;
import org.sweble.wikitext.parser.nodes.WtTemplateArguments;
import org.sweble.wikitext.parser.nodes.WtTemplateParameter;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtTicks;
import org.sweble.wikitext.parser.nodes.WtUnorderedList;
import org.sweble.wikitext.parser.nodes.WtUrl;
import org.sweble.wikitext.parser.nodes.WtValue;
import org.sweble.wikitext.parser.nodes.WtWhitespace;
import org.sweble.wikitext.parser.nodes.WtXmlAttribute;
import org.sweble.wikitext.parser.nodes.WtXmlAttributeGarbage;
import org.sweble.wikitext.parser.nodes.WtXmlAttributes;
import org.sweble.wikitext.parser.nodes.WtXmlCharRef;
import org.sweble.wikitext.parser.nodes.WtXmlComment;
import org.sweble.wikitext.parser.nodes.WtXmlElement;
import org.sweble.wikitext.parser.nodes.WtXmlEmptyTag;
import org.sweble.wikitext.parser.nodes.WtXmlEndTag;
import org.sweble.wikitext.parser.nodes.WtXmlEntityRef;
import org.sweble.wikitext.parser.nodes.WtXmlStartTag;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.utils.StringConversionException;
import org.sweble.wikitext.parser.utils.WtRtDataPrinter;

public class HtmlRenderer
extends HtmlRendererBase
implements CompleteEngineVisitorNoReturn {
    private long untitledLinkCounter = 1L;
    protected static final Logger logger = LoggerFactory.getLogger(HtmlRenderer.class);
    protected static final Set<String> blockElements = new HashSet<String>();
    protected final WikiConfig wikiConfig;
    protected final PageTitle pageTitle;
    protected final EngineNodeFactory nf;
    protected final EngineAstTextUtils tu;
    protected final HtmlRendererCallback callback;
    protected int inPre = 0;

    protected WtNode before(WtNode node) {
        this.untitledLinkCounter = 1L;
        return (WtNode)super.before((Object)node);
    }

    @Override
    public void visit(EngProcessedPage n) {
        this.dispatch((AstNode)n.getPage());
    }

    @Override
    public void visit(EngNowiki n) {
        this.wrapText(n.getContent());
    }

    @Override
    public void visit(EngPage n) {
        this.iterate((AstNode)n);
    }

    @Override
    public void visit(EngSoftErrorNode n) {
        this.visit((WtXmlElement)n);
    }

    public void visit(WtBody n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtBold n) {
        this.p.indentAtBol("<b>");
        this.p.incIndent();
        this.iterate((AstNode)n);
        this.p.decIndent();
        this.p.indentAtBol("</b>");
    }

    public void visit(WtDefinitionList n) {
        this.p.indentln("<dl>");
        this.p.incIndent();
        this.iterate((AstNode)n);
        this.p.decIndent();
        this.p.indentln("</dl>");
    }

    public void visit(WtDefinitionListDef n) {
        this.p.indentln("<dd>");
        this.p.incIndent();
        this.iterate((AstNode)n);
        this.p.decIndent();
        this.p.indentln("</dd>");
    }

    public void visit(WtDefinitionListTerm n) {
        this.p.indentln("<dt>");
        this.p.incIndent();
        this.iterate((AstNode)n);
        this.p.decIndent();
        this.p.indentln("</dt>");
    }

    public void visit(WtExternalLink n) {
        if (n.hasTitle()) {
            this.p.indentAtBol();
            this.pt("<a rel=\"nofollow\" class=\"external text\" href=\"%s\">%!</a>", this.callback.makeUrl(n.getTarget()), n.getTitle());
        } else {
            long seqNumber = this.untitledLinkCounter++;
            this.pt("<a rel=\"nofollow\" class=\"external text\" href=\"%s\">[" + seqNumber + "]</a>", this.callback.makeUrl(n.getTarget()));
        }
    }

    public void visit(WtHeading n) {
        throw new AssertionError();
    }

    public void visit(WtHorizontalRule n) {
        this.p.indentAtBol("<hr />");
    }

    public void visit(WtIgnored n) {
    }

    public void visit(WtIllegalCodePoint n) {
        this.p.indentAtBol();
        String cp = n.getCodePoint();
        for (int i = 0; i < cp.length(); ++i) {
            this.pf("&amp;#%d;", cp.charAt(i));
        }
    }

    public void visit(WtImageLink n) {
        boolean hasThumbFrame;
        int altWidth;
        boolean isImage;
        MediaInfo info;
        PageTitle target;
        if (!n.getTarget().isResolved()) {
            this.printAsWikitext((WtNode)n);
            return;
        }
        try {
            target = PageTitle.make(this.wikiConfig, n.getTarget().getAsString());
        }
        catch (LinkTargetException e) {
            throw new VisitingException((Throwable)e);
        }
        int imgWidth = n.getWidth();
        int imgHeight = n.getHeight();
        switch (n.getFormat()) {
            case THUMBNAIL: 
            case FRAMELESS: {
                if (imgWidth > 0) break;
                imgWidth = 180;
                break;
            }
        }
        if (n.getUpright()) {
            imgWidth = 140;
            imgHeight = -1;
        }
        try {
            info = this.callback.getMediaInfo(target.getNormalizedFullTitle(), imgWidth, imgHeight);
        }
        catch (Exception e) {
            throw new VisitingException((Throwable)e);
        }
        boolean exists = info != null && info.getImgUrl() != null;
        boolean bl = isImage = !target.getTitle().endsWith(".ogg");
        if (exists && imgHeight > 0 && (altWidth = imgHeight * info.getImgWidth() / info.getImgHeight()) < imgWidth) {
            imgWidth = altWidth;
            try {
                info = this.callback.getMediaInfo(target.getNormalizedFullTitle(), imgWidth, imgHeight);
            }
            catch (Exception e) {
                throw new VisitingException((Throwable)e);
            }
        }
        boolean scaled = imgWidth > 0 || imgHeight > 0;
        String imgUrl = null;
        if (exists) {
            imgUrl = info.getImgUrl();
            if (scaled && info.getThumbUrl() != null) {
                imgUrl = info.getThumbUrl();
            }
        }
        String aClasses = "";
        String imgClasses = "";
        switch (n.getFormat()) {
            case THUMBNAIL: {
                imgClasses = imgClasses + " thumbimage";
                break;
            }
        }
        if (n.getBorder()) {
            imgClasses = imgClasses + " thumbborder";
        }
        WtUrl linkUrl = null;
        PageTitle linkTarget = target;
        switch (n.getLink().getTargetType()) {
            case NO_LINK: {
                linkTarget = null;
                break;
            }
            case PAGE: {
                WtPageName pageName = (WtPageName)n.getLink().getTarget();
                if (pageName.isResolved()) {
                    try {
                        linkTarget = PageTitle.make(this.wikiConfig, pageName.getAsString());
                        break;
                    }
                    catch (LinkTargetException e) {
                        throw new VisitingException((Throwable)e);
                    }
                }
                linkTarget = null;
                break;
            }
            case URL: {
                linkTarget = null;
                linkUrl = (WtUrl)n.getLink().getTarget();
                break;
            }
            case DEFAULT: {
                if (!exists || !isImage) break;
                aClasses = aClasses + " image";
            }
        }
        String strCaption = null;
        if (n.hasTitle()) {
            strCaption = this.makeImageCaption(n);
        }
        String alt = null;
        if (n.hasAlt()) {
            alt = this.makeImageAltText(n);
        }
        if (!aClasses.isEmpty()) {
            aClasses = String.format(" class=\"%s\"", aClasses.trim());
        }
        String aTitle = "";
        if (n.getFormat() != WtImageLink.ImageViewFormat.FRAMELESS) {
            if (strCaption != null) {
                aTitle = strCaption;
            } else if (linkTarget != null) {
                aTitle = this.makeImageTitle(n, target);
            } else if (linkUrl != null) {
                aTitle = this.callback.makeUrl(linkUrl);
            }
        }
        if (!aTitle.isEmpty()) {
            aTitle = String.format(" title=\"%s\"", aTitle);
        }
        int width = -1;
        int height = -1;
        if (exists) {
            width = scaled ? info.getThumbWidth() : info.getImgWidth();
            height = scaled ? info.getThumbHeight() : info.getImgHeight();
        } else {
            width = 180;
        }
        boolean bl2 = hasThumbFrame = isImage && n.getFormat() == WtImageLink.ImageViewFormat.THUMBNAIL || n.getHAlign() != WtImageLink.ImageHorizAlign.UNSPECIFIED;
        if (hasThumbFrame) {
            String align = "";
            switch (n.getHAlign()) {
                case CENTER: {
                    align = " center";
                    break;
                }
                case LEFT: {
                    align = " tleft";
                    break;
                }
                default: {
                    align = " tright";
                }
            }
            String thumb = "";
            String inner = "floatnone";
            String style = "";
            if (n.getFormat() == WtImageLink.ImageViewFormat.THUMBNAIL) {
                thumb = "thumb";
                inner = "thumbinner";
                style = String.format(" style=\"width:%dpx;\"", width + 2);
            }
            this.p.indent();
            this.pf("<div class=\"%s\">", (thumb + align).trim());
            this.p.incIndent();
            this.p.indent();
            this.pf("<div class=\"%s\"%s>", inner, style);
            this.p.println();
            this.p.incIndent();
            aTitle = "";
            if (!exists) {
                aTitle = String.format(" title=\"%s\"", this.makeImageTitle(n, target));
            }
        } else if (alt == null) {
            alt = strCaption;
        }
        if (alt == null) {
            alt = "";
        }
        this.p.indentAtBol();
        if (linkTarget != null || linkUrl != null) {
            this.pf("<a href=\"%s\"%s%s>", linkTarget != null ? this.callback.makeUrl(linkTarget) : this.callback.makeUrl(linkUrl), aClasses, aTitle);
        }
        if (!imgClasses.isEmpty()) {
            imgClasses = String.format(" class=\"%s\"", imgClasses.trim());
        }
        if (exists) {
            if (isImage) {
                this.pt("<img alt=\"%s\" src=\"%s\" width=\"%d\" height=\"%d\"%s />", alt.trim(), imgUrl, width, height, imgClasses);
            } else {
                this.p.print(HtmlRenderer.esc(this.makeImageTitle(n, target)));
            }
        } else {
            this.p.print(HtmlRenderer.esc(this.makeImageTitle(n, target)));
        }
        if (linkTarget != null || linkUrl != null) {
            this.p.print("</a>");
        }
        if (n.getFormat() == WtImageLink.ImageViewFormat.THUMBNAIL) {
            if (exists) {
                this.p.indentln("<div class=\"thumbcaption\">");
                this.p.incIndent();
                this.p.indentln("<div class=\"magnify\">");
                this.p.incIndent();
                this.p.indent();
                this.pf("<a href=\"%s\" class=\"internal\" title=\"Enlarge\"><img src=\"/mediawiki/skins/common/images/magnify-clip.png\" width=\"15\" height=\"11\" alt=\"\" /></a>", this.callback.makeUrl(linkTarget));
                this.p.decIndent();
                this.p.indentln("</div>");
                this.dispatch((AstNode)n.getTitle());
                this.p.decIndent();
                this.p.indentln("</div>");
            } else {
                this.p.indent();
                this.pt("<div class=\"thumbcaption\">%!</div>", n.getTitle());
            }
        }
        if (hasThumbFrame) {
            this.p.decIndent();
            this.p.indentln("</div>");
            this.p.decIndent();
            this.p.indentln("</div>");
        }
    }

    public void visit(WtImEndTag n) {
        throw new AssertionError();
    }

    public void visit(WtImStartTag n) {
        throw new AssertionError();
    }

    public void visit(WtInternalLink n) {
        PageTitle target;
        if (!n.getTarget().isResolved()) {
            this.printAsWikitext((WtNode)n);
            return;
        }
        this.p.indentAtBol();
        try {
            target = PageTitle.make(this.wikiConfig, n.getTarget().getAsString());
        }
        catch (LinkTargetException e) {
            throw new VisitingException((Throwable)e);
        }
        if (target.getNamespace() == this.wikiConfig.getNamespace("Category")) {
            return;
        }
        if (!this.callback.resourceExists(target)) {
            String title = target.getDenormalizedFullTitle();
            String path = UrlEncoding.WIKI.encode(target.getNormalizedFullTitle());
            if (n.hasTitle()) {
                this.pt("<a href=\"%s\" class=\"new\" title=\"%s (page does not exist)\">%=%!%=</a>", this.callback.makeUrlMissingTarget(path), title, n.getPrefix(), n.getTitle(), n.getPostfix());
            } else {
                String linkText = this.makeTitleFromTarget(n, target);
                this.pt("<a href=\"%s\" class=\"new\" title=\"%s (page does not exist)\">%=%=%=</a>", this.callback.makeUrlMissingTarget(path), title, n.getPrefix(), linkText, n.getPostfix());
            }
        } else if (!target.equals(this.pageTitle)) {
            if (n.hasTitle()) {
                this.pt("<a href=\"%s\" title=\"%s\">%=%!%=</a>", this.callback.makeUrl(target), HtmlRenderer.makeLinkTitle(n, target), n.getPrefix(), n.getTitle(), n.getPostfix());
            } else {
                this.pt("<a href=\"%s\" title=\"%s\">%=%=%=</a>", this.callback.makeUrl(target), HtmlRenderer.makeLinkTitle(n, target), n.getPrefix(), this.makeTitleFromTarget(n, target), n.getPostfix());
            }
        } else if (n.hasTitle()) {
            this.pt("<strong class=\"selflink\">%=%!%=</strong>", n.getPrefix(), n.getTitle(), n.getPostfix());
        } else {
            this.pt("<strong class=\"selflink\">%=%=%=</strong>", n.getPrefix(), this.makeTitleFromTarget(n, target), n.getPostfix());
        }
    }

    public void visit(WtItalics n) {
        this.p.indentAtBol("<i>");
        this.p.incIndent();
        this.iterate((AstNode)n);
        this.p.decIndent();
        this.p.indentAtBol("</i>");
    }

    public void visit(WtLinkOptionAltText n) {
        throw new AssertionError();
    }

    public void visit(WtLinkOptionGarbage n) {
        throw new AssertionError();
    }

    public void visit(WtLinkOptionKeyword n) {
        throw new AssertionError();
    }

    public void visit(WtLinkOptionLinkTarget n) {
        throw new AssertionError();
    }

    public void visit(WtLinkOptionResize n) {
        throw new AssertionError();
    }

    public void visit(WtLinkOptions n) {
        throw new AssertionError();
    }

    public void visit(WtLinkTitle n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtListItem n) {
        this.p.indentln("<li>");
        this.p.incIndent();
        this.iterate((AstNode)n);
        this.p.decIndent();
        this.p.indentln("</li>");
    }

    public void visit(WtName n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtNewline n) {
        if (!this.p.atBol()) {
            this.p.print(" ");
        }
    }

    public void visit(WtNodeList n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtOnlyInclude n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtOrderedList n) {
        this.p.indentln("<ol>");
        this.p.incIndent();
        this.iterate((AstNode)n);
        this.p.decIndent();
        this.p.indentln("</ol>");
    }

    public void visit(WtPageName n) {
        throw new AssertionError();
    }

    public void visit(WtPageSwitch n) {
    }

    public void visit(WtParagraph n) {
        this.p.indentln("<p>");
        this.p.incIndent();
        this.iterate((AstNode)n);
        this.p.decIndent();
        this.p.indentln("</p>");
    }

    public void visit(WtParsedWikitextPage n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtPreproWikitextPage n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtRedirect n) {
        PageTitle pt;
        try {
            pt = PageTitle.make(this.wikiConfig, n.getTarget().getAsString());
        }
        catch (LinkTargetException e) {
            throw new VisitingException((Throwable)e);
        }
        String url = this.callback.makeUrl(pt);
        this.pf("<a href=\"%s\">%s</a>", url, pt.getDenormalizedFullTitle());
    }

    public void visit(WtSection n) {
        this.p.indent();
        this.pt("<h%d><span class=\"mw-headline\" id=\"%s\">%!</span></h%d>", n.getLevel(), this.makeSectionTitle(n.getHeading()), n.getHeading(), n.getLevel());
        this.p.println();
        this.dispatch((AstNode)n.getBody());
    }

    public void visit(WtSemiPre n) {
        this.p.indent();
        ++this.inPre;
        this.pt("<pre>%!</pre>", n);
        --this.inPre;
        this.p.println();
    }

    public void visit(WtSemiPreLine n) {
        this.iterate((AstNode)n);
        this.p.println();
    }

    public void visit(WtSignature n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtTable n) {
        this.p.indent();
        this.pt("<table%!>", this.cleanAttribs((WtNodeList)n.getXmlAttributes()));
        this.p.println();
        this.p.incIndent();
        this.fixTableBody((WtNodeList)n.getBody());
        this.p.decIndent();
        this.p.indentln("</table>");
    }

    public void visit(WtTableCaption n) {
        this.p.indent();
        this.pt("<caption%!>", this.cleanAttribs((WtNodeList)n.getXmlAttributes()));
        this.p.println();
        this.p.incIndent();
        this.dispatch((AstNode)HtmlRenderer.getCellContent((WtNodeList)n.getBody()));
        this.p.decIndent();
        this.p.indentln("</caption>");
    }

    public void visit(WtTableCell n) {
        this.p.indent();
        this.pt("<td%!>", this.cleanAttribs((WtNodeList)n.getXmlAttributes()));
        this.p.println();
        this.p.incIndent();
        this.dispatch((AstNode)HtmlRenderer.getCellContent((WtNodeList)n.getBody()));
        this.p.decIndent();
        this.p.indentln("</td>");
    }

    public void visit(WtTableHeader n) {
        this.p.indent();
        this.pt("<th%!>", this.cleanAttribs((WtNodeList)n.getXmlAttributes()));
        this.p.println();
        this.p.incIndent();
        this.dispatch((AstNode)HtmlRenderer.getCellContent((WtNodeList)n.getBody()));
        this.p.decIndent();
        this.p.indentln("</th>");
    }

    public void visit(WtTableRow n) {
        boolean cellsDefined = false;
        for (WtNode cell : n.getBody()) {
            switch (cell.getNodeType()) {
                case 720914: 
                case 720915: {
                    cellsDefined = true;
                }
            }
        }
        if (cellsDefined) {
            this.p.indent();
            this.pt("<tr%!>", this.cleanAttribs((WtNodeList)n.getXmlAttributes()));
            this.p.println();
            this.p.incIndent();
            this.dispatch((AstNode)HtmlRenderer.getCellContent((WtNodeList)n.getBody()));
            this.p.decIndent();
            this.p.indentln("</tr>");
        } else {
            this.iterate((AstNode)n.getBody());
        }
    }

    public void visit(WtTableImplicitTableBody n) {
        this.iterate((AstNode)n.getBody());
    }

    public void visit(WtTagExtension n) {
        if (n.getName().trim().equalsIgnoreCase("ref")) {
            return;
        }
        if (n.getName().trim().equalsIgnoreCase("references")) {
            return;
        }
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtTagExtensionBody n) {
        throw new AssertionError();
    }

    public void visit(WtTemplate n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtTemplateArgument n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtTemplateArguments n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtTemplateParameter n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtText n) {
        this.wrapText(n.getContent());
    }

    public void visit(WtTicks n) {
        throw new AssertionError();
    }

    public void visit(WtUnorderedList n) {
        this.p.indentln("<ul>");
        this.p.incIndent();
        this.iterate((AstNode)n);
        this.p.decIndent();
        this.p.indentln("</ul>");
    }

    public void visit(WtUrl n) {
        this.p.indentAtBol();
        String url = this.callback.makeUrl(n);
        this.pf("<a href=\"%s\">%s</a>", url, url);
    }

    public void visit(WtValue n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtWhitespace n) {
        if (!this.p.atBol()) {
            this.p.println(" ");
        }
    }

    public void visit(WtXmlAttribute n) {
        if (!n.getName().isResolved()) {
            logger.warn("Unresolved attribute name: " + WtRtDataPrinter.print((WtNode)n));
        } else if (n.hasValue()) {
            this.pt(" %s=\"%~\"", n.getName().getAsString(), this.cleanAttribValue((WtNodeList)n.getValue()));
        } else {
            this.pf(" %s=\"%<s\"", n.getName().getAsString());
        }
    }

    public void visit(WtXmlAttributeGarbage n) {
        logger.warn("Attribute garbage: " + WtRtDataPrinter.print((WtNode)n));
    }

    public void visit(WtXmlAttributes n) {
        block3: for (WtNode n1 : n) {
            switch (n1.getNodeType()) {
                case 720929: 
                case 720930: {
                    this.dispatch((AstNode)n1);
                    continue block3;
                }
            }
            logger.warn("Non-attribute node in attributes collection: " + WtRtDataPrinter.print((WtNode)n));
        }
    }

    public void visit(WtXmlCharRef n) {
        this.p.indentAtBol();
        this.pf("&#%d;", n.getCodePoint());
    }

    public void visit(WtXmlComment n) {
    }

    public void visit(WtXmlElement n) {
        if (n.hasBody()) {
            if (blockElements.contains(n.getName().toLowerCase())) {
                this.p.indent();
                this.pt("<%s%!>", n.getName(), this.cleanAttribs((WtNodeList)n.getXmlAttributes()));
                this.p.println();
                this.p.incIndent();
                this.dispatch((AstNode)n.getBody());
                this.p.decIndent();
                this.p.indent();
                this.pf("</%s>", n.getName());
                this.p.println();
            } else {
                this.p.indentAtBol();
                this.pt("<%s%!>", n.getName(), this.cleanAttribs((WtNodeList)n.getXmlAttributes()));
                this.p.incIndent();
                this.dispatch((AstNode)n.getBody());
                this.p.decIndent();
                this.p.indentAtBol();
                this.pf("</%s>", n.getName());
            }
        } else {
            this.p.indentAtBol();
            this.pt("<%s%! />", n.getName(), this.cleanAttribs((WtNodeList)n.getXmlAttributes()));
        }
    }

    public void visit(WtXmlEmptyTag n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtXmlEndTag n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtXmlEntityRef n) {
        this.p.indentAtBol();
        this.pf("&%s;", n.getName());
    }

    public void visit(WtXmlStartTag n) {
        this.printAsWikitext((WtNode)n);
    }

    private void wrapText(String text) {
        if (this.inPre > 0) {
            this.p.print(HtmlRenderer.esc(text));
        } else {
            this.p.indentAtBol(HtmlRenderer.esc(StringTools.collapseWhitespace((String)text)));
        }
    }

    private void printAsWikitext(WtNode n) {
    }

    private String toWikitext(WtNode value) {
        return "";
    }

    private String makeSectionTitle(WtHeading n) {
        byte[] title;
        try {
            title = this.makeTitleFromNodes((WtNodeList)n).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new VisitingException((Throwable)e);
        }
        StringBuilder b = new StringBuilder();
        for (byte u : title) {
            if (u < 0) {
                b.append('.');
                b.append(String.format("%02X", u));
                continue;
            }
            if (u == 32) {
                b.append('_');
                continue;
            }
            b.append((char)u);
        }
        return b.toString();
    }

    private String makeImageAltText(WtImageLink n) {
        return this.makeTitleFromNodes((WtNodeList)n.getAlt());
    }

    protected String makeImageCaption(WtImageLink n) {
        return this.makeTitleFromNodes((WtNodeList)n.getTitle());
    }

    private String makeTitleFromNodes(WtNodeList titleNode) {
        StringWriter w = new StringWriter();
        SafeLinkTitlePrinter p = new SafeLinkTitlePrinter(w, this.wikiConfig);
        p.go(titleNode);
        return w.toString();
    }

    static String makeLinkTitle(WtInternalLink n, PageTitle target) {
        return target.getDenormalizedFullTitle();
    }

    protected String makeImageTitle(WtImageLink n, PageTitle target) {
        return target.getDenormalizedFullTitle();
    }

    private String makeTitleFromTarget(WtInternalLink n, PageTitle target) {
        return this.makeTitleFromTarget(target, n.getTarget());
    }

    private String makeTitleFromTarget(PageTitle target, WtPageName title) {
        String targetStr = title.getAsString();
        if (target.hasInitialColon() && !targetStr.isEmpty() && targetStr.charAt(0) == ':') {
            targetStr = targetStr.substring(1);
        }
        return targetStr;
    }

    private void fixTableBody(WtNodeList body) {
        boolean hadRow = false;
        WtTableRow implicitRow = null;
        block5: for (WtNode c : body) {
            switch (c.getNodeType()) {
                case 720914: 
                case 720915: {
                    if (hadRow) {
                        this.dispatch((AstNode)c);
                        continue block5;
                    }
                    if (implicitRow == null) {
                        implicitRow = this.nf.tr(this.nf.emptyAttrs(), this.nf.body(this.nf.list()));
                    }
                    implicitRow.getBody().add((Object)c);
                    continue block5;
                }
                case 720912: {
                    if (!hadRow && implicitRow != null) {
                        this.dispatch((AstNode)implicitRow);
                    }
                    implicitRow = null;
                    this.dispatch((AstNode)c);
                    continue block5;
                }
                case 720913: {
                    if (!hadRow && implicitRow != null) {
                        this.dispatch((AstNode)implicitRow);
                    }
                    hadRow = true;
                    this.dispatch((AstNode)c);
                    continue block5;
                }
            }
            if (!hadRow && implicitRow != null) {
                implicitRow.getBody().add((Object)c);
                continue;
            }
            this.dispatch((AstNode)c);
        }
    }

    protected static WtNode getCellContent(WtNodeList body) {
        if (body.size() >= 1 && body.get(0) instanceof WtParagraph) {
            boolean ok = true;
            for (int i = 1; i < body.size(); ++i) {
                if (body.get(i) instanceof WtNewline) continue;
                ok = false;
                break;
            }
            if (ok) {
                body = (WtParagraph)body.get(0);
            }
        }
        return body;
    }

    protected String cleanAttribValue(WtNodeList value) {
        try {
            return StringTools.collapseWhitespace((String)this.tu.astToText((WtNode)value)).trim();
        }
        catch (StringConversionException e) {
            return this.toWikitext((WtNode)value);
        }
    }

    protected WtNodeList cleanAttribs(WtNodeList xmlAttributes) {
        String name;
        ArrayList<WtXmlAttribute> clean = null;
        WtXmlAttribute style = null;
        for (Object a : xmlAttributes) {
            WtXmlAttribute attr;
            if (!(a instanceof WtXmlAttribute) || !(attr = (WtXmlAttribute)a).getName().isResolved()) continue;
            name = attr.getName().getAsString().toLowerCase();
            if (name.equals("style")) {
                style = attr;
                continue;
            }
            if (name.equals("width")) {
                if (clean == null) {
                    clean = new ArrayList<WtXmlAttribute>();
                }
                clean.add(attr);
                continue;
            }
            if (!name.equals("align")) continue;
            if (clean == null) {
                clean = new ArrayList();
            }
            clean.add(attr);
        }
        if (clean == null || clean.isEmpty()) {
            return xmlAttributes;
        }
        String newStyle = "";
        if (style != null) {
            newStyle = this.cleanAttribValue((WtNodeList)style.getValue());
        }
        for (WtXmlAttribute a : clean) {
            if (!a.getName().isResolved()) continue;
            name = a.getName().getAsString().toLowerCase();
            if (name.equals("align")) {
                newStyle = String.format("text-align: %s; ", this.cleanAttribValue((WtNodeList)a.getValue())) + newStyle;
                continue;
            }
            newStyle = String.format("%s: %s; ", name, this.cleanAttribValue((WtNodeList)a.getValue())) + newStyle;
        }
        WtXmlAttribute newStyleAttrib = this.nf.attr(this.nf.name(this.nf.list((WtNode)this.nf.text("style"))), this.nf.value(this.nf.list((WtNode)this.nf.text(newStyle))));
        WtXmlAttributes newAttribs = this.nf.attrs(this.nf.list());
        for (WtNode a : xmlAttributes) {
            if (a == style) {
                newAttribs.add((Object)newStyleAttrib);
                continue;
            }
            if (clean.contains(a)) continue;
            newAttribs.add((Object)a);
        }
        if (style == null) {
            newAttribs.add((Object)newStyleAttrib);
        }
        return newAttribs;
    }

    public static <T extends WtNode> String print(HtmlRendererCallback callback, WikiConfig wikiConfig, PageTitle pageTitle, T node) {
        return HtmlRenderer.print(callback, wikiConfig, new StringWriter(), pageTitle, node).toString();
    }

    public static <T extends WtNode> Writer print(HtmlRendererCallback callback, WikiConfig wikiConfig, Writer writer, PageTitle pageTitle, T node) {
        new HtmlRenderer(callback, wikiConfig, pageTitle, writer).go(node);
        return writer;
    }

    protected HtmlRenderer(HtmlRendererCallback callback, WikiConfig wikiConfig, PageTitle pageTitle, Writer w) {
        super(w);
        this.callback = callback;
        this.wikiConfig = wikiConfig;
        this.pageTitle = pageTitle;
        this.nf = wikiConfig.getNodeFactory();
        this.tu = wikiConfig.getAstTextUtils();
    }

    static {
        blockElements.add("div");
        blockElements.add("address");
        blockElements.add("blockquote");
        blockElements.add("center");
        blockElements.add("dir");
        blockElements.add("div");
        blockElements.add("dl");
        blockElements.add("fieldset");
        blockElements.add("form");
        blockElements.add("h1");
        blockElements.add("h2");
        blockElements.add("h3");
        blockElements.add("h4");
        blockElements.add("h5");
        blockElements.add("h6");
        blockElements.add("hr");
        blockElements.add("isindex");
        blockElements.add("menu");
        blockElements.add("noframes");
        blockElements.add("noscript");
        blockElements.add("ol");
        blockElements.add("p");
        blockElements.add("pre");
        blockElements.add("table");
        blockElements.add("ul");
        blockElements.add("center");
        blockElements.add("caption");
        blockElements.add("tr");
        blockElements.add("td");
        blockElements.add("th");
        blockElements.add("colgroup");
        blockElements.add("thead");
        blockElements.add("tbody");
        blockElements.add("tfoot");
    }
}

