/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.output;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.utils.PrinterBase;
import de.fau.cs.osr.utils.StringTools;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.sweble.wikitext.parser.nodes.WtNode;

public class HtmlRendererBase
extends AstVisitor<WtNode> {
    protected final PrinterBase p;

    protected HtmlRendererBase(Writer writer) {
        this.p = new PrinterBase(writer);
        this.p.setMemoize(false);
    }

    protected static String esc(String content) {
        return StringTools.escHtml((String)content);
    }

    protected static String esc(String content, boolean forAttribute) {
        return StringTools.escHtml((String)content, (boolean)forAttribute);
    }

    protected static String capitalize(String text) {
        return StringUtils.capitalize((String)text);
    }

    protected void pf(String format, Object ... args) {
        this.p.print(String.format(format, args));
    }

    protected void pt(String format, Object ... args) {
        ArrayList<Object> a = new ArrayList<Object>(args.length);
        int arg = 0;
        int last = 0;
        for (int i = 0; i < format.length(); ++i) {
            char ch = format.charAt(i);
            if (ch != '%' || format.length() <= i + 1) continue;
            char ch2 = format.charAt(i + 1);
            switch (ch2) {
                case '!': {
                    this.printPart(format, a, last, i);
                    last = i + 2;
                    WtNode n = (WtNode)args[arg++];
                    if (n.isList()) {
                        this.iterate((AstNode)n);
                        break;
                    }
                    this.dispatch((AstNode)n);
                    break;
                }
                case '=': 
                case '~': {
                    this.printPart(format, a, last, i);
                    last = i + 2;
                    String s = (String)args[arg++];
                    this.p.print(HtmlRendererBase.esc(s, ch2 == '~'));
                    break;
                }
                case '%': {
                    break;
                }
                default: {
                    a.add(args[arg++]);
                }
            }
            ++i;
        }
        this.printPart(format, a, last, format.length());
    }

    private void printPart(String format, ArrayList<Object> a, int last, int i) {
        if (i - last > 0) {
            String f = format.substring(last, i);
            if (a.isEmpty()) {
                this.p.print(f);
            } else {
                this.p.print(String.format(f, a.toArray()));
                a.clear();
            }
        }
    }
}

