/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.output;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.utils.FmtNotYetImplementedError;
import de.fau.cs.osr.utils.visitor.VisitingException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.nodes.CompleteEngineVisitorNoReturn;
import org.sweble.wikitext.engine.nodes.EngNowiki;
import org.sweble.wikitext.engine.nodes.EngPage;
import org.sweble.wikitext.engine.nodes.EngProcessedPage;
import org.sweble.wikitext.engine.nodes.EngSoftErrorNode;
import org.sweble.wikitext.engine.output.HtmlRenderer;
import org.sweble.wikitext.engine.output.HtmlRendererBase;
import org.sweble.wikitext.parser.nodes.WtBody;
import org.sweble.wikitext.parser.nodes.WtBold;
import org.sweble.wikitext.parser.nodes.WtDefinitionList;
import org.sweble.wikitext.parser.nodes.WtDefinitionListDef;
import org.sweble.wikitext.parser.nodes.WtDefinitionListTerm;
import org.sweble.wikitext.parser.nodes.WtExternalLink;
import org.sweble.wikitext.parser.nodes.WtHeading;
import org.sweble.wikitext.parser.nodes.WtHorizontalRule;
import org.sweble.wikitext.parser.nodes.WtIgnored;
import org.sweble.wikitext.parser.nodes.WtIllegalCodePoint;
import org.sweble.wikitext.parser.nodes.WtImEndTag;
import org.sweble.wikitext.parser.nodes.WtImStartTag;
import org.sweble.wikitext.parser.nodes.WtImageLink;
import org.sweble.wikitext.parser.nodes.WtInternalLink;
import org.sweble.wikitext.parser.nodes.WtItalics;
import org.sweble.wikitext.parser.nodes.WtLinkOptionAltText;
import org.sweble.wikitext.parser.nodes.WtLinkOptionGarbage;
import org.sweble.wikitext.parser.nodes.WtLinkOptionKeyword;
import org.sweble.wikitext.parser.nodes.WtLinkOptionLinkTarget;
import org.sweble.wikitext.parser.nodes.WtLinkOptionResize;
import org.sweble.wikitext.parser.nodes.WtLinkOptions;
import org.sweble.wikitext.parser.nodes.WtLinkTitle;
import org.sweble.wikitext.parser.nodes.WtListItem;
import org.sweble.wikitext.parser.nodes.WtName;
import org.sweble.wikitext.parser.nodes.WtNewline;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtOnlyInclude;
import org.sweble.wikitext.parser.nodes.WtOrderedList;
import org.sweble.wikitext.parser.nodes.WtPageName;
import org.sweble.wikitext.parser.nodes.WtPageSwitch;
import org.sweble.wikitext.parser.nodes.WtParagraph;
import org.sweble.wikitext.parser.nodes.WtParsedWikitextPage;
import org.sweble.wikitext.parser.nodes.WtPreproWikitextPage;
import org.sweble.wikitext.parser.nodes.WtRedirect;
import org.sweble.wikitext.parser.nodes.WtSection;
import org.sweble.wikitext.parser.nodes.WtSemiPre;
import org.sweble.wikitext.parser.nodes.WtSemiPreLine;
import org.sweble.wikitext.parser.nodes.WtSignature;
import org.sweble.wikitext.parser.nodes.WtTable;
import org.sweble.wikitext.parser.nodes.WtTableCaption;
import org.sweble.wikitext.parser.nodes.WtTableCell;
import org.sweble.wikitext.parser.nodes.WtTableHeader;
import org.sweble.wikitext.parser.nodes.WtTableImplicitTableBody;
import org.sweble.wikitext.parser.nodes.WtTableRow;
import org.sweble.wikitext.parser.nodes.WtTagExtension;
import org.sweble.wikitext.parser.nodes.WtTagExtensionBody;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.nodes.WtTemplateArgument;
import org.sweble.wikitext.parser.nodes.WtTemplateArguments;
import org.sweble.wikitext.parser.nodes.WtTemplateParameter;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtTicks;
import org.sweble.wikitext.parser.nodes.WtUnorderedList;
import org.sweble.wikitext.parser.nodes.WtUrl;
import org.sweble.wikitext.parser.nodes.WtValue;
import org.sweble.wikitext.parser.nodes.WtWhitespace;
import org.sweble.wikitext.parser.nodes.WtXmlAttribute;
import org.sweble.wikitext.parser.nodes.WtXmlAttributeGarbage;
import org.sweble.wikitext.parser.nodes.WtXmlAttributes;
import org.sweble.wikitext.parser.nodes.WtXmlCharRef;
import org.sweble.wikitext.parser.nodes.WtXmlComment;
import org.sweble.wikitext.parser.nodes.WtXmlElement;
import org.sweble.wikitext.parser.nodes.WtXmlEmptyTag;
import org.sweble.wikitext.parser.nodes.WtXmlEndTag;
import org.sweble.wikitext.parser.nodes.WtXmlEntityRef;
import org.sweble.wikitext.parser.nodes.WtXmlStartTag;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.utils.WtRtDataPrinter;

public class SafeLinkTitlePrinter
extends HtmlRendererBase
implements CompleteEngineVisitorNoReturn {
    private static final Logger logger = LoggerFactory.getLogger(HtmlRenderer.class);
    private final WikiConfig wikiConfig;

    @Override
    public void visit(EngProcessedPage n) {
        this.dispatch((AstNode)n.getPage());
    }

    @Override
    public void visit(EngNowiki n) {
        this.p.print(SafeLinkTitlePrinter.esc(n.getContent(), true));
    }

    @Override
    public void visit(EngPage n) {
        this.iterate((AstNode)n);
    }

    @Override
    public void visit(EngSoftErrorNode n) {
        this.visit((WtXmlElement)n);
    }

    public void visit(WtBody n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtBold n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtDefinitionList n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtDefinitionListDef n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtDefinitionListTerm n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtExternalLink n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtHeading n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtHorizontalRule n) {
    }

    public void visit(WtIgnored n) {
    }

    public void visit(WtIllegalCodePoint n) {
        String cp = n.getCodePoint();
        for (int i = 0; i < cp.length(); ++i) {
            this.pf("&amp;#%d;", cp.charAt(i));
        }
    }

    public void visit(WtImageLink n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtImEndTag n) {
        throw new AssertionError();
    }

    public void visit(WtImStartTag n) {
        throw new AssertionError();
    }

    public void visit(WtInternalLink n) {
        if (n.hasTitle()) {
            this.dispatch((AstNode)n.getTitle());
        } else {
            PageTitle target;
            String linkTarget = n.getTarget().getAsString();
            try {
                target = PageTitle.make(this.wikiConfig, linkTarget);
            }
            catch (LinkTargetException e) {
                throw new VisitingException((Throwable)e);
            }
            this.p.print(SafeLinkTitlePrinter.esc(HtmlRenderer.makeLinkTitle(n, target), true));
        }
    }

    public void visit(WtItalics n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtLinkOptionAltText n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtLinkOptionGarbage n) {
        throw new AssertionError();
    }

    public void visit(WtLinkOptionKeyword n) {
        throw new AssertionError();
    }

    public void visit(WtLinkOptionLinkTarget n) {
        throw new AssertionError();
    }

    public void visit(WtLinkOptionResize n) {
        throw new AssertionError();
    }

    public void visit(WtLinkOptions n) {
        throw new AssertionError();
    }

    public void visit(WtLinkTitle n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtListItem n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtName n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtNewline n) {
        this.p.print(" ");
    }

    public void visit(WtNodeList n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtOnlyInclude n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtOrderedList n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtPageName n) {
        throw new AssertionError();
    }

    public void visit(WtPageSwitch n) {
    }

    public void visit(WtParagraph n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtParsedWikitextPage n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtPreproWikitextPage n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtRedirect n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtSection n) {
        this.dispatch((AstNode)n.getHeading());
        this.dispatch((AstNode)n.getBody());
    }

    public void visit(WtSemiPre n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtSemiPreLine n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtSignature n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtTable n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtTableCaption n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtTableCell n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtTableHeader n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtTableRow n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtTableImplicitTableBody n) {
        this.iterate((AstNode)n.getBody());
    }

    public void visit(WtTagExtension n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtTagExtensionBody n) {
        throw new AssertionError();
    }

    public void visit(WtTemplate n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtTemplateArgument n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtTemplateArguments n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtTemplateParameter n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtText n) {
        this.p.print(SafeLinkTitlePrinter.esc(n.getContent(), true));
    }

    public void visit(WtTicks n) {
        throw new AssertionError();
    }

    public void visit(WtUnorderedList n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtUrl n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtValue n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtWhitespace n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtXmlAttribute n) {
        throw new FmtNotYetImplementedError();
    }

    public void visit(WtXmlAttributeGarbage n) {
        logger.warn("Attribute garbage: " + WtRtDataPrinter.print((WtNode)n));
    }

    public void visit(WtXmlAttributes n) {
        this.iterate((AstNode)n);
    }

    public void visit(WtXmlCharRef n) {
        this.pf("&#%d;", n.getCodePoint());
    }

    public void visit(WtXmlComment n) {
    }

    public void visit(WtXmlElement n) {
        this.iterate((AstNode)n.getBody());
    }

    public void visit(WtXmlEmptyTag n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtXmlEndTag n) {
        this.printAsWikitext((WtNode)n);
    }

    public void visit(WtXmlEntityRef n) {
        this.pf("&%s;", n.getName());
    }

    public void visit(WtXmlStartTag n) {
        this.printAsWikitext((WtNode)n);
    }

    private void printAsWikitext(WtNode n) {
        this.p.indentAtBol(SafeLinkTitlePrinter.esc(WtRtDataPrinter.print((WtNode)n)));
    }

    public SafeLinkTitlePrinter(Writer writer, WikiConfig wikiConfig) {
        super(writer);
        this.wikiConfig = wikiConfig;
    }
}

